/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/mobile/beads/TabbedViewManagerView.as
 * org.apache.flex.mobile.beads.TabbedViewManagerView
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.mobile.beads.TabbedViewManagerView');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.mobile.beads.ViewManagerViewBase');
goog.require('org.apache.flex.mobile.chrome.TabBar');
goog.require('org.apache.flex.mobile.models.ViewManagerModel');
goog.require('org.apache.flex.core.IBeadModel');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 * Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.mobile.beads.ViewManagerViewBase}
 */
org.apache.flex.mobile.beads.TabbedViewManagerView = function() {
  org.apache.flex.mobile.beads.TabbedViewManagerView.base(this, 'constructor');
};
goog.inherits(org.apache.flex.mobile.beads.TabbedViewManagerView, org.apache.flex.mobile.beads.ViewManagerViewBase);


/**
 * @private
 * @type {org.apache.flex.mobile.chrome.TabBar}
 */
org.apache.flex.mobile.beads.TabbedViewManagerView.prototype._tabBar;


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.mobile.beads.TabbedViewManagerView.prototype._strand;


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.mobile.beads.TabbedViewManagerView.prototype.handleButtonBarChange = function(event) {
  var /** @type {number} */ newIndex = this._tabBar.selectedIndex;
  var /** @type {org.apache.flex.mobile.models.ViewManagerModel} */ model = org.apache.flex.utils.Language.as(this.strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.mobile.models.ViewManagerModel);
  model.selectedIndex = newIndex;
};


/**
 * @asprivate
 * @protected
 * @override
 */
org.apache.flex.mobile.beads.TabbedViewManagerView.prototype.layoutChromeElements = function() {
  var /** @type {org.apache.flex.core.UIBase} */ host = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase);
  var /** @type {number} */ contentAreaY = 0;
  var /** @type {number} */ contentAreaHeight = host.height;
  var /** @type {org.apache.flex.mobile.models.ViewManagerModel} */ model = org.apache.flex.utils.Language.as(this.strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.mobile.models.ViewManagerModel);
  if (this.navigationBar) {
    this.navigationBar.x = 0;
    this.navigationBar.y = 0;
    this.navigationBar.width = host.width;
    contentAreaHeight -= this.navigationBar.height;
    contentAreaY = this.navigationBar.height;
    model.navigationBar = this.navigationBar;
  }
  if (this._tabBar) {
    this._tabBar.x = 0;
    this._tabBar.y = host.height - this._tabBar.height;
    this._tabBar.width = host.width;
    this._tabBar.dispatchEvent(new org.apache.flex.events.Event("layoutNeeded"));
    contentAreaHeight -= this._tabBar.height;
    model.tabBar = this._tabBar;
  }
  model.contentX = 0;
  model.contentY = contentAreaY;
  model.contentWidth = host.width;
  model.contentHeight = contentAreaHeight;
  this.sizeViewsToFitContentArea();
  org.apache.flex.utils.Language.as(this.strand, org.apache.flex.events.IEventDispatcher, true).dispatchEvent(new org.apache.flex.events.Event("contentSizeChanged"));
};


Object.defineProperties(org.apache.flex.mobile.beads.TabbedViewManagerView.prototype, /** @lends {org.apache.flex.mobile.beads.TabbedViewManagerView.prototype} */ {
/** @export */
strand: {
get: /** @this {org.apache.flex.mobile.beads.TabbedViewManagerView} */ function() {
  return this._strand;
},
set: /** @this {org.apache.flex.mobile.beads.TabbedViewManagerView} */ function(value) {
  this._strand = value;
  var /** @type {org.apache.flex.mobile.models.ViewManagerModel} */ model = org.apache.flex.utils.Language.as(value.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.mobile.models.ViewManagerModel);
  this._tabBar = new org.apache.flex.mobile.chrome.TabBar();
  this._tabBar.dataProvider = model.views;
  this._tabBar.labelField = "title";
  this._tabBar.addEventListener("change", org.apache.flex.utils.Language.closure(this.handleButtonBarChange, this, 'handleButtonBarChange'));
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true).addElement(this._tabBar, false);
  org.apache.flex.utils.Language.superSetter(org.apache.flex.mobile.beads.TabbedViewManagerView, this, 'strand', value);
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.mobile.beads.TabbedViewManagerView.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'TabbedViewManagerView', qName: 'org.apache.flex.mobile.beads.TabbedViewManagerView'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.mobile.beads.TabbedViewManagerView', org.apache.flex.mobile.beads.TabbedViewManagerView);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.mobile.beads.TabbedViewManagerView.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.mobile.beads.TabbedViewManagerView'}
      };
    },
    methods: function () {
      return {
        'TabbedViewManagerView': { type: '', declaredBy: 'org.apache.flex.mobile.beads.TabbedViewManagerView'}
      };
    }
  };
};