/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/supportClasses/Viewport.as
 * org.apache.flex.html.supportClasses.Viewport
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.supportClasses.Viewport');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.geom.Size');
goog.require('org.apache.flex.utils.CSSContainerUtils');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.IContentView');
goog.require('org.apache.flex.core.IUIBase');
goog.require('org.apache.flex.core.IViewport');
goog.require('org.apache.flex.utils.Language');



/**
 * Constructor
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBead}
 * @implements {org.apache.flex.core.IViewport}
 */
org.apache.flex.html.supportClasses.Viewport = function() {
};


/**
 * @protected
 * @type {org.apache.flex.core.UIBase}
 */
org.apache.flex.html.supportClasses.Viewport.prototype.contentArea;


/**
 * @protected
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.html.supportClasses.Viewport.prototype._strand;


/**
 * @copy org.apache.flex.core.IViewport#setPosition()
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {number} x
 * @param {number} y
 */
org.apache.flex.html.supportClasses.Viewport.prototype.setPosition = function(x, y) {
  this.contentArea.x = x;
  this.contentArea.y = y;
};


/**
 * @copy org.apache.flex.core.IViewport#layoutViewportBeforeContentLayout()
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {number} width
 * @param {number} height
 */
org.apache.flex.html.supportClasses.Viewport.prototype.layoutViewportBeforeContentLayout = function(width, height) {
  if (!isNaN(width))
    this.contentArea.width = width;
  if (!isNaN(height))
    this.contentArea.height = height;
};


/**
 * @copy org.apache.flex.core.IViewport#layoutViewportAfterContentLayout()
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @return {org.apache.flex.geom.Size}
 */
org.apache.flex.html.supportClasses.Viewport.prototype.layoutViewportAfterContentLayout = function() {
  var /** @type {number} */ maxWidth = 0;
  var /** @type {number} */ maxHeight = 0;
  var /** @type {number} */ num = this.contentArea.numElements;
  for (var /** @type {number} */ i = 0; i < num; i++) {
    var /** @type {org.apache.flex.core.IUIBase} */ child = org.apache.flex.utils.Language.as(this.contentArea.getElementAt(i), org.apache.flex.core.IUIBase);
    if (child == null || !child.visible)
      continue;
    var /** @type {number} */ childXMax = child.x + child.width;
    var /** @type {number} */ childYMax = child.y + child.height;
    maxWidth = Math.max(maxWidth, childXMax);
    maxHeight = Math.max(maxHeight, childYMax);
  }
  var /** @type {org.apache.flex.geom.Rectangle} */ padding = org.apache.flex.utils.CSSContainerUtils.getPaddingMetrics(this._strand);
  return new org.apache.flex.geom.Size(maxWidth + padding.right, maxHeight + padding.bottom);
};


Object.defineProperties(org.apache.flex.html.supportClasses.Viewport.prototype, /** @lends {org.apache.flex.html.supportClasses.Viewport.prototype} */ {
/** @export */
contentView: {
get: /** @this {org.apache.flex.html.supportClasses.Viewport} */ function() {
  return this.contentArea;
}},
/** @export */
strand: {
set: /** @this {org.apache.flex.html.supportClasses.Viewport} */ function(value) {
  this._strand = value;
  this.contentArea = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IContentView), org.apache.flex.core.UIBase);
  if (!this.contentArea) {
    var /** @type {Object} */ c = org.apache.flex.core.ValuesManager.valuesImpl.getValue(this._strand, 'iContentView');
    this.contentArea = org.apache.flex.utils.Language.as(new c(), org.apache.flex.core.UIBase);
  }
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.supportClasses.Viewport.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Viewport', qName: 'org.apache.flex.html.supportClasses.Viewport'}], interfaces: [org.apache.flex.core.IBead, org.apache.flex.core.IViewport] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.supportClasses.Viewport', org.apache.flex.html.supportClasses.Viewport);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.supportClasses.Viewport.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'contentView': { type: 'IUIBase', declaredBy: 'org.apache.flex.html.supportClasses.Viewport'},
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.supportClasses.Viewport'}
      };
    },
    methods: function () {
      return {
        'Viewport': { type: '', declaredBy: 'org.apache.flex.html.supportClasses.Viewport'},
        'setPosition': { type: 'void', declaredBy: 'org.apache.flex.html.supportClasses.Viewport'},
        'layoutViewportBeforeContentLayout': { type: 'void', declaredBy: 'org.apache.flex.html.supportClasses.Viewport'},
        'layoutViewportAfterContentLayout': { type: 'Size', declaredBy: 'org.apache.flex.html.supportClasses.Viewport'}
      };
    }
  };
};