/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/supportClasses/ButtonBarButtonItemRenderer.as
 * org.apache.flex.html.supportClasses.ButtonBarButtonItemRenderer
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.supportClasses.ButtonBarButtonItemRenderer');

goog.require('org.apache.flex.events.ItemClickedEvent');
goog.require('org.apache.flex.html.TextButton');
goog.require('org.apache.flex.html.supportClasses.UIItemRendererBase');
goog.require('org.apache.flex.html.beads.ITextItemRenderer');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.html.supportClasses.UIItemRendererBase}
 * @implements {org.apache.flex.html.beads.ITextItemRenderer}
 */
org.apache.flex.html.supportClasses.ButtonBarButtonItemRenderer = function() {
  org.apache.flex.html.supportClasses.ButtonBarButtonItemRenderer.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.supportClasses.ButtonBarButtonItemRenderer, org.apache.flex.html.supportClasses.UIItemRendererBase);


/**
 * @protected
 * @type {org.apache.flex.html.TextButton}
 */
org.apache.flex.html.supportClasses.ButtonBarButtonItemRenderer.prototype.textButton;


/**
 * @asprivate
 * @export
 * @override
 */
org.apache.flex.html.supportClasses.ButtonBarButtonItemRenderer.prototype.addedToParent = function() {
  org.apache.flex.html.supportClasses.ButtonBarButtonItemRenderer.base(this, 'addedToParent');
};


/**
 * @asprivate
 * @protected
 * @param {org.apache.flex.events.MouseEvent} event
 */
org.apache.flex.html.supportClasses.ButtonBarButtonItemRenderer.prototype.handleClickEvent = function(event) {
  var /** @type {org.apache.flex.events.ItemClickedEvent} */ newEvent = new org.apache.flex.events.ItemClickedEvent("itemClicked");
  newEvent.multipleSelection = event.shiftKey;
  newEvent.index = this.index;
  newEvent.data = this.data;
  this.dispatchEvent(newEvent);
};


/**
 * @asprivate
 * @export
 * @override
 */
org.apache.flex.html.supportClasses.ButtonBarButtonItemRenderer.prototype.adjustSize = function() {
  this.textButton.width = this.width;
  this.textButton.height = this.height;
  this.updateRenderer();
};


Object.defineProperties(org.apache.flex.html.supportClasses.ButtonBarButtonItemRenderer.prototype, /** @lends {org.apache.flex.html.supportClasses.ButtonBarButtonItemRenderer.prototype} */ {
/** @export */
text: {
get: /** @this {org.apache.flex.html.supportClasses.ButtonBarButtonItemRenderer} */ function() {
  return org.apache.flex.utils.Language.as(this.data, String);
},
set: /** @this {org.apache.flex.html.supportClasses.ButtonBarButtonItemRenderer} */ function(value) {
  this.data = value;
}},
/** @export */
data: {
get: /** @this {org.apache.flex.html.supportClasses.ButtonBarButtonItemRenderer} */ function() {
return org.apache.flex.utils.Language.superGetter(org.apache.flex.html.supportClasses.ButtonBarButtonItemRenderer, this, 'data');
},
set: /** @this {org.apache.flex.html.supportClasses.ButtonBarButtonItemRenderer} */ function(value) {
  org.apache.flex.utils.Language.superSetter(org.apache.flex.html.supportClasses.ButtonBarButtonItemRenderer, this, 'data', value);
  var /** @type {boolean} */ added = false;
  if (this.textButton == null) {
    this.textButton = new org.apache.flex.html.TextButton();
    this.textButton.addEventListener('click', org.apache.flex.utils.Language.closure(this.handleClickEvent, this, 'handleClickEvent'));
    added = true;
  }
  var /** @type {string} */ valueAsString;
  if (org.apache.flex.utils.Language.is(value, String)) {
    valueAsString = org.apache.flex.utils.Language.as(value, String);
  } else if (value.hasOwnProperty("label")) {
    valueAsString = String(value["label"]);
  } else if (value.hasOwnProperty("title")) {
    valueAsString = String(value["title"]);
  }
  if (valueAsString)
    this.textButton.text = valueAsString;
  if (added)
    this.addElement(this.textButton);
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.supportClasses.ButtonBarButtonItemRenderer.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ButtonBarButtonItemRenderer', qName: 'org.apache.flex.html.supportClasses.ButtonBarButtonItemRenderer'}], interfaces: [org.apache.flex.html.beads.ITextItemRenderer] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.supportClasses.ButtonBarButtonItemRenderer', org.apache.flex.html.supportClasses.ButtonBarButtonItemRenderer);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.supportClasses.ButtonBarButtonItemRenderer.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'text': { type: 'String', declaredBy: 'org.apache.flex.html.supportClasses.ButtonBarButtonItemRenderer'},
        'data': { type: 'Object', declaredBy: 'org.apache.flex.html.supportClasses.ButtonBarButtonItemRenderer'}
      };
    },
    methods: function () {
      return {
        'ButtonBarButtonItemRenderer': { type: '', declaredBy: 'org.apache.flex.html.supportClasses.ButtonBarButtonItemRenderer'},
        'addedToParent': { type: 'void', declaredBy: 'org.apache.flex.html.supportClasses.ButtonBarButtonItemRenderer'},
        'adjustSize': { type: 'void', declaredBy: 'org.apache.flex.html.supportClasses.ButtonBarButtonItemRenderer'}
      };
    }
  };
};