/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/graphics/PathBuilder.as
 * org.apache.flex.graphics.PathBuilder
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.graphics.PathBuilder');

goog.require('org.apache.flex.graphics.CubicCurve');
goog.require('org.apache.flex.graphics.LineTo');
goog.require('org.apache.flex.graphics.MoveTo');
goog.require('org.apache.flex.graphics.QuadraticCurve');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @constructor
 */
org.apache.flex.graphics.PathBuilder = function() {
  this.commands = new Array();
};


/**
 * @export
 * @return {string}
 */
org.apache.flex.graphics.PathBuilder.prototype.getPathString = function() {
  return this.commands.join(" ");
};


/**
 * @export
 * @param {Object} ctx
 */
org.apache.flex.graphics.PathBuilder.prototype.draw = function(ctx) {
  var /** @type {number} */ i = -1;
  var /** @type {number} */ len = this.commands.length;
  while (++i < len) {
    this.commands[i].execute(ctx);
  }
};


/**
 * @private
 * @type {Array}
 */
org.apache.flex.graphics.PathBuilder.prototype.commands;


/**
 * @export
 * @param {number} x
 * @param {number} y
 */
org.apache.flex.graphics.PathBuilder.prototype.lineTo = function(x, y) {
  this.commands.push(new org.apache.flex.graphics.LineTo(x, y));
};


/**
 * @export
 * @param {number} x
 * @param {number} y
 */
org.apache.flex.graphics.PathBuilder.prototype.moveTo = function(x, y) {
  this.commands.push(new org.apache.flex.graphics.MoveTo(x, y));
};


/**
 * @export
 * @param {number} controlX
 * @param {number} controlY
 * @param {number} anchorX
 * @param {number} anchorY
 */
org.apache.flex.graphics.PathBuilder.prototype.quadraticCurveTo = function(controlX, controlY, anchorX, anchorY) {
  this.commands.push(new org.apache.flex.graphics.QuadraticCurve(controlX, controlY, anchorX, anchorY));
};


/**
 * @export
 * @param {number} controlX1
 * @param {number} controlY1
 * @param {number} controlX2
 * @param {number} controlY2
 * @param {number} anchorX
 * @param {number} anchorY
 */
org.apache.flex.graphics.PathBuilder.prototype.cubicCurveTo = function(controlX1, controlY1, controlX2, controlY2, anchorX, anchorY) {
  this.commands.push(new org.apache.flex.graphics.CubicCurve(controlX1, controlY1, controlX2, controlY2, anchorX, anchorY));
};


/**
 * @export
 * @param {number} x
 * @param {number} y
 * @param {number} width
 * @param {number} height
 * @param {number} topLeftRadius
 * @param {number} topRightRadius
 * @param {number} bottomLeftRadius
 * @param {number} bottomRightRadius
 */
org.apache.flex.graphics.PathBuilder.prototype.drawRoundRectComplex = function(x, y, width, height, topLeftRadius, topRightRadius, bottomLeftRadius, bottomRightRadius) {
  var /** @type {Array} */ b = [];
  var /** @type {number} */ xw = x + width;
  var /** @type {number} */ yh = y + height;
  var /** @type {number} */ minSize = width < height ? width * 2 : height * 2;
  topLeftRadius = topLeftRadius < minSize ? topLeftRadius : minSize;
  topRightRadius = topRightRadius < minSize ? topRightRadius : minSize;
  bottomLeftRadius = bottomLeftRadius < minSize ? bottomLeftRadius : minSize;
  bottomRightRadius = bottomRightRadius < minSize ? bottomRightRadius : minSize;
  var /** @type {number} */ a = bottomRightRadius * 0.292893218813453;
  var /** @type {number} */ s = bottomRightRadius * 0.585786437626905;
  this.commands.push(new org.apache.flex.graphics.MoveTo(xw, yh - bottomRightRadius));
  this.commands.push(new org.apache.flex.graphics.QuadraticCurve(xw, yh - s, xw - a, yh - a));
  this.commands.push(new org.apache.flex.graphics.QuadraticCurve(xw - s, yh, xw - bottomRightRadius, yh));
  a = bottomLeftRadius * 0.292893218813453;
  s = bottomLeftRadius * 0.585786437626905;
  this.commands.push(new org.apache.flex.graphics.LineTo(x + bottomLeftRadius, yh));
  this.commands.push(new org.apache.flex.graphics.QuadraticCurve(x + s, yh, x + a, yh - a));
  this.commands.push(new org.apache.flex.graphics.QuadraticCurve(x, yh - s, x, yh - bottomLeftRadius));
  a = topLeftRadius * 0.292893218813453;
  s = topLeftRadius * 0.585786437626905;
  this.commands.push(new org.apache.flex.graphics.LineTo(x, y + topLeftRadius));
  this.commands.push(new org.apache.flex.graphics.QuadraticCurve(x, y + s, x + a, y + a));
  this.commands.push(new org.apache.flex.graphics.QuadraticCurve(x + s, y, x + topLeftRadius, y));
  a = topRightRadius * 0.292893218813453;
  s = topRightRadius * 0.585786437626905;
  this.commands.push(new org.apache.flex.graphics.LineTo(xw - topRightRadius, y));
  this.commands.push(new org.apache.flex.graphics.QuadraticCurve(xw - s, y, xw - a, y + a));
  this.commands.push(new org.apache.flex.graphics.QuadraticCurve(xw, y + s, xw, y + topRightRadius));
  this.commands.push(new org.apache.flex.graphics.LineTo(xw, yh - bottomRightRadius));
};


/**
 * Draws a rounded rectangle using the size of individual x and y radii to 
 * draw the rounded corners. 
 * 
 * @asparam x The horizontal position relative to the 
 * registration point of the parent display object, in pixels.
 * 
 * @asparam y The vertical position relative to the 
 * registration point of the parent display object, in pixels.
 * 
 * @asparam width The width of the round rectangle, in pixels.
 * 
 * @asparam height The height of the round rectangle, in pixels.
 * 
 * @asparam radiusX The default radiusX to use, if corner-specific values are not specified.
 * This value must be specified.
 * 
 * @asparam radiusY The default radiusY to use, if corner-specific values are not specified. 
 * If 0, the value of radiusX is used.
 * 
 * @asparam topLeftRadiusX The x radius of the upper-left corner, in pixels. If NaN, 
 * the value of radiusX is used.
 * 
 * @asparam topLeftRadiusY The y radius of the upper-left corner, in pixels. If NaN,
 * the value of topLeftRadiusX is used.
 * 
 * @asparam topRightRadiusX The x radius of the upper-right corner, in pixels. If NaN,
 * the value of radiusX is used.
 * 
 * @asparam topRightRadiusY The y radius of the upper-right corner, in pixels. If NaN,
 * the value of topRightRadiusX is used.
 * 
 * @asparam bottomLeftRadiusX The x radius of the bottom-left corner, in pixels. If NaN,
 * the value of radiusX is used.
 * 
 * @asparam bottomLeftRadiusY The y radius of the bottom-left corner, in pixels. If NaN,
 * the value of bottomLeftRadiusX is used.
 * 
 * @asparam bottomRightRadiusX The x radius of the bottom-right corner, in pixels. If NaN,
 * the value of radiusX is used.
 * 
 * @asparam bottomRightRadiusY The y radius of the bottom-right corner, in pixels. If NaN,
 * the value of bottomRightRadiusX is used.
 * 
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10
 *  @playerversion AIR 1.5
 *  @productversion Flex 4
 * @export
 * @param {number} x
 * @param {number} y
 * @param {number} width
 * @param {number} height
 * @param {number} radiusX
 * @param {number} radiusY
 * @param {number} topLeftRadiusX
 * @param {number} topLeftRadiusY
 * @param {number} topRightRadiusX
 * @param {number} topRightRadiusY
 * @param {number} bottomLeftRadiusX
 * @param {number} bottomLeftRadiusY
 * @param {number} bottomRightRadiusX
 * @param {number} bottomRightRadiusY
 */
org.apache.flex.graphics.PathBuilder.prototype.drawRoundRectComplex2 = function(x, y, width, height, radiusX, radiusY, topLeftRadiusX, topLeftRadiusY, topRightRadiusX, topRightRadiusY, bottomLeftRadiusX, bottomLeftRadiusY, bottomRightRadiusX, bottomRightRadiusY) {
  var /** @type {number} */ xw = x + width;
  var /** @type {number} */ yh = y + height;
  var /** @type {number} */ maxXRadius = width / 2;
  var /** @type {number} */ maxYRadius = height / 2;
  if (radiusY == 0)
    radiusY = radiusX;
  if (isNaN(topLeftRadiusX))
    topLeftRadiusX = radiusX;
  if (isNaN(topLeftRadiusY))
    topLeftRadiusY = topLeftRadiusX;
  if (isNaN(topRightRadiusX))
    topRightRadiusX = radiusX;
  if (isNaN(topRightRadiusY))
    topRightRadiusY = topRightRadiusX;
  if (isNaN(bottomLeftRadiusX))
    bottomLeftRadiusX = radiusX;
  if (isNaN(bottomLeftRadiusY))
    bottomLeftRadiusY = bottomLeftRadiusX;
  if (isNaN(bottomRightRadiusX))
    bottomRightRadiusX = radiusX;
  if (isNaN(bottomRightRadiusY))
    bottomRightRadiusY = bottomRightRadiusX;
  if (topLeftRadiusX > maxXRadius)
    topLeftRadiusX = maxXRadius;
  if (topLeftRadiusY > maxYRadius)
    topLeftRadiusY = maxYRadius;
  if (topRightRadiusX > maxXRadius)
    topRightRadiusX = maxXRadius;
  if (topRightRadiusY > maxYRadius)
    topRightRadiusY = maxYRadius;
  if (bottomLeftRadiusX > maxXRadius)
    bottomLeftRadiusX = maxXRadius;
  if (bottomLeftRadiusY > maxYRadius)
    bottomLeftRadiusY = maxYRadius;
  if (bottomRightRadiusX > maxXRadius)
    bottomRightRadiusX = maxXRadius;
  if (bottomRightRadiusY > maxYRadius)
    bottomRightRadiusY = maxYRadius;
  var /** @type {number} */ aX = bottomRightRadiusX * 0.292893218813453;
  var /** @type {number} */ aY = bottomRightRadiusY * 0.292893218813453;
  var /** @type {number} */ sX = bottomRightRadiusX * 0.585786437626905;
  var /** @type {number} */ sY = bottomRightRadiusY * 0.585786437626905;
  this.commands.push(new org.apache.flex.graphics.MoveTo(xw, yh - bottomRightRadiusY));
  this.commands.push(new org.apache.flex.graphics.QuadraticCurve(xw, yh - sY, xw - aX, yh - aY));
  this.commands.push(new org.apache.flex.graphics.QuadraticCurve(xw - sX, yh, xw - bottomRightRadiusX, yh));
  aX = bottomLeftRadiusX * 0.292893218813453;
  aY = bottomLeftRadiusY * 0.292893218813453;
  sX = bottomLeftRadiusX * 0.585786437626905;
  sY = bottomLeftRadiusY * 0.585786437626905;
  this.commands.push(new org.apache.flex.graphics.LineTo(x + bottomLeftRadiusX, yh));
  this.commands.push(new org.apache.flex.graphics.QuadraticCurve(x + sX, yh, x + aX, yh - aY));
  this.commands.push(new org.apache.flex.graphics.QuadraticCurve(x, yh - sY, x, yh - bottomLeftRadiusY));
  aX = topLeftRadiusX * 0.292893218813453;
  aY = topLeftRadiusY * 0.292893218813453;
  sX = topLeftRadiusX * 0.585786437626905;
  sY = topLeftRadiusY * 0.585786437626905;
  this.commands.push(new org.apache.flex.graphics.LineTo(x, y + topLeftRadiusY));
  this.commands.push(new org.apache.flex.graphics.QuadraticCurve(x, y + sY, x + aX, y + aY));
  this.commands.push(new org.apache.flex.graphics.QuadraticCurve(x + sX, y, x + topLeftRadiusX, y));
  aX = topRightRadiusX * 0.292893218813453;
  aY = topRightRadiusY * 0.292893218813453;
  sX = topRightRadiusX * 0.585786437626905;
  sY = topRightRadiusY * 0.585786437626905;
  this.commands.push(new org.apache.flex.graphics.LineTo(xw - topRightRadiusX, y));
  this.commands.push(new org.apache.flex.graphics.QuadraticCurve(xw - sX, y, xw - aX, y + aY));
  this.commands.push(new org.apache.flex.graphics.QuadraticCurve(xw, y + sY, xw, y + topRightRadiusY));
  this.commands.push(new org.apache.flex.graphics.LineTo(xw, yh - bottomRightRadiusY));
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.graphics.PathBuilder.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'PathBuilder', qName: 'org.apache.flex.graphics.PathBuilder'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.graphics.PathBuilder', org.apache.flex.graphics.PathBuilder);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.graphics.PathBuilder.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'PathBuilder': { type: '', declaredBy: 'org.apache.flex.graphics.PathBuilder'},
        'getPathString': { type: 'String', declaredBy: 'org.apache.flex.graphics.PathBuilder'},
        'draw': { type: 'void', declaredBy: 'org.apache.flex.graphics.PathBuilder'},
        'lineTo': { type: 'void', declaredBy: 'org.apache.flex.graphics.PathBuilder'},
        'moveTo': { type: 'void', declaredBy: 'org.apache.flex.graphics.PathBuilder'},
        'quadraticCurveTo': { type: 'void', declaredBy: 'org.apache.flex.graphics.PathBuilder'},
        'cubicCurveTo': { type: 'void', declaredBy: 'org.apache.flex.graphics.PathBuilder'},
        'drawRoundRectComplex': { type: 'void', declaredBy: 'org.apache.flex.graphics.PathBuilder'},
        'drawRoundRectComplex2': { type: 'void', declaredBy: 'org.apache.flex.graphics.PathBuilder'}
      };
    }
  };
};