/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/accessories/CurrencyFormatter.as
 * org.apache.flex.html.accessories.CurrencyFormatter
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.accessories.CurrencyFormatter');

goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.events.EventDispatcher');
goog.require('org.apache.flex.core.IBeadModel');
goog.require('org.apache.flex.core.IFormatBead');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.events.EventDispatcher}
 * @implements {org.apache.flex.core.IFormatBead}
 */
org.apache.flex.html.accessories.CurrencyFormatter = function() {
  org.apache.flex.html.accessories.CurrencyFormatter.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.accessories.CurrencyFormatter, org.apache.flex.events.EventDispatcher);


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.html.accessories.CurrencyFormatter.prototype._strand;


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.accessories.CurrencyFormatter.prototype.handleBeadsAdded = function(event) {
  var /** @type {org.apache.flex.core.IBeadModel} */ model = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.core.IBeadModel);
  model.addEventListener(this.eventName, org.apache.flex.utils.Language.closure(this.propertyChangeHandler, this, 'propertyChangeHandler'));
  model.addEventListener(this.propertyName + "Change", org.apache.flex.utils.Language.closure(this.propertyChangeHandler, this, 'propertyChangeHandler'));
  this.propertyChangeHandler(null);
};


/**
 * @private
 * @type {string}
 */
org.apache.flex.html.accessories.CurrencyFormatter.prototype._propertyName;


/**
 * @private
 * @type {string}
 */
org.apache.flex.html.accessories.CurrencyFormatter.prototype._eventName;


/**
 * @private
 * @type {string}
 */
org.apache.flex.html.accessories.CurrencyFormatter.prototype._formattedResult;


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.accessories.CurrencyFormatter.prototype._fractionalDigits = 2;


/**
 * @private
 * @type {string}
 */
org.apache.flex.html.accessories.CurrencyFormatter.prototype._currencySymbol = "$";


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.accessories.CurrencyFormatter.prototype.propertyChangeHandler = function(event) {
  var /** @type {org.apache.flex.core.IBeadModel} */ model = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.core.IBeadModel);
  var /** @type {Object} */ value = model[this.propertyName];
  this._formattedResult = this.format(value);
  var /** @type {org.apache.flex.events.Event} */ newEvent = new org.apache.flex.events.Event("formatChanged");
  this.dispatchEvent(newEvent);
};


/**
 *  Computes the formatted string.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} value
 * @return {string}
 */
org.apache.flex.html.accessories.CurrencyFormatter.prototype.format = function(value) {
  if (value == null)
    return "";
  var /** @type {number} */ num = Number(value);
  var /** @type {string} */ source = num.toFixed(this.fractionalDigits);
  return this.currencySymbol + source;
};


Object.defineProperties(org.apache.flex.html.accessories.CurrencyFormatter.prototype, /** @lends {org.apache.flex.html.accessories.CurrencyFormatter.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.accessories.CurrencyFormatter} */ function(value) {
  this._strand = value;
  org.apache.flex.utils.Language.as(value, org.apache.flex.events.IEventDispatcher, true).addEventListener("beadsAdded", org.apache.flex.utils.Language.closure(this.handleBeadsAdded, this, 'handleBeadsAdded'));
}},
/** @export */
propertyName: {
get: /** @this {org.apache.flex.html.accessories.CurrencyFormatter} */ function() {
  if (this._propertyName == null) {
    return "text";
  }
  return this._propertyName;
},
set: /** @this {org.apache.flex.html.accessories.CurrencyFormatter} */ function(value) {
  this._propertyName = value;
}},
/** @export */
eventName: {
get: /** @this {org.apache.flex.html.accessories.CurrencyFormatter} */ function() {
  if (this._eventName == null) {
    return this._propertyName + "Changed";
  }
  return this._eventName;
},
set: /** @this {org.apache.flex.html.accessories.CurrencyFormatter} */ function(value) {
  this._eventName = value;
}},
/** @export */
fractionalDigits: {
get: /** @this {org.apache.flex.html.accessories.CurrencyFormatter} */ function() {
  return this._fractionalDigits;
},
set: /** @this {org.apache.flex.html.accessories.CurrencyFormatter} */ function(value) {
  this._fractionalDigits = value;
}},
/** @export */
currencySymbol: {
get: /** @this {org.apache.flex.html.accessories.CurrencyFormatter} */ function() {
  return this._currencySymbol;
},
set: /** @this {org.apache.flex.html.accessories.CurrencyFormatter} */ function(value) {
  this._currencySymbol = value;
}},
/** @export */
formattedString: {
get: /** @this {org.apache.flex.html.accessories.CurrencyFormatter} */ function() {
  return this._formattedResult;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.accessories.CurrencyFormatter.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'CurrencyFormatter', qName: 'org.apache.flex.html.accessories.CurrencyFormatter'}], interfaces: [org.apache.flex.core.IFormatBead] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.accessories.CurrencyFormatter', org.apache.flex.html.accessories.CurrencyFormatter);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.accessories.CurrencyFormatter.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.accessories.CurrencyFormatter'},
        'propertyName': { type: 'String', declaredBy: 'org.apache.flex.html.accessories.CurrencyFormatter'},
        'eventName': { type: 'String', declaredBy: 'org.apache.flex.html.accessories.CurrencyFormatter'},
        'fractionalDigits': { type: 'int', declaredBy: 'org.apache.flex.html.accessories.CurrencyFormatter'},
        'currencySymbol': { type: 'String', declaredBy: 'org.apache.flex.html.accessories.CurrencyFormatter'},
        'formattedString': { type: 'String', declaredBy: 'org.apache.flex.html.accessories.CurrencyFormatter'}
      };
    },
    methods: function () {
      return {
        'CurrencyFormatter': { type: '', declaredBy: 'org.apache.flex.html.accessories.CurrencyFormatter'},
        'format': { type: 'String', declaredBy: 'org.apache.flex.html.accessories.CurrencyFormatter'}
      };
    }
  };
};