/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/createjs/tween/Tween.as
 * org.apache.flex.createjs.tween.Tween
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.createjs.tween.Tween');

goog.require('org.apache.flex.createjs.tween.Effect');
goog.require('org.apache.flex.core.IDocument');
goog.require('org.apache.flex.utils.Language');



/**
 * Constructor 
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @constructor
 * @extends {org.apache.flex.createjs.tween.Effect}
 * @implements {org.apache.flex.core.IDocument}
 * @param {Object=} target
 */
org.apache.flex.createjs.tween.Tween = function(target) {
  target = typeof target !== 'undefined' ? target : null;
  org.apache.flex.createjs.tween.Tween.base(this, 'constructor', target);
  
};
goog.inherits(org.apache.flex.createjs.tween.Tween, org.apache.flex.createjs.tween.Effect);


/**
 * @export
 * @type {number}
 */
org.apache.flex.createjs.tween.Tween.prototype.xFrom;


/**
 * @export
 * @type {number}
 */
org.apache.flex.createjs.tween.Tween.prototype.xTo;


/**
 * @export
 * @type {number}
 */
org.apache.flex.createjs.tween.Tween.prototype.yFrom;


/**
 * @export
 * @type {number}
 */
org.apache.flex.createjs.tween.Tween.prototype.yTo;


/**
 * @export
 * @type {number}
 */
org.apache.flex.createjs.tween.Tween.prototype.alphaFrom;


/**
 * @export
 * @type {number}
 */
org.apache.flex.createjs.tween.Tween.prototype.alphaTo;


/**
 * @private
 * @type {Object}
 */
org.apache.flex.createjs.tween.Tween.prototype.document;


/**
 * @export
 * @param {Object} document
 * @param {string=} id
 */
org.apache.flex.createjs.tween.Tween.prototype.setDocument = function(document, id) {
  id = typeof id !== 'undefined' ? id : null;
  this.document = document;
  
};


/**
 * @private
 * @type {createjs.Tween}
 */
org.apache.flex.createjs.tween.Tween.prototype._tween;


/**
 * @asprivate
 * @flexjsignorecoercion createjs.Shape
 * @flexjsignorecoercion createjs.Tween
 * @flexjsignorecoercion org.apache.flex.createjs.core.CreateJSBase
 * @export
 * @override
 */
org.apache.flex.createjs.tween.Tween.prototype.createTweenOptions = function() {
  
  if (this.target != null) {
    this._actualTarget = this.document[this.target];
  }
  var /** @type {createjs.Shape} */ element = this._actualTarget.element;
  var /** @type {Object} */ options = {};
  if (!isNaN(this.xTo))
    options["x"] = this.xTo;
  if (!isNaN(this.yTo))
    options["y"] = this.yTo;
  if (!isNaN(this.alphaTo))
    options["alpha"] = this.alphaTo;
  if (!isNaN(this.xFrom))
    this._actualTarget.x = this.xFrom;
  if (!isNaN(this.yFrom))
    this._actualTarget.y = this.yFrom;
  if (!isNaN(this.alphaFrom))
    this._actualTarget.alpha = this.alphaFrom;
  return options;
};


/**
 *  Causes the target object to move between its starting and ending positions. 
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 *  @flexjsignorecoercion createjs.Shape
 *  @flexjsignorecoercion createjs.Tween
 *  @flexjsignorecoercion org.apache.flex.createjs.core.CreateJSBase
 * @export
 * @override
 */
org.apache.flex.createjs.tween.Tween.prototype.play = function() {
  if (this.target != null) {
    this._actualTarget = this.document[this.target];
  }
  var /** @type {createjs.Shape} */ element = this._actualTarget.element;
  this._tween = createjs.Tween.get(element, {loop:this.loop});
  var /** @type {Object} */ options = this.createTweenOptions();
  this._tween.to(options, this.duration, createjs.Ease.getPowInOut(2));
  var /** @type {createjs.Stage} */ stage = element.getStage();
  createjs.Ticker.addEventListener("tick", stage);
  
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.createjs.tween.Tween.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Tween', qName: 'org.apache.flex.createjs.tween.Tween'}], interfaces: [org.apache.flex.core.IDocument] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.createjs.tween.Tween', org.apache.flex.createjs.tween.Tween);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.createjs.tween.Tween.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'xFrom': { type: 'Number'},
        'xTo': { type: 'Number'},
        'yFrom': { type: 'Number'},
        'yTo': { type: 'Number'},
        'alphaFrom': { type: 'Number'},
        'alphaTo': { type: 'Number'}
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'Tween': { type: '', declaredBy: 'org.apache.flex.createjs.tween.Tween'},
        'setDocument': { type: 'void', declaredBy: 'org.apache.flex.createjs.tween.Tween'},
        'createTweenOptions': { type: 'Object', declaredBy: 'org.apache.flex.createjs.tween.Tween'},
        'play': { type: 'void', declaredBy: 'org.apache.flex.createjs.tween.Tween'}
      };
    }
  };
};