/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/createjs/tween/Effect.as
 * org.apache.flex.createjs.tween.Effect
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.createjs.tween.Effect');

goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.events.EventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 * Constructor 
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @constructor
 * @extends {org.apache.flex.events.EventDispatcher}
 * @param {org.apache.flex.createjs.core.CreateJSBase=} target
 */
org.apache.flex.createjs.tween.Effect = function(target) {
  target = typeof target !== 'undefined' ? target : null;
  org.apache.flex.createjs.tween.Effect.base(this, 'constructor');
  this._actualTarget = target;
};
goog.inherits(org.apache.flex.createjs.tween.Effect, org.apache.flex.events.EventDispatcher);


/**
 * @private
 * @type {string}
 */
org.apache.flex.createjs.tween.Effect.prototype._target;


/**
 * @protected
 * @type {org.apache.flex.createjs.core.CreateJSBase}
 */
org.apache.flex.createjs.tween.Effect.prototype._actualTarget;


/**
 * @export
 * @type {number}
 */
org.apache.flex.createjs.tween.Effect.prototype.duration = 1000;


/**
 * @export
 * @type {boolean}
 */
org.apache.flex.createjs.tween.Effect.prototype.loop = false;


/**
 * @private
 * @type {Function}
 */
org.apache.flex.createjs.tween.Effect.prototype._easing = null;


/**
 * @asprivate
 * Returns the options necessary for an effect to take place. This is an
 * internally used function.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @return {Object}
 */
org.apache.flex.createjs.tween.Effect.prototype.createTweenOptions = function() {
  return null;
};


/**
 *  Plays the effect on the target object 
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 *  @flexjsignorecoercion createjs.Shape
 *  @flexjsignorecoercion org.apache.flex.createjs.core.CreateJSBase
 * @export
 */
org.apache.flex.createjs.tween.Effect.prototype.play = function() {
};


Object.defineProperties(org.apache.flex.createjs.tween.Effect.prototype, /** @lends {org.apache.flex.createjs.tween.Effect.prototype} */ {
/** @export */
target: {
get: /** @this {org.apache.flex.createjs.tween.Effect} */ function() {
  return this._target;
},
set: /** @this {org.apache.flex.createjs.tween.Effect} */ function(value) {
  if (value != this._target) {
    this._target = value;
    this.dispatchEvent(new org.apache.flex.events.Event("targetChanged"));
  }
}},
/** @export */
easing: {
get: /** @this {org.apache.flex.createjs.tween.Effect} */ function() {
  return this._easing;
},
set: /** @this {org.apache.flex.createjs.tween.Effect} */ function(value) {
  this._easing = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.createjs.tween.Effect.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Effect', qName: 'org.apache.flex.createjs.tween.Effect'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.createjs.tween.Effect', org.apache.flex.createjs.tween.Effect);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.createjs.tween.Effect.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'duration': { type: 'Number'},
        'loop': { type: 'Boolean'}
      };
    },
    accessors: function () {
      return {
        'target': { type: 'String', declaredBy: 'org.apache.flex.createjs.tween.Effect', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'targetChanged'}]}]; }},
        'easing': { type: 'Function', declaredBy: 'org.apache.flex.createjs.tween.Effect'}
      };
    },
    methods: function () {
      return {
        'Effect': { type: '', declaredBy: 'org.apache.flex.createjs.tween.Effect'},
        'createTweenOptions': { type: 'Object', declaredBy: 'org.apache.flex.createjs.tween.Effect'},
        'play': { type: 'void', declaredBy: 'org.apache.flex.createjs.tween.Effect'}
      };
    }
  };
};