/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/createjs/CheckBox.as
 * org.apache.flex.createjs.CheckBox
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.createjs.CheckBox');

goog.require('org.apache.flex.createjs.core.CreateJSBase');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.graphics.SolidColor');
goog.require('org.apache.flex.core.IToggleButtonModel');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @extends {org.apache.flex.createjs.core.CreateJSBase}
 */
org.apache.flex.createjs.CheckBox = function() {
  org.apache.flex.createjs.CheckBox.base(this, 'constructor');
};
goog.inherits(org.apache.flex.createjs.CheckBox, org.apache.flex.createjs.core.CreateJSBase);


/**
 * @private
 * @type {createjs.Shape}
 */
org.apache.flex.createjs.CheckBox.prototype.checkMark;


/**
 * @private
 * @type {createjs.Text}
 */
org.apache.flex.createjs.CheckBox.prototype.checkBoxLabel;


/**
 * @private
 * @type {createjs.Shape}
 */
org.apache.flex.createjs.CheckBox.prototype.checkBackground;


/**
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @protected
 * @override
 */
org.apache.flex.createjs.CheckBox.prototype.createElement = function() {
  this.checkMark = new createjs.Shape(null);
  this.checkMark.name = 'checkmark';
  this.checkBoxLabel = new createjs.Text('checkbox', '20px Arial');
  this.checkBoxLabel.name = 'label';
  this.checkBoxLabel.textAlign = 'left';
  this.checkBoxLabel.textBaseline = 'middle';
  this.checkBackground = new createjs.Shape(null);
  this.checkBackground.name = 'checkbackground';
  var /** @type {createjs.Container} */ container = new createjs.Container();
  this.element = container;
  container.name = 'checkbox';
  container.addChild(this.checkBackground);
  container.addChild(this.checkBoxLabel);
  container.addChild(this.checkMark);
  this.checkBoxLabel.addEventListener("click", org.apache.flex.utils.Language.closure(this.clickHandler, this, 'clickHandler'));
  this.checkMark.addEventListener("click", org.apache.flex.utils.Language.closure(this.clickHandler, this, 'clickHandler'));
  this.positioner = this.element;
  return this.element;
};


/**
 * @private
 * @type {string}
 */
org.apache.flex.createjs.CheckBox.prototype._fontName = "18px Arial";


/**
 * @asprivate
 * @flexjsignorecoercion createjs.Container
 * @protected
 * @override
 */
org.apache.flex.createjs.CheckBox.prototype.redrawShape = function() {
  var /** @type {string} */ color = "black";
  if (this.textColor != null) {
    color = this.convertColorToString(org.apache.flex.utils.Language.as(this.textColor, org.apache.flex.graphics.SolidColor).color, 1.0);
  }
  var /** @type {string} */ fillColor = "DeepSkyBlue";
  var /** @type {number} */ fillAlpha = 1.0;
  if (this.fill != null) {
    fillAlpha = org.apache.flex.utils.Language.as(this.fill, org.apache.flex.graphics.SolidColor).alpha;
    fillColor = this.convertColorToString(org.apache.flex.utils.Language.as(this.fill, org.apache.flex.graphics.SolidColor).color, fillAlpha);
  }
  var /** @type {createjs.Text} */ label = org.apache.flex.utils.Language.as(this.element, createjs.Text);
  this.checkBoxLabel.text = this.text;
  this.checkBoxLabel["font"] = this.fontName;
  this.checkBoxLabel["color"] = color;
  this.checkBoxLabel.x = 45;
  this.checkBoxLabel.y = 40 / 2;
  this.checkMark.graphics.setStrokeStyle(1);
  this.checkMark.graphics.beginStroke('gray');
  this.checkMark.graphics.beginFill(this.selected ? fillColor : 'white');
  this.checkMark.graphics.drawRoundRect(0, 0, 32, 32, 6);
  this.checkMark.graphics.endFill();
  this.checkMark.graphics.endStroke();
  this.checkMark.x = 4;
  this.checkMark.y = 4;
  var /** @type {createjs.Stage} */ stage = this.checkBoxLabel.getStage();
  if (stage)
    stage.update();
};


/**
 * @asparam event The event.
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.createjs.CheckBox.prototype.clickHandler = function(event) {
  this.selected = !this.selected;
};


Object.defineProperties(org.apache.flex.createjs.CheckBox.prototype, /** @lends {org.apache.flex.createjs.CheckBox.prototype} */ {
/** @export */
text: {
get: /** @this {org.apache.flex.createjs.CheckBox} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IToggleButtonModel, true).text;
},
set: /** @this {org.apache.flex.createjs.CheckBox} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IToggleButtonModel, true).text = value;
  this.redrawShape();
}},
/** @export */
selected: {
get: /** @this {org.apache.flex.createjs.CheckBox} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IToggleButtonModel, true).selected;
},
set: /** @this {org.apache.flex.createjs.CheckBox} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IToggleButtonModel, true).selected = value;
  this.redrawShape();
  this.dispatchEvent(new org.apache.flex.events.Event("change"));
}},
/** @export */
fontName: {
get: /** @this {org.apache.flex.createjs.CheckBox} */ function() {
  return this._fontName;
},
set: /** @this {org.apache.flex.createjs.CheckBox} */ function(value) {
  this._fontName = value;
  this.redrawShape();
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.createjs.CheckBox.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'CheckBox', qName: 'org.apache.flex.createjs.CheckBox'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.createjs.CheckBox', org.apache.flex.createjs.CheckBox);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.createjs.CheckBox.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'text': { type: 'String', declaredBy: 'org.apache.flex.createjs.CheckBox'},
        'selected': { type: 'Boolean', declaredBy: 'org.apache.flex.createjs.CheckBox'},
        'fontName': { type: 'String', declaredBy: 'org.apache.flex.createjs.CheckBox'}
      };
    },
    methods: function () {
      return {
      };
    }
  };
};