/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/utils/Proxy.as
 * org.apache.flex.utils.Proxy
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.utils.Proxy');

goog.require('org.apache.flex.events.EventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 * 
 *  @asparam delay The number of milliseconds 
 *  to wait before dispatching the event.
 *  @asparam repeatCount The number of times to dispatch
 *  the event.  If 0, keep dispatching forever.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.events.EventDispatcher}
 */
org.apache.flex.utils.Proxy = function() {
  org.apache.flex.utils.Proxy.base(this, 'constructor');

this.valueMap = {};
};
goog.inherits(org.apache.flex.utils.Proxy, org.apache.flex.events.EventDispatcher);


/**
 * @private
 * @type {Object}
 */
org.apache.flex.utils.Proxy.prototype.valueMap;


/**
 * @export
 * @param {string} propName
 * @return {*}
 */
org.apache.flex.utils.Proxy.prototype.getProperty = function(propName) {
  return this.valueMap[propName];
};


/**
 * @export
 * @param {string} propName
 * @param {*} value
 */
org.apache.flex.utils.Proxy.prototype.setProperty = function(propName, value) {
  this.valueMap[propName] = value;
};


/**
 * @export
 * @param {string} propName
 * @return {boolean}
 */
org.apache.flex.utils.Proxy.prototype.hasProperty = function(propName) {
  return this.valueMap.hasOwnProperty(propName);
};


/**
 * @export
 * @param {string} propName
 */
org.apache.flex.utils.Proxy.prototype.deleteProperty = function(propName) {
  delete this.valueMap[propName];
};


/**
 * @export
 * @return {Array}
 */
org.apache.flex.utils.Proxy.prototype.elementNames = function() {
  var /** @type {Array} */ names = [];
  for (var /** @type {string} */ p in this.valueMap)
    names.push(p);
  return names;
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.utils.Proxy.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Proxy', qName: 'org.apache.flex.utils.Proxy'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.utils.Proxy', org.apache.flex.utils.Proxy);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.utils.Proxy.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'Proxy': { type: '', declaredBy: 'org.apache.flex.utils.Proxy'},
        'getProperty': { type: '*', declaredBy: 'org.apache.flex.utils.Proxy'},
        'setProperty': { type: 'void', declaredBy: 'org.apache.flex.utils.Proxy'},
        'hasProperty': { type: 'Boolean', declaredBy: 'org.apache.flex.utils.Proxy'},
        'deleteProperty': { type: 'void', declaredBy: 'org.apache.flex.utils.Proxy'},
        'elementNames': { type: 'Array', declaredBy: 'org.apache.flex.utils.Proxy'}
      };
    }
  };
};