/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/geom/Matrix.as
 * org.apache.flex.geom.Matrix
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.geom.Matrix');

goog.require('org.apache.flex.geom.Point');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @param {number=} a
 * @param {number=} b
 * @param {number=} c
 * @param {number=} d
 * @param {number=} tx
 * @param {number=} ty
 */
org.apache.flex.geom.Matrix = function(a, b, c, d, tx, ty) {
  a = typeof a !== 'undefined' ? a : 1;
  b = typeof b !== 'undefined' ? b : 0;
  c = typeof c !== 'undefined' ? c : 0;
  d = typeof d !== 'undefined' ? d : 1;
  tx = typeof tx !== 'undefined' ? tx : 0;
  ty = typeof ty !== 'undefined' ? ty : 0;
  this.a = a;
  this.b = b;
  this.c = c;
  this.d = d;
  this.tx = tx;
  this.ty = ty;
};


/**
 * @export
 * @type {number}
 */
org.apache.flex.geom.Matrix.prototype.a;


/**
 * @export
 * @type {number}
 */
org.apache.flex.geom.Matrix.prototype.b;


/**
 * @export
 * @type {number}
 */
org.apache.flex.geom.Matrix.prototype.c;


/**
 * @export
 * @type {number}
 */
org.apache.flex.geom.Matrix.prototype.d;


/**
 * @export
 * @type {number}
 */
org.apache.flex.geom.Matrix.prototype.tx;


/**
 * @export
 * @type {number}
 */
org.apache.flex.geom.Matrix.prototype.ty;


/**
 *	Returns a copy of the Matrix
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.7
 * @export
 * @return {org.apache.flex.geom.Matrix}
 */
org.apache.flex.geom.Matrix.prototype.clone = function() {
  return new org.apache.flex.geom.Matrix(this.a, this.b, this.c, this.d, this.tx, this.ty);
};


/**
 *  Adds the Matrix the current one
 *  Returns the matrix so the methods can be chained.
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.7
 * @export
 * @param {org.apache.flex.geom.Matrix} m
 * @return {org.apache.flex.geom.Matrix}
 */
org.apache.flex.geom.Matrix.prototype.concat = function(m) {
  var /** @type {number} */ newa = this.a * m.a + this.b * m.c;
  this.b = this.a * m.b + this.b * m.d;
  this.a = newa;
  var /** @type {number} */ newc = this.c * m.a + this.d * m.c;
  this.d = this.c * m.b + this.d * m.d;
  this.c = newc;
  var /** @type {number} */ newtx = this.tx * m.a + this.ty * m.c + m.tx;
  this.ty = this.tx * m.b + this.ty * m.d + m.ty;
  this.tx = newtx;
  return this;
};


/**
 *  Calculates the Matrix determinant
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.7
 * @export
 * @return {number}
 */
org.apache.flex.geom.Matrix.prototype.determinant = function() {
  return this.a * this.d - this.b * this.c;
};


/**
 *  Inverts the Matrix.
 *  Returns the matrix so the methods can be chained.
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.7
 * @export
 * @return {org.apache.flex.geom.Matrix}
 */
org.apache.flex.geom.Matrix.prototype.invert = function() {
  if (this.b == 0 && this.c == 0) {
    this.a = 1 / this.a;
    this.d = 1 / this.d;
    this.tx *= -this.a;
    this.ty *= -this.d;
  } else {
    var /** @type {number} */ det = this.determinant();
    if (det == 0) {
      this.identity();
      return this;
    }
    det = 1 / det;
    var /** @type {number} */ newa = this.d * det;
    this.d = this.a * det;
    this.a = newa;
    this.b *= -det;
    this.c *= -det;
    var /** @type {number} */ newtx = -this.a * this.tx - this.c * this.ty;
    this.ty = -this.b * this.tx - this.d * this.ty;
    this.tx = newtx;
  }
  return this;
};


/**
 *  Resets the matrix to the default values.
 *  Returns the matrix so the methods can be chained.
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.7
 * @export
 * @return {org.apache.flex.geom.Matrix}
 */
org.apache.flex.geom.Matrix.prototype.identity = function() {
  this.a = this.d = 1;
  this.b = this.c = this.tx = this.ty = 0;
  return this;
};


/**
 *  Rotates the Matrix by the specified value.
 *  Returns the matrix so the methods can be chained.
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.7
 * @export
 * @param {number} angle
 * @return {org.apache.flex.geom.Matrix}
 */
org.apache.flex.geom.Matrix.prototype.rotate = function(angle) {
  var /** @type {number} */ cos = Math.cos(angle);
  var /** @type {number} */ sin = Math.sin(angle);
  var /** @type {number} */ newa = this.a * cos - this.b * sin;
  this.b = this.a * sin + this.b * cos;
  this.a = newa;
  var /** @type {number} */ newc = this.c * cos - this.d * sin;
  this.d = this.c * sin + this.d * cos;
  this.c = newc;
  var /** @type {number} */ newtx = this.tx * cos - this.ty * sin;
  this.ty = this.tx * sin + this.ty * cos;
  this.tx = newtx;
  return this;
};


/**
 *  Moves the Matrix by the specified amount
 *  Returns the matrix so the methods can be chained.
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.7
 * @export
 * @param {number} x
 * @param {number} y
 * @return {org.apache.flex.geom.Matrix}
 */
org.apache.flex.geom.Matrix.prototype.translate = function(x, y) {
  this.tx += x;
  this.ty += y;
  return this;
};


/**
 *  Scales the Matrix by the specified amount.
 *  Returns the matrix so the methods can be chained.
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.7
 * @export
 * @param {number} x
 * @param {number} y
 * @return {org.apache.flex.geom.Matrix}
 */
org.apache.flex.geom.Matrix.prototype.scale = function(x, y) {
  this.a *= x;
  this.b *= y;
  this.c *= x;
  this.d *= y;
  this.tx *= x;
  this.ty *= y;
  return this;
};


/**
 *  Uses the Matrix to transform the point without the translation values.
 *  Returns a new Point. The original Point is unchanged.
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.7
 * @export
 * @param {org.apache.flex.geom.Point} point
 * @return {org.apache.flex.geom.Point}
 */
org.apache.flex.geom.Matrix.prototype.deltaTransformPoint = function(point) {
  return new org.apache.flex.geom.Point(this.a * point.x + this.c * point.y, this.d * point.y + this.b * point.x);
};


/**
 *  Uses the Matrix to transform the point including the translation values.
 *  Returns a new Point. The original Point is unchanged.
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.7
 * @export
 * @param {org.apache.flex.geom.Point} point
 * @return {org.apache.flex.geom.Point}
 */
org.apache.flex.geom.Matrix.prototype.transformPoint = function(point) {
  return new org.apache.flex.geom.Point(this.a * point.x + this.c * point.y + this.tx, this.d * point.y + this.b * point.x + this.ty);
};


/**
 *  Returns a string representation of the Matrix.
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.7
 * @export
 * @return {string}
 */
org.apache.flex.geom.Matrix.prototype.toString = function() {
  return "(a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", d=" + this.d + ", tx=" + this.tx + ", ty=" + this.ty + ")";
};


/**
 *  Copies the values from another Matrix.
 *  Returns the matrix so the methods can be chained.
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.7
 * @export
 * @param {org.apache.flex.geom.Matrix} source
 * @return {org.apache.flex.geom.Matrix}
 */
org.apache.flex.geom.Matrix.prototype.copyFrom = function(source) {
  this.a = source.a;
  this.b = source.b;
  this.c = source.c;
  this.d = source.d;
  this.tx = source.tx;
  this.ty = source.ty;
  return this;
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.geom.Matrix.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Matrix', qName: 'org.apache.flex.geom.Matrix'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.geom.Matrix', org.apache.flex.geom.Matrix);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.geom.Matrix.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'a': { type: 'Number'},
        'b': { type: 'Number'},
        'c': { type: 'Number'},
        'd': { type: 'Number'},
        'tx': { type: 'Number'},
        'ty': { type: 'Number'}
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'Matrix': { type: '', declaredBy: 'org.apache.flex.geom.Matrix'},
        'clone': { type: 'Matrix', declaredBy: 'org.apache.flex.geom.Matrix'},
        'concat': { type: 'Matrix', declaredBy: 'org.apache.flex.geom.Matrix'},
        'determinant': { type: 'Number', declaredBy: 'org.apache.flex.geom.Matrix'},
        'invert': { type: 'Matrix', declaredBy: 'org.apache.flex.geom.Matrix'},
        'identity': { type: 'Matrix', declaredBy: 'org.apache.flex.geom.Matrix'},
        'rotate': { type: 'Matrix', declaredBy: 'org.apache.flex.geom.Matrix'},
        'translate': { type: 'Matrix', declaredBy: 'org.apache.flex.geom.Matrix'},
        'scale': { type: 'Matrix', declaredBy: 'org.apache.flex.geom.Matrix'},
        'deltaTransformPoint': { type: 'Point', declaredBy: 'org.apache.flex.geom.Matrix'},
        'transformPoint': { type: 'Point', declaredBy: 'org.apache.flex.geom.Matrix'},
        'toString': { type: 'String', declaredBy: 'org.apache.flex.geom.Matrix'},
        'copyFrom': { type: 'Matrix', declaredBy: 'org.apache.flex.geom.Matrix'}
      };
    }
  };
};