/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/core/TransformModel.as
 * org.apache.flex.core.TransformModel
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.core.TransformModel');

goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.events.EventDispatcher');
goog.require('org.apache.flex.core.ITransformHost');
goog.require('org.apache.flex.core.ITransformModel');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @extends {org.apache.flex.events.EventDispatcher}
 * @implements {org.apache.flex.core.ITransformModel}
 */
org.apache.flex.core.TransformModel = function() {
  org.apache.flex.core.TransformModel.base(this, 'constructor');
};
goog.inherits(org.apache.flex.core.TransformModel, org.apache.flex.events.EventDispatcher);


/**
 * @export
 * @const
 * @type {string}
 */
org.apache.flex.core.TransformModel.CHANGE = "transferModelChange";


/**
 * @private
 * @type {org.apache.flex.geom.Matrix}
 */
org.apache.flex.core.TransformModel.prototype._matrix;


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.core.TransformModel.prototype._strand;


/**
 * @private
 */
org.apache.flex.core.TransformModel.prototype.dispatchModelChangeEvent = function() {
  this.host.dispatchEvent(new org.apache.flex.events.Event(org.apache.flex.core.TransformModel.CHANGE));
};


Object.defineProperties(org.apache.flex.core.TransformModel.prototype, /** @lends {org.apache.flex.core.TransformModel.prototype} */ {
/** @export */
matrix: {
get: /** @this {org.apache.flex.core.TransformModel} */ function() {
  return this._matrix;
},
set: /** @this {org.apache.flex.core.TransformModel} */ function(value) {
  this._matrix = value;
  if (this._strand) {
    this.dispatchModelChangeEvent();
  }
}},
/** @export */
host: {
get: /** @this {org.apache.flex.core.TransformModel} */ function() {
  return org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.ITransformHost);
}},
/** @export */
strand: {
set: /** @this {org.apache.flex.core.TransformModel} */ function(value) {
  this._strand = value;
  this.dispatchModelChangeEvent();
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.core.TransformModel.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'TransformModel', qName: 'org.apache.flex.core.TransformModel'}], interfaces: [org.apache.flex.core.ITransformModel] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.core.TransformModel', org.apache.flex.core.TransformModel);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.core.TransformModel.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'matrix': { type: 'Matrix', declaredBy: 'org.apache.flex.core.TransformModel'},
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.core.TransformModel'}
      };
    },
    methods: function () {
      return {
        'TransformModel': { type: '', declaredBy: 'org.apache.flex.core.TransformModel'}
      };
    }
  };
};