/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/core/SimpleValuesImpl.as
 * org.apache.flex.core.SimpleValuesImpl
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.core.SimpleValuesImpl');

goog.require('org.apache.flex.events.EventDispatcher');
goog.require('org.apache.flex.events.ValueChangeEvent');
goog.require('org.apache.flex.core.IValuesImpl');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @extends {org.apache.flex.events.EventDispatcher}
 * @implements {org.apache.flex.core.IValuesImpl}
 */
org.apache.flex.core.SimpleValuesImpl = function() {
  org.apache.flex.core.SimpleValuesImpl.base(this, 'constructor');
};
goog.inherits(org.apache.flex.core.SimpleValuesImpl, org.apache.flex.events.EventDispatcher);


/**
 * @export
 * @type {Object}
 */
org.apache.flex.core.SimpleValuesImpl.prototype.values;


/**
 *  @copy org.apache.flex.core.IValuesImpl#getValue()
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} thisObject
 * @param {string} valueName
 * @param {string=} state
 * @param {Object=} attrs
 * @return {*}
 */
org.apache.flex.core.SimpleValuesImpl.prototype.getValue = function(thisObject, valueName, state, attrs) {
  state = typeof state !== 'undefined' ? state : null;
  attrs = typeof attrs !== 'undefined' ? attrs : null;
  return this.values[valueName];
};


/**
 *  @copy org.apache.flex.core.IValuesImpl#newInstance()
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} thisObject
 * @param {string} valueName
 * @param {string=} state
 * @param {Object=} attrs
 * @return {*}
 */
org.apache.flex.core.SimpleValuesImpl.prototype.newInstance = function(thisObject, valueName, state, attrs) {
  state = typeof state !== 'undefined' ? state : null;
  attrs = typeof attrs !== 'undefined' ? attrs : null;
  var /** @type {Object} */ c = this.values[valueName];
  if (c)
    return new c();
  return null;
};


/**
 *  A method that stores a value to be shared with other objects.
 *  It is global, not per instance.  Fancier implementations
 *  may store shared values per-instance.
 * 
 *  @asparam thisObject An object associated with this value.  Thiis
 *                parameter is ignored.
 *  @asparam valueName The name or key of the value being stored.
 *  @asparam value The value to be stored.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} thisObject
 * @param {string} valueName
 * @param {Object} value
 */
org.apache.flex.core.SimpleValuesImpl.prototype.setValue = function(thisObject, valueName, value) {
  var /** @type {Object} */ oldValue = this.values[valueName];
  if (oldValue != value) {
    this.values[valueName] = value;
    this.dispatchEvent(new org.apache.flex.events.ValueChangeEvent(org.apache.flex.events.ValueChangeEvent.VALUE_CHANGE, false, false, oldValue, value));
  }
};


/**
 *  @copy org.apache.flex.core.IValuesImpl#getInstance()
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} valueName
 * @return {Object}
 */
org.apache.flex.core.SimpleValuesImpl.prototype.getInstance = function(valueName) {
  return this.values[valueName];
};


/**
 *  @copy org.apache.flex.core.IValuesImpl#init()
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} mainClass
 */
org.apache.flex.core.SimpleValuesImpl.prototype.init = function(mainClass) {
};


/**
 *  @copy org.apache.flex.core.IValuesImpl#convertColor()
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} value
 * @return {number}
 */
org.apache.flex.core.SimpleValuesImpl.prototype.convertColor = function(value) {
  if (!org.apache.flex.utils.Language.is(value, String))
    return org.apache.flex.utils.Language.uint(value);
  var /** @type {string} */ stringValue = org.apache.flex.utils.Language.as(value, String);
  if (stringValue.charAt(0) == '#')
    return org.apache.flex.utils.Language.uint(stringValue.substr(1));
  return org.apache.flex.utils.Language.uint(stringValue);
};


/**
 *  @copy org.apache.flex.core.IValuesImpl#parseStyles()
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} value
 * @return {Object}
 */
org.apache.flex.core.SimpleValuesImpl.prototype.parseStyles = function(value) {
  value = value.replace(/;/g, ",");
  return JSON.parse("{" + value + "}");
};


/**
 *  @copy org.apache.flex.core.IValuesImpl#addRule()
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} ruleName
 * @param {Object} values
 */
org.apache.flex.core.SimpleValuesImpl.prototype.addRule = function(ruleName, values) {
  for (var /** @type {string} */ p in values)
    values[p] = values[p];
};


/**
 * @export
 * @param {org.apache.flex.core.IUIBase} thisObject
 * @param {Object} styles
 */
org.apache.flex.core.SimpleValuesImpl.prototype.applyStyles = function(thisObject, styles) {
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.core.SimpleValuesImpl.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'SimpleValuesImpl', qName: 'org.apache.flex.core.SimpleValuesImpl'}], interfaces: [org.apache.flex.core.IValuesImpl] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.core.SimpleValuesImpl', org.apache.flex.core.SimpleValuesImpl);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.core.SimpleValuesImpl.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'values': { type: 'Object'}
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'SimpleValuesImpl': { type: '', declaredBy: 'org.apache.flex.core.SimpleValuesImpl'},
        'getValue': { type: '*', declaredBy: 'org.apache.flex.core.SimpleValuesImpl'},
        'newInstance': { type: '*', declaredBy: 'org.apache.flex.core.SimpleValuesImpl'},
        'setValue': { type: 'void', declaredBy: 'org.apache.flex.core.SimpleValuesImpl'},
        'getInstance': { type: 'Object', declaredBy: 'org.apache.flex.core.SimpleValuesImpl'},
        'init': { type: 'void', declaredBy: 'org.apache.flex.core.SimpleValuesImpl'},
        'convertColor': { type: 'uint', declaredBy: 'org.apache.flex.core.SimpleValuesImpl'},
        'parseStyles': { type: 'Object', declaredBy: 'org.apache.flex.core.SimpleValuesImpl'},
        'addRule': { type: 'void', declaredBy: 'org.apache.flex.core.SimpleValuesImpl'},
        'applyStyles': { type: 'void', declaredBy: 'org.apache.flex.core.SimpleValuesImpl'}
      };
    }
  };
};