/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/charts/supportClasses/LineSegmentItemRenderer.as
 * org.apache.flex.charts.supportClasses.LineSegmentItemRenderer
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.charts.supportClasses.LineSegmentItemRenderer');

goog.require('org.apache.flex.html.supportClasses.DataItemRenderer');
goog.require('org.apache.flex.svg.Path');
goog.require('org.apache.flex.charts.supportClasses.ILineSegmentItemRenderer');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @extends {org.apache.flex.html.supportClasses.DataItemRenderer}
 * @implements {org.apache.flex.charts.supportClasses.ILineSegmentItemRenderer}
 */
org.apache.flex.charts.supportClasses.LineSegmentItemRenderer = function() {
  org.apache.flex.charts.supportClasses.LineSegmentItemRenderer.base(this, 'constructor');
};
goog.inherits(org.apache.flex.charts.supportClasses.LineSegmentItemRenderer, org.apache.flex.html.supportClasses.DataItemRenderer);


/**
 * @private
 * @type {org.apache.flex.charts.core.IChartSeries}
 */
org.apache.flex.charts.supportClasses.LineSegmentItemRenderer.prototype._series;


/**
 * @private
 * @type {Array}
 */
org.apache.flex.charts.supportClasses.LineSegmentItemRenderer.prototype._points;


/**
 * @private
 * @type {org.apache.flex.graphics.IStroke}
 */
org.apache.flex.charts.supportClasses.LineSegmentItemRenderer.prototype._stroke;


/**
 * @private
 * @type {org.apache.flex.svg.Path}
 */
org.apache.flex.charts.supportClasses.LineSegmentItemRenderer.prototype.path;


/**
 * @private
 * @type {number}
 */
org.apache.flex.charts.supportClasses.LineSegmentItemRenderer.prototype._fillColor;


/**
 *  @asprivate
 * @protected
 */
org.apache.flex.charts.supportClasses.LineSegmentItemRenderer.prototype.drawLine = function() {
  var /** @type {boolean} */ needsAddElement = false;
  if (this.points != null) {
    if (this.path == null) {
      this.path = new org.apache.flex.svg.Path();
      needsAddElement = true;
    }
    this.path.stroke = this.stroke;
    this.path.fill = null;
    var /** @type {string} */ pathString = "";
    for (var /** @type {number} */ i = 0; i < this.points.length; i++) {
      var /** @type {Object} */ point = this.points[i];
      if (i == 0)
        pathString += "M " + point.x + " " + point.y + " ";
      else
        pathString += "L " + point.x + " " + point.y + " ";
    }
    this.path.x = 0;
    this.path.y = 0;
    this.path.data = pathString;
    if (needsAddElement) {
      this.addElement(this.path);
    }
  }
};


Object.defineProperties(org.apache.flex.charts.supportClasses.LineSegmentItemRenderer.prototype, /** @lends {org.apache.flex.charts.supportClasses.LineSegmentItemRenderer.prototype} */ {
/** @export */
series: {
get: /** @this {org.apache.flex.charts.supportClasses.LineSegmentItemRenderer} */ function() {
  return this._series;
},
set: /** @this {org.apache.flex.charts.supportClasses.LineSegmentItemRenderer} */ function(value) {
  this._series = value;
}},
/** @export */
points: {
get: /** @this {org.apache.flex.charts.supportClasses.LineSegmentItemRenderer} */ function() {
  return this._points;
},
set: /** @this {org.apache.flex.charts.supportClasses.LineSegmentItemRenderer} */ function(value) {
  this._points = value;
  this.drawLine();
}},
/** @export */
stroke: {
get: /** @this {org.apache.flex.charts.supportClasses.LineSegmentItemRenderer} */ function() {
  return this._stroke;
},
set: /** @this {org.apache.flex.charts.supportClasses.LineSegmentItemRenderer} */ function(value) {
  this._stroke = value;
  this.drawLine();
}},
/** @export */
data: {
get: /** @this {org.apache.flex.charts.supportClasses.LineSegmentItemRenderer} */ function() {
  return org.apache.flex.utils.Language.superGetter(org.apache.flex.charts.supportClasses.LineSegmentItemRenderer, this, 'data');
},
set: /** @this {org.apache.flex.charts.supportClasses.LineSegmentItemRenderer} */ function(value) {
  org.apache.flex.utils.Language.superSetter(org.apache.flex.charts.supportClasses.LineSegmentItemRenderer, this, 'data', value);
}},
/** @export */
yField: {
get: /** @this {org.apache.flex.charts.supportClasses.LineSegmentItemRenderer} */ function() {
  return null;
},
set: /** @this {org.apache.flex.charts.supportClasses.LineSegmentItemRenderer} */ function(value) {
}},
/** @export */
xField: {
get: /** @this {org.apache.flex.charts.supportClasses.LineSegmentItemRenderer} */ function() {
  return null;
},
set: /** @this {org.apache.flex.charts.supportClasses.LineSegmentItemRenderer} */ function(value) {
}},
/** @export */
fillColor: {
get: /** @this {org.apache.flex.charts.supportClasses.LineSegmentItemRenderer} */ function() {
  return this._fillColor;
},
set: /** @this {org.apache.flex.charts.supportClasses.LineSegmentItemRenderer} */ function(value) {
  this._fillColor = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.charts.supportClasses.LineSegmentItemRenderer.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'LineSegmentItemRenderer', qName: 'org.apache.flex.charts.supportClasses.LineSegmentItemRenderer'}], interfaces: [org.apache.flex.charts.supportClasses.ILineSegmentItemRenderer] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.charts.supportClasses.LineSegmentItemRenderer', org.apache.flex.charts.supportClasses.LineSegmentItemRenderer);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.charts.supportClasses.LineSegmentItemRenderer.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'series': { type: 'IChartSeries', declaredBy: 'org.apache.flex.charts.supportClasses.LineSegmentItemRenderer'},
        'points': { type: 'Array', declaredBy: 'org.apache.flex.charts.supportClasses.LineSegmentItemRenderer'},
        'stroke': { type: 'IStroke', declaredBy: 'org.apache.flex.charts.supportClasses.LineSegmentItemRenderer'},
        'data': { type: 'Object', declaredBy: 'org.apache.flex.charts.supportClasses.LineSegmentItemRenderer'},
        'yField': { type: 'String', declaredBy: 'org.apache.flex.charts.supportClasses.LineSegmentItemRenderer'},
        'xField': { type: 'String', declaredBy: 'org.apache.flex.charts.supportClasses.LineSegmentItemRenderer'},
        'fillColor': { type: 'uint', declaredBy: 'org.apache.flex.charts.supportClasses.LineSegmentItemRenderer'}
      };
    },
    methods: function () {
      return {
        'LineSegmentItemRenderer': { type: '', declaredBy: 'org.apache.flex.charts.supportClasses.LineSegmentItemRenderer'}
      };
    }
  };
};