/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/charts/beads/HorizontalLinearAxisBead.as
 * org.apache.flex.charts.beads.HorizontalLinearAxisBead
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.charts.beads.HorizontalLinearAxisBead');

goog.require('org.apache.flex.charts.beads.AxisBaseBead');
goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.html.beads.models.ArraySelectionModel');
goog.require('org.apache.flex.charts.core.IChart');
goog.require('org.apache.flex.charts.core.IHorizontalAxisBead');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.ISelectionModel');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.charts.beads.AxisBaseBead}
 * @implements {org.apache.flex.core.IBead}
 * @implements {org.apache.flex.charts.core.IHorizontalAxisBead}
 */
org.apache.flex.charts.beads.HorizontalLinearAxisBead = function() {
  
  this._maximum = Number.NaN;
  org.apache.flex.charts.beads.HorizontalLinearAxisBead.base(this, 'constructor');
  this.placement = "bottom";
};
goog.inherits(org.apache.flex.charts.beads.HorizontalLinearAxisBead, org.apache.flex.charts.beads.AxisBaseBead);


/**
 * @private
 * @type {number}
 */
org.apache.flex.charts.beads.HorizontalLinearAxisBead.prototype._axisHeight = 30;


/**
 * @private
 * @type {string}
 */
org.apache.flex.charts.beads.HorizontalLinearAxisBead.prototype._valueField;


/**
 * @private
 * @type {number}
 */
org.apache.flex.charts.beads.HorizontalLinearAxisBead.prototype._minimum = 0;


/**
 * @private
 * @type {number}
 */
org.apache.flex.charts.beads.HorizontalLinearAxisBead.prototype._maximum;


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.charts.beads.HorizontalLinearAxisBead.prototype._strand;


/**
 * @asprivate
 * @private
 * @param {number} n
 * @return {string}
 */
org.apache.flex.charts.beads.HorizontalLinearAxisBead.prototype.formatLabel = function(n) {
  var /** @type {number} */ sign = n < 0 ? -1 : 1;
  n = Math.abs(n);
  var /** @type {number} */ i;
  if (0 <= n && n <= 1) {
    i = Math.round(n * 100);
    n = i / 100.0;
  } else {
    i = Math.round(n);
    n = i;
  }
  var /** @type {string} */ result = String(sign * n);
  return result;
};


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.charts.beads.HorizontalLinearAxisBead.prototype.handleItemsCreated = function(event) {
  var /** @type {org.apache.flex.html.beads.models.ArraySelectionModel} */ model = org.apache.flex.utils.Language.as(this.strand.getBeadByType(org.apache.flex.core.ISelectionModel), org.apache.flex.html.beads.models.ArraySelectionModel);
  var /** @type {Array} */ items;
  if (org.apache.flex.utils.Language.is(model.dataProvider, Array))
    items = org.apache.flex.utils.Language.as(model.dataProvider, Array);
  else
    return;
  this.clearGraphics();
  var /** @type {number} */ xpos = 0;
  var /** @type {number} */ useWidth = org.apache.flex.utils.Language.as(this.axisGroup, org.apache.flex.core.UIBase, true).width;
  var /** @type {Array} */ series = org.apache.flex.utils.Language.as(this.strand, org.apache.flex.charts.core.IChart, true).series;
  var /** @type {number} */ maxValue = Number.MIN_VALUE;
  var /** @type {number} */ minValue = Number.MAX_VALUE;
  if (isNaN(this.minimum)) {
    for (var /** @type {number} */ i = 0; i < items.length; i++) {
      var /** @type {number} */ value = Number(items[i][this.valueField]);
      if (!isNaN(value))
        minValue = Math.min(minValue, value);
      else
        minValue = Math.min(minValue, 0);
    }
  } else {
    minValue = this.minimum;
  }
  if (isNaN(this.maximum)) {
    for (i = 0; i < items.length; i++) {
      value = Number(items[i][this.valueField]);
      if (!isNaN(value))
        maxValue = Math.max(maxValue, value);
      else
        maxValue = Math.max(maxValue, 0);
    }
  } else {
    maxValue = this.maximum;
  }
  var /** @type {number} */ numTicks = 10;
  var /** @type {number} */ tickStep = (maxValue - minValue) / numTicks;
  var /** @type {number} */ tickSpacing = useWidth / numTicks;
  var /** @type {number} */ tickValue = minValue;
  var /** @type {number} */ labelY = 7;
  for (i = 0; i < numTicks + 1; i++) {
    var /** @type {Object} */ label = this.addTickLabel(this.formatLabel(tickValue), xpos, labelY, tickSpacing, 0);
    label.x = xpos - label.width / 2;
    this.addTickMark(xpos, 0, 0, 5);
    xpos += tickSpacing;
    tickValue += tickStep;
  }
  this.drawAxisPath(0, 0, useWidth, 0);
  this.drawTickPath(0, 1);
};


Object.defineProperties(org.apache.flex.charts.beads.HorizontalLinearAxisBead.prototype, /** @lends {org.apache.flex.charts.beads.HorizontalLinearAxisBead.prototype} */ {
/** @export */
axisHeight: {
get: /** @this {org.apache.flex.charts.beads.HorizontalLinearAxisBead} */ function() {
  return this._axisHeight;
},
set: /** @this {org.apache.flex.charts.beads.HorizontalLinearAxisBead} */ function(value) {
  this._axisHeight = value;
}},
/** @export */
valueField: {
get: /** @this {org.apache.flex.charts.beads.HorizontalLinearAxisBead} */ function() {
  return this._valueField;
},
set: /** @this {org.apache.flex.charts.beads.HorizontalLinearAxisBead} */ function(value) {
  this._valueField = value;
}},
/** @export */
minimum: {
get: /** @this {org.apache.flex.charts.beads.HorizontalLinearAxisBead} */ function() {
  return this._minimum;
},
set: /** @this {org.apache.flex.charts.beads.HorizontalLinearAxisBead} */ function(value) {
  this._minimum = value;
}},
/** @export */
maximum: {
get: /** @this {org.apache.flex.charts.beads.HorizontalLinearAxisBead} */ function() {
  return this._maximum;
},
set: /** @this {org.apache.flex.charts.beads.HorizontalLinearAxisBead} */ function(value) {
  this._maximum = value;
}},
/** @export */
strand: {
get: /** @this {org.apache.flex.charts.beads.HorizontalLinearAxisBead} */ function() {
  return this._strand;
},
set: /** @this {org.apache.flex.charts.beads.HorizontalLinearAxisBead} */ function(value) {
  this._strand = value;
  org.apache.flex.utils.Language.superSetter(org.apache.flex.charts.beads.HorizontalLinearAxisBead, this, 'strand', value);
  org.apache.flex.utils.Language.as(this.strand, org.apache.flex.events.IEventDispatcher, true).addEventListener("layoutComplete", org.apache.flex.utils.Language.closure(this.handleItemsCreated, this, 'handleItemsCreated'));
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.charts.beads.HorizontalLinearAxisBead.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'HorizontalLinearAxisBead', qName: 'org.apache.flex.charts.beads.HorizontalLinearAxisBead'}], interfaces: [org.apache.flex.core.IBead, org.apache.flex.charts.core.IHorizontalAxisBead] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.charts.beads.HorizontalLinearAxisBead', org.apache.flex.charts.beads.HorizontalLinearAxisBead);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.charts.beads.HorizontalLinearAxisBead.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'axisHeight': { type: 'Number', declaredBy: 'org.apache.flex.charts.beads.HorizontalLinearAxisBead'},
        'valueField': { type: 'String', declaredBy: 'org.apache.flex.charts.beads.HorizontalLinearAxisBead'},
        'minimum': { type: 'Number', declaredBy: 'org.apache.flex.charts.beads.HorizontalLinearAxisBead'},
        'maximum': { type: 'Number', declaredBy: 'org.apache.flex.charts.beads.HorizontalLinearAxisBead'},
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.charts.beads.HorizontalLinearAxisBead'}
      };
    },
    methods: function () {
      return {
        'HorizontalLinearAxisBead': { type: '', declaredBy: 'org.apache.flex.charts.beads.HorizontalLinearAxisBead'}
      };
    }
  };
};