/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/svg/Text.as
 * org.apache.flex.svg.Text
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.svg.Text');

goog.require('org.apache.flex.svg.GraphicShape');
goog.require('org.apache.flex.graphics.IText');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.svg.GraphicShape}
 * @implements {org.apache.flex.graphics.IText}
 */
org.apache.flex.svg.Text = function() {
  org.apache.flex.svg.Text.base(this, 'constructor');
  
};
goog.inherits(org.apache.flex.svg.Text, org.apache.flex.svg.GraphicShape);


/**
 * @private
 * @type {org.apache.flex.core.WrappedHTMLElement}
 */
org.apache.flex.svg.Text.prototype._text;


/**
 *  Draws text at the given point.
 *  @asparam value The string to draw.
 *  @asparam xt The x position of the top-left corner of the rectangle.
 *  @asparam yt The y position of the top-left corner.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 *  @flexjsignorecoercion Text
 *  @flexjsignorecoercion Node
 *  @flexjsignorecoercion SVGLocatable
 * @export
 * @param {string} value
 * @param {number} xt
 * @param {number} yt
 */
org.apache.flex.svg.Text.prototype.drawText = function(value, xt, yt) {
  
  var /** @type {string} */ style = this.getStyleStr();
  if (this._text == null) {
    this._text = document.createElementNS('http://www.w3.org/2000/svg', 'text');
    this._text.flexjs_wrapper = this;
    this.element.appendChild(this._text);
  } else {
    this._text.removeChild(this._text.childNodes[0]);
  }
  this._text.setAttribute('style', style);
  this._text.setAttribute('x', xt);
  this._text.setAttribute('y', yt);
  var /** @type {org.apache.flex.svg.Text} */ textNode = org.apache.flex.utils.Language.as(document.createTextNode(value), org.apache.flex.svg.Text);
  this._text.appendChild(textNode);
  this.resize(this.x, this.y, this._text.getBBox());
};


/**
 * @protected
 * @override
 */
org.apache.flex.svg.Text.prototype.draw = function() {
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.svg.Text.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Text', qName: 'org.apache.flex.svg.Text'}], interfaces: [org.apache.flex.graphics.IText] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.svg.Text', org.apache.flex.svg.Text);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.svg.Text.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'Text': { type: '', declaredBy: 'org.apache.flex.svg.Text'},
        'drawText': { type: 'void', declaredBy: 'org.apache.flex.svg.Text'}
      };
    }
  };
};