/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/storage/file/DataInputStream.as
 * org.apache.flex.storage.file.DataInputStream
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.storage.file.DataInputStream');

goog.require('org.apache.flex.events.EventDispatcher');
goog.require('org.apache.flex.storage.events.FileEvent');
goog.require('org.apache.flex.storage.file.IDataInput');
goog.require('org.apache.flex.utils.Language');



/**
 * Constructor.
 *
 *  @asparam target The object to use as the event dispatch target.
 *  @asparam fileHandle A platform-specific handle to the file system
 *  @asparam fileReader A platform-specific handle to the file system
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.events.EventDispatcher}
 * @implements {org.apache.flex.storage.file.IDataInput}
 * @param {org.apache.flex.events.IEventDispatcher} target
 * @param {Object} fileHandle
 * @param {Object} fileReader
 */
org.apache.flex.storage.file.DataInputStream = function(target, fileHandle, fileReader) {
  var self = this;
  var /** @type {Function} */ __localFn0__ = function(e) {
    var /** @type {org.apache.flex.storage.events.FileEvent} */ streamEvent = new org.apache.flex.storage.events.FileEvent("READ");
    streamEvent.stream = self;
    streamEvent.data = org.apache.flex.utils.Language.string(this.result);
    self._target.dispatchEvent(streamEvent);
    self.close();
  }
  org.apache.flex.storage.file.DataInputStream.base(this, 'constructor');
  this._target = target;
  this._fileHandle = org.apache.flex.utils.Language.as(fileHandle, File);
  this._fileReader = org.apache.flex.utils.Language.as(fileReader, FileReader);
  var /** @type {org.apache.flex.storage.file.DataInputStream} */ self = this;
  this._fileReader.onloadend = __localFn0__;
  
};
goog.inherits(org.apache.flex.storage.file.DataInputStream, org.apache.flex.events.EventDispatcher);


/**
 * @private
 * @type {org.apache.flex.events.IEventDispatcher}
 */
org.apache.flex.storage.file.DataInputStream.prototype._target;


/**
 * Reads a chunk of text. A FileEvent "READ" event is dispatched when
 * the chunk is read.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 */
org.apache.flex.storage.file.DataInputStream.prototype.readText = function() {
  this._fileReader.readAsText(this._fileHandle);
  
};


/**
 * Closes the file (and dispatches a FileEvent "COMPLETE" event).
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 */
org.apache.flex.storage.file.DataInputStream.prototype.close = function() {
  
  var /** @type {org.apache.flex.storage.events.FileEvent} */ endEvent = new org.apache.flex.storage.events.FileEvent("COMPLETE");
  endEvent.stream = this;
  this._target.dispatchEvent(endEvent);
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.storage.file.DataInputStream.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'DataInputStream', qName: 'org.apache.flex.storage.file.DataInputStream'}], interfaces: [org.apache.flex.storage.file.IDataInput] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.storage.file.DataInputStream', org.apache.flex.storage.file.DataInputStream);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.storage.file.DataInputStream.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'DataInputStream': { type: '', declaredBy: 'org.apache.flex.storage.file.DataInputStream'},
        'readText': { type: 'void', declaredBy: 'org.apache.flex.storage.file.DataInputStream'},
        'close': { type: 'void', declaredBy: 'org.apache.flex.storage.file.DataInputStream'}
      };
    }
  };
};