/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/net/URLStream.as
 * org.apache.flex.net.URLStream
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.net.URLStream');

goog.require('org.apache.flex.events.DetailEvent');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.events.EventDispatcher');
goog.require('org.apache.flex.events.ProgressEvent');
goog.require('org.apache.flex.net.HTTPConstants');
goog.require('org.apache.flex.net.HTTPUtils');
goog.require('org.apache.flex.utils.BinaryData');
goog.require('org.apache.flex.utils.Endian');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @extends {org.apache.flex.events.EventDispatcher}
 */
org.apache.flex.net.URLStream = function() {
  
  this.endian = org.apache.flex.utils.Endian.BIG_ENDIAN;
  org.apache.flex.net.URLStream.base(this, 'constructor');
};
goog.inherits(org.apache.flex.net.URLStream, org.apache.flex.events.EventDispatcher);


/**
 * @export
 * @type {number}
 */
org.apache.flex.net.URLStream.prototype.bytesLoaded = 0;


/**
 * @export
 * @type {number}
 */
org.apache.flex.net.URLStream.prototype.bytesTotal = 0;


/**
 * @export
 * @param {org.apache.flex.net.URLRequest} urlRequest
 */
org.apache.flex.net.URLStream.prototype.load = function(urlRequest) {
  this.xhr = new XMLHttpRequest();
  this.xhr.open(urlRequest.method, urlRequest.url);
  this.xhr.responseType = "arraybuffer";
  this.xhr.addEventListener("readystatechange", org.apache.flex.utils.Language.closure(this.xhr_onreadystatechange, this, 'xhr_onreadystatechange'), false);
  this.xhr.addEventListener("progress", org.apache.flex.utils.Language.closure(this.xhr_progress, this, 'xhr_progress'), false);
  this.xhr.setRequestHeader("Content-type", urlRequest.contentType);
  this.xhr.send(org.apache.flex.net.HTTPUtils.encodeUrlVariables(urlRequest.data));
  
};


/**
 * @private
 * @param {Object} e
 */
org.apache.flex.net.URLStream.prototype.xhr_progress = function(e) {
  var /** @type {org.apache.flex.events.ProgressEvent} */ progEv = new org.apache.flex.events.ProgressEvent(org.apache.flex.events.ProgressEvent.PROGRESS);
  progEv.current = this.bytesLoaded = Number(e.loaded);
  progEv.total = this.bytesTotal = Number(e.total);
  this.dispatchEvent(progEv);
  if (this.onProgress)
    this.onProgress(this);
};


/**
 * @private
 * @param {*} e
 */
org.apache.flex.net.URLStream.prototype.xhr_onreadystatechange = function(e) {
  this.setStatus(this.xhr.status);
  if (this.xhr.readyState != 4)
    return;
  if (this.xhr.status == 0) {
    this.dispatchEvent(new org.apache.flex.events.DetailEvent(org.apache.flex.net.HTTPConstants.COMMUNICATION_ERROR));
    if (this.onError)
      this.onError(this);
  } else if (this.xhr.status < 200) {
    this.dispatchEvent(new org.apache.flex.events.DetailEvent(org.apache.flex.net.HTTPConstants.COMMUNICATION_ERROR, false, false, "" + this.requestStatus));
    if (this.onError)
      this.onError(this);
  } else if (this.xhr.status < 300) {
    this.dispatchEvent(new org.apache.flex.events.Event(org.apache.flex.net.HTTPConstants.COMPLETE));
    if (this.onComplete)
      this.onComplete(this);
  } else {
    this.dispatchEvent(new org.apache.flex.events.DetailEvent(org.apache.flex.net.HTTPConstants.COMMUNICATION_ERROR, false, false, "" + this.requestStatus));
    if (this.onError)
      this.onError(this);
  }
  this.cleanupCallbacks();
};


/**
 * @private
 * @param {number} value
 */
org.apache.flex.net.URLStream.prototype.setStatus = function(value) {
  if (value != this.requestStatus) {
    this.requestStatus = value;
    this.dispatchEvent(new org.apache.flex.events.DetailEvent(org.apache.flex.net.HTTPConstants.STATUS, false, false, "" + value));
    if (this.onStatus)
      this.onStatus(this);
  }
};


/**
 * @export
 */
org.apache.flex.net.URLStream.prototype.close = function() {
  
  this.xhr.abort();
  this.cleanupCallbacks();
};


/**
 * @export
 * @type {number}
 */
org.apache.flex.net.URLStream.prototype.requestStatus = 0;


/**
 * @export
 * @type {string}
 */
org.apache.flex.net.URLStream.prototype.endian;


/**
 * @private
 */
org.apache.flex.net.URLStream.prototype.cleanupCallbacks = function() {
  this.onComplete = null;
  this.onError = null;
  this.onProgress = null;
  this.onStatus = null;
};


/**
 * @export
 * @type {Function}
 */
org.apache.flex.net.URLStream.prototype.onComplete;


/**
 * @export
 * @type {Function}
 */
org.apache.flex.net.URLStream.prototype.onError;


/**
 * @export
 * @type {Function}
 */
org.apache.flex.net.URLStream.prototype.onProgress;


/**
 * @export
 * @type {Function}
 */
org.apache.flex.net.URLStream.prototype.onStatus;


/**
 *  Convenience function for complete event to allow chaining.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.7.0
 * @export
 * @param {Function} callback
 * @return {org.apache.flex.net.URLStream}
 */
org.apache.flex.net.URLStream.prototype.complete = function(callback) {
  this.onComplete = callback;
  return this;
};


/**
 *  Convenience function for error event to allow chaining.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.7.0
 * @export
 * @param {Function} callback
 * @return {org.apache.flex.net.URLStream}
 */
org.apache.flex.net.URLStream.prototype.error = function(callback) {
  this.onError = callback;
  return this;
};


/**
 *  Convenience function for progress event to allow chaining.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.7.0
 * @export
 * @param {Function} callback
 * @return {org.apache.flex.net.URLStream}
 */
org.apache.flex.net.URLStream.prototype.progress = function(callback) {
  this.onProgress = callback;
  return this;
};


/**
 *  Convenience function for status event to allow chaining.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.7.0
 * @export
 * @param {Function} callback
 * @return {org.apache.flex.net.URLStream}
 */
org.apache.flex.net.URLStream.prototype.status = function(callback) {
  this.onStatus = callback;
  return this;
};


Object.defineProperties(org.apache.flex.net.URLStream.prototype, /** @lends {org.apache.flex.net.URLStream.prototype} */ {
/** @export */
response: {
get: /** @this {org.apache.flex.net.URLStream} */ function() {
  return new org.apache.flex.utils.BinaryData(org.apache.flex.utils.Language.as(this.xhr.response, ArrayBuffer));
  
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.net.URLStream.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'URLStream', qName: 'org.apache.flex.net.URLStream'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.net.URLStream', org.apache.flex.net.URLStream);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.net.URLStream.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'bytesLoaded': { type: 'uint'},
        'bytesTotal': { type: 'uint'},
        'requestStatus': { type: 'int'},
        'endian': { type: 'String'},
        'onComplete': { type: 'Function'},
        'onError': { type: 'Function'},
        'onProgress': { type: 'Function'},
        'onStatus': { type: 'Function'}
      };
    },
    accessors: function () {
      return {
        'response': { type: 'BinaryData', declaredBy: 'org.apache.flex.net.URLStream'}
      };
    },
    methods: function () {
      return {
        'URLStream': { type: '', declaredBy: 'org.apache.flex.net.URLStream'},
        'load': { type: 'void', declaredBy: 'org.apache.flex.net.URLStream'},
        'close': { type: 'void', declaredBy: 'org.apache.flex.net.URLStream'},
        'complete': { type: 'org.apache.flex.net.URLStream', declaredBy: 'org.apache.flex.net.URLStream'},
        'error': { type: 'org.apache.flex.net.URLStream', declaredBy: 'org.apache.flex.net.URLStream'},
        'progress': { type: 'org.apache.flex.net.URLStream', declaredBy: 'org.apache.flex.net.URLStream'},
        'status': { type: 'org.apache.flex.net.URLStream', declaredBy: 'org.apache.flex.net.URLStream'}
      };
    }
  };
};