/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/mobile/TitleView.as
 * org.apache.flex.mobile.TitleView
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.mobile.TitleView');

goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.html.Container');
goog.require('org.apache.flex.core.IBeadController');
goog.require('org.apache.flex.mobile.IViewManagerView');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @extends {org.apache.flex.html.Container}
 * @implements {org.apache.flex.mobile.IViewManagerView}
 */
org.apache.flex.mobile.TitleView = function() {
  org.apache.flex.mobile.TitleView.base(this, 'constructor');
  this.percentWidth = 100;
  this.percentHeight = 100;
};
goog.inherits(org.apache.flex.mobile.TitleView, org.apache.flex.html.Container);


/**
 * @private
 * @type {string}
 */
org.apache.flex.mobile.TitleView.prototype._title;


/**
 * @export
 * @return {string}
 */
org.apache.flex.mobile.TitleView.prototype.toString = function() {
  return this._title;
};


/**
 * @private
 * @type {org.apache.flex.mobile.IViewManager}
 */
org.apache.flex.mobile.TitleView.prototype._viewManager;


/**
 * @private
 * @type {org.apache.flex.core.IBeadController}
 */
org.apache.flex.mobile.TitleView.prototype._controller;


Object.defineProperties(org.apache.flex.mobile.TitleView.prototype, /** @lends {org.apache.flex.mobile.TitleView.prototype} */ {
/** @export */
title: {
get: /** @this {org.apache.flex.mobile.TitleView} */ function() {
  return this._title;
},
set: /** @this {org.apache.flex.mobile.TitleView} */ function(value) {
  this._title = value;
}},
/** @export */
viewManager: {
get: /** @this {org.apache.flex.mobile.TitleView} */ function() {
  return this._viewManager;
},
set: /** @this {org.apache.flex.mobile.TitleView} */ function(value) {
  this._viewManager = value;
}},
/** @export */
controller: {
get: /** @this {org.apache.flex.mobile.TitleView} */ function() {
  if (this._controller == null) {
    this._controller = org.apache.flex.utils.Language.as(this.getBeadByType(org.apache.flex.core.IBeadController), org.apache.flex.core.IBeadController);
    if (this._controller == null) {
      var /** @type {Object} */ c = org.apache.flex.core.ValuesManager.valuesImpl.getValue(this, "iBeadController");
      this._controller = org.apache.flex.utils.Language.as(new c(), org.apache.flex.core.IBeadController);
      this.addBead(this._controller);
    }
  }
  return this._controller;
},
set: /** @this {org.apache.flex.mobile.TitleView} */ function(value) {
  this._controller = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.mobile.TitleView.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'TitleView', qName: 'org.apache.flex.mobile.TitleView'}], interfaces: [org.apache.flex.mobile.IViewManagerView] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.mobile.TitleView', org.apache.flex.mobile.TitleView);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.mobile.TitleView.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'title': { type: 'String', declaredBy: 'org.apache.flex.mobile.TitleView'},
        'viewManager': { type: 'IViewManager', declaredBy: 'org.apache.flex.mobile.TitleView'},
        'controller': { type: 'IBeadController', declaredBy: 'org.apache.flex.mobile.TitleView'}
      };
    },
    methods: function () {
      return {
        'TitleView': { type: '', declaredBy: 'org.apache.flex.mobile.TitleView'},
        'toString': { type: 'String', declaredBy: 'org.apache.flex.mobile.TitleView'}
      };
    }
  };
};