/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/mobile/StackedViewManager.as
 * org.apache.flex.mobile.StackedViewManager
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.mobile.StackedViewManager');

goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.mobile.ViewManagerBase');
goog.require('org.apache.flex.mobile.models.ViewManagerModel');
goog.require('org.apache.flex.mobile.IViewManager');
goog.require('org.apache.flex.mobile.IViewManagerView');
goog.require('org.apache.flex.utils.Language');



/**
 * Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.mobile.ViewManagerBase}
 * @implements {org.apache.flex.mobile.IViewManager}
 */
org.apache.flex.mobile.StackedViewManager = function() {
  org.apache.flex.mobile.StackedViewManager.base(this, 'constructor');
  this.className = "StackedViewManager";
};
goog.inherits(org.apache.flex.mobile.StackedViewManager, org.apache.flex.mobile.ViewManagerBase);


/**
 * @private
 * @type {org.apache.flex.mobile.IViewManagerView}
 */
org.apache.flex.mobile.StackedViewManager.prototype._topView;


/**
 *  Pushes the next view onto the navigation stack.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {org.apache.flex.mobile.IViewManagerView} nextView
 */
org.apache.flex.mobile.StackedViewManager.prototype.push = function(nextView) {
  nextView.viewManager = this;
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.mobile.models.ViewManagerModel, true).pushView(nextView);
  this.removeElement(this._topView);
  this._topView = nextView;
  this.addElement(this._topView);
  this.dispatchEvent(new org.apache.flex.events.Event("viewChanged"));
};


/**
 *  Pops the top-most view from the navigation stack.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 */
org.apache.flex.mobile.StackedViewManager.prototype.pop = function() {
  if (org.apache.flex.utils.Language.as(this.model, org.apache.flex.mobile.models.ViewManagerModel, true).views.length > 1) {
    var /** @type {Object} */ lastView = org.apache.flex.utils.Language.as(this.model, org.apache.flex.mobile.models.ViewManagerModel, true).popView();
    this.removeElement(this._topView);
    this.addElement(lastView);
    this._topView = org.apache.flex.utils.Language.as(lastView, org.apache.flex.mobile.IViewManagerView);
    this.dispatchEvent(new org.apache.flex.events.Event("viewChanged"));
  }
};


Object.defineProperties(org.apache.flex.mobile.StackedViewManager.prototype, /** @lends {org.apache.flex.mobile.StackedViewManager.prototype} */ {
/** @export */
hasToolBar: {
get: /** @this {org.apache.flex.mobile.StackedViewManager} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.mobile.models.ViewManagerModel, true).toolBarItems != null;
}},
/** @export */
toolBarItems: {
get: /** @this {org.apache.flex.mobile.StackedViewManager} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.mobile.models.ViewManagerModel, true).toolBarItems;
},
set: /** @this {org.apache.flex.mobile.StackedViewManager} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.mobile.models.ViewManagerModel, true).toolBarItems = value;
}},
/** @export */
toolBar: {
get: /** @this {org.apache.flex.mobile.StackedViewManager} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.mobile.models.ViewManagerModel, true).toolBar;
}},
/** @export */
selectedView: {
get: /** @this {org.apache.flex.mobile.StackedViewManager} */ function() {
  return this._topView;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.mobile.StackedViewManager.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'StackedViewManager', qName: 'org.apache.flex.mobile.StackedViewManager'}], interfaces: [org.apache.flex.mobile.IViewManager] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.mobile.StackedViewManager', org.apache.flex.mobile.StackedViewManager);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.mobile.StackedViewManager.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'hasToolBar': { type: 'Boolean', declaredBy: 'org.apache.flex.mobile.StackedViewManager'},
        'toolBarItems': { type: 'Array', declaredBy: 'org.apache.flex.mobile.StackedViewManager'},
        'toolBar': { type: 'ToolBar', declaredBy: 'org.apache.flex.mobile.StackedViewManager'},
        'selectedView': { type: 'IViewManagerView', declaredBy: 'org.apache.flex.mobile.StackedViewManager'}
      };
    },
    methods: function () {
      return {
        'StackedViewManager': { type: '', declaredBy: 'org.apache.flex.mobile.StackedViewManager'},
        'push': { type: 'void', declaredBy: 'org.apache.flex.mobile.StackedViewManager'},
        'pop': { type: 'void', declaredBy: 'org.apache.flex.mobile.StackedViewManager'}
      };
    }
  };
};