/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/supportClasses/GraphicsItemRenderer.as
 * org.apache.flex.html.supportClasses.GraphicsItemRenderer
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.supportClasses.GraphicsItemRenderer');

goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.svg.CompoundGraphic');
goog.require('org.apache.flex.utils.MXMLDataInterpreter');
goog.require('org.apache.flex.core.ISelectableItemRenderer');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.svg.CompoundGraphic}
 * @implements {org.apache.flex.core.ISelectableItemRenderer}
 */
org.apache.flex.html.supportClasses.GraphicsItemRenderer = function() {
  org.apache.flex.html.supportClasses.GraphicsItemRenderer.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.supportClasses.GraphicsItemRenderer, org.apache.flex.svg.CompoundGraphic);


/**
 * @asprivate
 * @export
 * @override
 */
org.apache.flex.html.supportClasses.GraphicsItemRenderer.prototype.addedToParent = function() {
  org.apache.flex.html.supportClasses.GraphicsItemRenderer.base(this, 'addedToParent');
  this.addEventListener("widthChanged", org.apache.flex.utils.Language.closure(this.sizeChangeHandler, this, 'sizeChangeHandler'));
  this.addEventListener("heightChanged", org.apache.flex.utils.Language.closure(this.sizeChangeHandler, this, 'sizeChangeHandler'));
  org.apache.flex.core.ValuesManager.valuesImpl.init(this);
  org.apache.flex.utils.MXMLDataInterpreter.generateMXMLProperties(this, this.mxmlProperties);
  org.apache.flex.utils.MXMLDataInterpreter.generateMXMLInstances(this, this, this.MXMLDescriptor);
  this.dispatchEvent(new org.apache.flex.events.Event("initBindings"));
  this.dispatchEvent(new org.apache.flex.events.Event("initComplete"));
};


/**
 * @private
 * @type {string}
 */
org.apache.flex.html.supportClasses.GraphicsItemRenderer.prototype._labelField = "label";


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.supportClasses.GraphicsItemRenderer.prototype._index;


/**
 * @private
 * @type {boolean}
 */
org.apache.flex.html.supportClasses.GraphicsItemRenderer.prototype._selected;


/**
 * @private
 * @type {boolean}
 */
org.apache.flex.html.supportClasses.GraphicsItemRenderer.prototype._hovered;


/**
 * @private
 * @type {boolean}
 */
org.apache.flex.html.supportClasses.GraphicsItemRenderer.prototype._down;


/**
 * @private
 * @type {Object}
 */
org.apache.flex.html.supportClasses.GraphicsItemRenderer.prototype._data;


/**
 * @private
 * @type {Object}
 */
org.apache.flex.html.supportClasses.GraphicsItemRenderer.prototype._listData;


/**
 * @private
 * @type {string}
 */
org.apache.flex.html.supportClasses.GraphicsItemRenderer.prototype._dataField;


/**
 * @private
 * @type {Object}
 */
org.apache.flex.html.supportClasses.GraphicsItemRenderer.prototype._itemRendererParent;


/**
 * @asprivate
 * @export
 */
org.apache.flex.html.supportClasses.GraphicsItemRenderer.prototype.updateRenderer = function() {
};


/**
 * @export
 * @type {Array}
 */
org.apache.flex.html.supportClasses.GraphicsItemRenderer.prototype.mxmlContent;


/**
 * @private
 * @type {Array}
 */
org.apache.flex.html.supportClasses.GraphicsItemRenderer.prototype.mxmlProperties;


/**
 * @asprivate
 * @export
 * @param {Array} data
 */
org.apache.flex.html.supportClasses.GraphicsItemRenderer.prototype.generateMXMLAttributes = function(data) {
  this.mxmlProperties = data;
};


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.supportClasses.GraphicsItemRenderer.prototype.sizeChangeHandler = function(event) {
  this.adjustSize();
};


/**
 *  This function is called whenever the itemRenderer changes size. Sub-classes should override
 *  this method an handle the size change.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 */
org.apache.flex.html.supportClasses.GraphicsItemRenderer.prototype.adjustSize = function() {
};


Object.defineProperties(org.apache.flex.html.supportClasses.GraphicsItemRenderer.prototype, /** @lends {org.apache.flex.html.supportClasses.GraphicsItemRenderer.prototype} */ {
/** @export */
labelField: {
get: /** @this {org.apache.flex.html.supportClasses.GraphicsItemRenderer} */ function() {
  return this._labelField;
},
set: /** @this {org.apache.flex.html.supportClasses.GraphicsItemRenderer} */ function(value) {
  this._labelField = value;
}},
/** @export */
index: {
get: /** @this {org.apache.flex.html.supportClasses.GraphicsItemRenderer} */ function() {
  return this._index;
},
set: /** @this {org.apache.flex.html.supportClasses.GraphicsItemRenderer} */ function(value) {
  this._index = value;
}},
/** @export */
selected: {
get: /** @this {org.apache.flex.html.supportClasses.GraphicsItemRenderer} */ function() {
  return this._selected;
},
set: /** @this {org.apache.flex.html.supportClasses.GraphicsItemRenderer} */ function(value) {
  this._selected = value;
  this.updateRenderer();
}},
/** @export */
hovered: {
get: /** @this {org.apache.flex.html.supportClasses.GraphicsItemRenderer} */ function() {
  return this._hovered;
},
set: /** @this {org.apache.flex.html.supportClasses.GraphicsItemRenderer} */ function(value) {
  this._hovered = value;
  this.updateRenderer();
}},
/** @export */
down: {
get: /** @this {org.apache.flex.html.supportClasses.GraphicsItemRenderer} */ function() {
  return this._down;
},
set: /** @this {org.apache.flex.html.supportClasses.GraphicsItemRenderer} */ function(value) {
  this._down = value;
  this.updateRenderer();
}},
/** @export */
data: {
get: /** @this {org.apache.flex.html.supportClasses.GraphicsItemRenderer} */ function() {
  return this._data;
},
set: /** @this {org.apache.flex.html.supportClasses.GraphicsItemRenderer} */ function(value) {
  this._data = value;
}},
/** @export */
listData: {
get: /** @this {org.apache.flex.html.supportClasses.GraphicsItemRenderer} */ function() {
  return this._listData;
},
set: /** @this {org.apache.flex.html.supportClasses.GraphicsItemRenderer} */ function(value) {
  this._listData = value;
}},
/** @export */
dataField: {
get: /** @this {org.apache.flex.html.supportClasses.GraphicsItemRenderer} */ function() {
  return this._dataField;
},
set: /** @this {org.apache.flex.html.supportClasses.GraphicsItemRenderer} */ function(value) {
  this._dataField = value;
}},
/** @export */
itemRendererParent: {
get: /** @this {org.apache.flex.html.supportClasses.GraphicsItemRenderer} */ function() {
  return this._itemRendererParent;
},
set: /** @this {org.apache.flex.html.supportClasses.GraphicsItemRenderer} */ function(value) {
  this._itemRendererParent = value;
}},
/** @export */
MXMLDescriptor: {
get: /** @this {org.apache.flex.html.supportClasses.GraphicsItemRenderer} */ function() {
  return null;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.supportClasses.GraphicsItemRenderer.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'GraphicsItemRenderer', qName: 'org.apache.flex.html.supportClasses.GraphicsItemRenderer'}], interfaces: [org.apache.flex.core.ISelectableItemRenderer] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.supportClasses.GraphicsItemRenderer', org.apache.flex.html.supportClasses.GraphicsItemRenderer);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.supportClasses.GraphicsItemRenderer.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'mxmlContent': { type: 'Array'}
      };
    },
    accessors: function () {
      return {
        'labelField': { type: 'String', declaredBy: 'org.apache.flex.html.supportClasses.GraphicsItemRenderer'},
        'index': { type: 'int', declaredBy: 'org.apache.flex.html.supportClasses.GraphicsItemRenderer'},
        'selected': { type: 'Boolean', declaredBy: 'org.apache.flex.html.supportClasses.GraphicsItemRenderer'},
        'hovered': { type: 'Boolean', declaredBy: 'org.apache.flex.html.supportClasses.GraphicsItemRenderer'},
        'down': { type: 'Boolean', declaredBy: 'org.apache.flex.html.supportClasses.GraphicsItemRenderer'},
        'data': { type: 'Object', declaredBy: 'org.apache.flex.html.supportClasses.GraphicsItemRenderer', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: '__NoChangeEvent__'}]}]; }},
        'listData': { type: 'Object', declaredBy: 'org.apache.flex.html.supportClasses.GraphicsItemRenderer', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: '__NoChangeEvent__'}]}]; }},
        'dataField': { type: 'String', declaredBy: 'org.apache.flex.html.supportClasses.GraphicsItemRenderer'},
        'itemRendererParent': { type: 'Object', declaredBy: 'org.apache.flex.html.supportClasses.GraphicsItemRenderer'},
        'MXMLDescriptor': { type: 'Array', declaredBy: 'org.apache.flex.html.supportClasses.GraphicsItemRenderer'}
      };
    },
    methods: function () {
      return {
        'GraphicsItemRenderer': { type: '', declaredBy: 'org.apache.flex.html.supportClasses.GraphicsItemRenderer'},
        'addedToParent': { type: 'void', declaredBy: 'org.apache.flex.html.supportClasses.GraphicsItemRenderer'},
        'updateRenderer': { type: 'void', declaredBy: 'org.apache.flex.html.supportClasses.GraphicsItemRenderer'},
        'generateMXMLAttributes': { type: 'void', declaredBy: 'org.apache.flex.html.supportClasses.GraphicsItemRenderer'},
        'adjustSize': { type: 'void', declaredBy: 'org.apache.flex.html.supportClasses.GraphicsItemRenderer'}
      };
    }
  };
};