/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/models/RangeModel.as
 * org.apache.flex.html.beads.models.RangeModel
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.models.RangeModel');

goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.events.EventDispatcher');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.IRangeModel');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.events.EventDispatcher}
 * @implements {org.apache.flex.core.IBead}
 * @implements {org.apache.flex.core.IRangeModel}
 */
org.apache.flex.html.beads.models.RangeModel = function() {
  org.apache.flex.html.beads.models.RangeModel.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.beads.models.RangeModel, org.apache.flex.events.EventDispatcher);


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.html.beads.models.RangeModel.prototype._strand;


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.beads.models.RangeModel.prototype._maximum = 100;


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.beads.models.RangeModel.prototype._minimum = 0;


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.beads.models.RangeModel.prototype._snapInterval = 1;


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.beads.models.RangeModel.prototype._stepSize = 1;


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.beads.models.RangeModel.prototype._value = 0;


/**
 * @asprivate
 * @protected
 * @param {number} value
 * @return {number}
 */
org.apache.flex.html.beads.models.RangeModel.prototype.snap = function(value) {
  var /** @type {number} */ si = this.snapInterval;
  var /** @type {number} */ n = Math.round((value - this.minimum) / si) * si + this.minimum;
  if (value > 0) {
    if (value - n < n + si - value)
      return n;
    return n + si;
  }
  if (value - n > n + si - value)
    return n + si;
  return n;
};


Object.defineProperties(org.apache.flex.html.beads.models.RangeModel.prototype, /** @lends {org.apache.flex.html.beads.models.RangeModel.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.models.RangeModel} */ function(value) {
  this._strand = value;
}},
/** @export */
maximum: {
get: /** @this {org.apache.flex.html.beads.models.RangeModel} */ function() {
  return this._maximum;
},
set: /** @this {org.apache.flex.html.beads.models.RangeModel} */ function(value) {
  if (value != this._maximum) {
    this._maximum = value;
    this.dispatchEvent(new org.apache.flex.events.Event("maximumChange"));
  }
}},
/** @export */
minimum: {
get: /** @this {org.apache.flex.html.beads.models.RangeModel} */ function() {
  return this._minimum;
},
set: /** @this {org.apache.flex.html.beads.models.RangeModel} */ function(value) {
  if (value != this._minimum) {
    this._minimum = value;
    this.dispatchEvent(new org.apache.flex.events.Event("minimumChange"));
  }
}},
/** @export */
snapInterval: {
get: /** @this {org.apache.flex.html.beads.models.RangeModel} */ function() {
  return this._snapInterval;
},
set: /** @this {org.apache.flex.html.beads.models.RangeModel} */ function(value) {
  if (value != this._snapInterval) {
    this._snapInterval = value;
    this.dispatchEvent(new org.apache.flex.events.Event("snapIntervalChange"));
  }
}},
/** @export */
stepSize: {
get: /** @this {org.apache.flex.html.beads.models.RangeModel} */ function() {
  return this._stepSize;
},
set: /** @this {org.apache.flex.html.beads.models.RangeModel} */ function(value) {
  if (value != this._stepSize) {
    this._stepSize = value;
    this.dispatchEvent(new org.apache.flex.events.Event("stepSizeChange"));
  }
}},
/** @export */
value: {
get: /** @this {org.apache.flex.html.beads.models.RangeModel} */ function() {
  return this._value;
},
set: /** @this {org.apache.flex.html.beads.models.RangeModel} */ function(newValue) {
  if (newValue != this._value) {
    newValue = Math.max(this.minimum, newValue - this.stepSize);
    newValue = Math.min(this.maximum, newValue + this.stepSize);
    this._value = this.snap(newValue);
    this.dispatchEvent(new org.apache.flex.events.Event("valueChange"));
  }
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.models.RangeModel.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'RangeModel', qName: 'org.apache.flex.html.beads.models.RangeModel'}], interfaces: [org.apache.flex.core.IBead, org.apache.flex.core.IRangeModel] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.models.RangeModel', org.apache.flex.html.beads.models.RangeModel);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.models.RangeModel.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.models.RangeModel'},
        'maximum': { type: 'Number', declaredBy: 'org.apache.flex.html.beads.models.RangeModel'},
        'minimum': { type: 'Number', declaredBy: 'org.apache.flex.html.beads.models.RangeModel'},
        'snapInterval': { type: 'Number', declaredBy: 'org.apache.flex.html.beads.models.RangeModel'},
        'stepSize': { type: 'Number', declaredBy: 'org.apache.flex.html.beads.models.RangeModel'},
        'value': { type: 'Number', declaredBy: 'org.apache.flex.html.beads.models.RangeModel'}
      };
    },
    methods: function () {
      return {
        'RangeModel': { type: '', declaredBy: 'org.apache.flex.html.beads.models.RangeModel'}
      };
    }
  };
};