/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/models/ArraySelectionModel.as
 * org.apache.flex.html.beads.models.ArraySelectionModel
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.models.ArraySelectionModel');

goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.events.EventDispatcher');
goog.require('org.apache.flex.core.IRollOverModel');
goog.require('org.apache.flex.core.ISelectionModel');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.events.EventDispatcher}
 * @implements {org.apache.flex.core.ISelectionModel}
 * @implements {org.apache.flex.core.IRollOverModel}
 */
org.apache.flex.html.beads.models.ArraySelectionModel = function() {
  org.apache.flex.html.beads.models.ArraySelectionModel.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.beads.models.ArraySelectionModel, org.apache.flex.events.EventDispatcher);


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.html.beads.models.ArraySelectionModel.prototype._strand;


/**
 * @private
 * @type {Object}
 */
org.apache.flex.html.beads.models.ArraySelectionModel.prototype._dataProvider;


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.beads.models.ArraySelectionModel.prototype._selectedIndex = -1;


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.beads.models.ArraySelectionModel.prototype._rollOverIndex = -1;


/**
 * @private
 * @type {string}
 */
org.apache.flex.html.beads.models.ArraySelectionModel.prototype._labelField = null;


/**
 * @private
 * @type {Object}
 */
org.apache.flex.html.beads.models.ArraySelectionModel.prototype._selectedItem;


/**
 * @private
 * @type {string}
 */
org.apache.flex.html.beads.models.ArraySelectionModel.prototype._selectedString;


Object.defineProperties(org.apache.flex.html.beads.models.ArraySelectionModel.prototype, /** @lends {org.apache.flex.html.beads.models.ArraySelectionModel.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.models.ArraySelectionModel} */ function(value) {
  this._strand = value;
}},
/** @export */
dataProvider: {
get: /** @this {org.apache.flex.html.beads.models.ArraySelectionModel} */ function() {
  return this._dataProvider;
},
set: /** @this {org.apache.flex.html.beads.models.ArraySelectionModel} */ function(value) {
  if (value === this._dataProvider)
    return;
  this._dataProvider = value;
  if (this._selectedIndex != -1)
    this._selectedItem = (this._dataProvider == null || this._selectedIndex >= this._dataProvider.length) ? null : this._dataProvider[this._selectedIndex];
  this.dispatchEvent(new org.apache.flex.events.Event("dataProviderChanged"));
}},
/** @export */
labelField: {
get: /** @this {org.apache.flex.html.beads.models.ArraySelectionModel} */ function() {
  return this._labelField;
},
set: /** @this {org.apache.flex.html.beads.models.ArraySelectionModel} */ function(value) {
  if (value != this._labelField) {
    this._labelField = value;
    this.dispatchEvent(new org.apache.flex.events.Event("labelFieldChanged"));
  }
}},
/** @export */
selectedIndex: {
get: /** @this {org.apache.flex.html.beads.models.ArraySelectionModel} */ function() {
  return this._selectedIndex;
},
set: /** @this {org.apache.flex.html.beads.models.ArraySelectionModel} */ function(value) {
  if (value === this._selectedIndex)
    return;
  this._selectedIndex = value;
  this._selectedItem = (value == -1 || this._dataProvider == null) ? null : (value < this._dataProvider.length) ? this._dataProvider[value] : null;
  this.dispatchEvent(new org.apache.flex.events.Event("selectedIndexChanged"));
}},
/** @export */
rollOverIndex: {
get: /** @this {org.apache.flex.html.beads.models.ArraySelectionModel} */ function() {
  return this._rollOverIndex;
},
set: /** @this {org.apache.flex.html.beads.models.ArraySelectionModel} */ function(value) {
  this._rollOverIndex = value;
  this.dispatchEvent(new org.apache.flex.events.Event("rollOverIndexChanged"));
}},
/** @export */
selectedItem: {
get: /** @this {org.apache.flex.html.beads.models.ArraySelectionModel} */ function() {
  return this._selectedItem;
},
set: /** @this {org.apache.flex.html.beads.models.ArraySelectionModel} */ function(value) {
  if (value === this._selectedItem)
    return;
  this._selectedItem = value;
  var /** @type {number} */ n = Number(this._dataProvider.length);
  for (var /** @type {number} */ i = 0; i < n; i++) {
    if (this._dataProvider[i] == value) {
      this._selectedIndex = i;
      break;
    }
  }
  this.dispatchEvent(new org.apache.flex.events.Event("selectedItemChanged"));
  this.dispatchEvent(new org.apache.flex.events.Event("selectedIndexChanged"));
}},
/** @export */
selectedString: {
get: /** @this {org.apache.flex.html.beads.models.ArraySelectionModel} */ function() {
  return String(this._selectedItem);
},
set: /** @this {org.apache.flex.html.beads.models.ArraySelectionModel} */ function(value) {
  this._selectedString = value;
  var /** @type {number} */ n = Number(this._dataProvider.length);
  for (var /** @type {number} */ i = 0; i < n; i++) {
    if (String(this._dataProvider[i]) == value) {
      this._selectedIndex = i;
      break;
    }
  }
  this.dispatchEvent(new org.apache.flex.events.Event("selectedItemChanged"));
  this.dispatchEvent(new org.apache.flex.events.Event("selectedIndexChanged"));
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.models.ArraySelectionModel.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ArraySelectionModel', qName: 'org.apache.flex.html.beads.models.ArraySelectionModel'}], interfaces: [org.apache.flex.core.ISelectionModel, org.apache.flex.core.IRollOverModel] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.models.ArraySelectionModel', org.apache.flex.html.beads.models.ArraySelectionModel);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.models.ArraySelectionModel.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.models.ArraySelectionModel'},
        'dataProvider': { type: 'Object', declaredBy: 'org.apache.flex.html.beads.models.ArraySelectionModel'},
        'labelField': { type: 'String', declaredBy: 'org.apache.flex.html.beads.models.ArraySelectionModel'},
        'selectedIndex': { type: 'int', declaredBy: 'org.apache.flex.html.beads.models.ArraySelectionModel'},
        'rollOverIndex': { type: 'int', declaredBy: 'org.apache.flex.html.beads.models.ArraySelectionModel'},
        'selectedItem': { type: 'Object', declaredBy: 'org.apache.flex.html.beads.models.ArraySelectionModel'},
        'selectedString': { type: 'String', declaredBy: 'org.apache.flex.html.beads.models.ArraySelectionModel'}
      };
    },
    methods: function () {
      return {
        'ArraySelectionModel': { type: '', declaredBy: 'org.apache.flex.html.beads.models.ArraySelectionModel'}
      };
    }
  };
};