/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/layouts/OneFlexibleChildHorizontalLayout.as
 * org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout');

goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.utils.CSSContainerUtils');
goog.require('org.apache.flex.utils.CSSUtils');
goog.require('org.apache.flex.core.IBeadLayout');
goog.require('org.apache.flex.core.IDocument');
goog.require('org.apache.flex.core.ILayoutChild');
goog.require('org.apache.flex.core.ILayoutHost');
goog.require('org.apache.flex.core.IParentIUIBase');
goog.require('org.apache.flex.core.IUIBase');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBeadLayout}
 * @implements {org.apache.flex.core.IDocument}
 */
org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout = function() {
};


/**
 * @export
 * @type {string}
 */
org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout.prototype.flexibleChild;


/**
 * @private
 * @type {org.apache.flex.core.ILayoutChild}
 */
org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout.prototype.actualChild;


/**
 * @private
 * @type {org.apache.flex.core.ILayoutChild}
 */
org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout.prototype.host;


/**
 * @private
 * @type {Object}
 */
org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout.prototype.document;


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout.prototype._maxWidth;


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout.prototype._maxHeight;


/**
 * @copy org.apache.flex.core.IBeadLayout#layout
 * @export
 * @return {boolean}
 */
org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout.prototype.layout = function() {
  var /** @type {org.apache.flex.core.ILayoutHost} */ layoutParent = org.apache.flex.utils.Language.as(this.host.getBeadByType(org.apache.flex.core.ILayoutHost), org.apache.flex.core.ILayoutHost);
  var /** @type {org.apache.flex.core.IParentIUIBase} */ contentView = layoutParent ? layoutParent.contentView : org.apache.flex.utils.Language.as(this.host, org.apache.flex.core.IParentIUIBase, true);
  var /** @type {org.apache.flex.geom.Rectangle} */ padding = org.apache.flex.utils.CSSContainerUtils.getPaddingMetrics(this.host);
  this.actualChild = this.document[this.flexibleChild];
  var /** @type {org.apache.flex.core.ILayoutChild} */ ilc;
  var /** @type {number} */ n = contentView.numElements;
  var /** @type {Object} */ marginLeft;
  var /** @type {Object} */ marginRight;
  var /** @type {Object} */ marginTop;
  var /** @type {Object} */ marginBottom;
  var /** @type {Object} */ margin;
  this.maxHeight = 0;
  var /** @type {Array} */ verticalMargins = new Array(n);
  var /** @type {number} */ ww = contentView.width - padding.right;
  var /** @type {number} */ hh = contentView.height;
  var /** @type {number} */ xx = padding.left;
  var /** @type {number} */ flexChildIndex;
  var /** @type {number} */ ml;
  var /** @type {number} */ mr;
  var /** @type {number} */ mt;
  var /** @type {number} */ mb;
  var /** @type {number} */ lastmr;
  var /** @type {number} */ lastml;
  var /** @type {Object} */ valign;
  var /** @type {boolean} */ hostSizedToContent = this.host.isHeightSizedToContent();
  for (var /** @type {number} */ i = 0; i < n; i++) {
    var /** @type {org.apache.flex.core.IUIBase} */ child = org.apache.flex.utils.Language.as(contentView.getElementAt(i), org.apache.flex.core.IUIBase);
    if (child == this.actualChild) {
      flexChildIndex = i;
      break;
    }
    margin = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin");
    marginLeft = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin-left");
    marginTop = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin-top");
    marginRight = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin-right");
    marginBottom = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin-bottom");
    mt = org.apache.flex.utils.CSSUtils.getTopValue(marginTop, margin, hh);
    mb = org.apache.flex.utils.CSSUtils.getBottomValue(marginBottom, margin, hh);
    mr = org.apache.flex.utils.CSSUtils.getRightValue(marginRight, margin, ww);
    ml = org.apache.flex.utils.CSSUtils.getLeftValue(marginLeft, margin, ww);
    child.y = mt + padding.top;
    if (org.apache.flex.utils.Language.is(child, org.apache.flex.core.ILayoutChild)) {
      ilc = org.apache.flex.utils.Language.as(child, org.apache.flex.core.ILayoutChild);
      if (!isNaN(ilc.percentHeight))
        ilc.setHeight(contentView.height * ilc.percentHeight / 100, true);
    }
    this.maxHeight = Math.max(this.maxHeight, mt + child.height + mb);
    child.x = xx + ml;
    xx += child.width + ml + mr;
    lastmr = mr;
    valign = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "vertical-align");
    verticalMargins[i] = {marginTop:mt, marginBottom:mb, valign:valign};
  }
  if (n > 0 && n > flexChildIndex) {
    for (i = n - 1; i > flexChildIndex; i--) {
      child = org.apache.flex.utils.Language.as(contentView.getElementAt(i), org.apache.flex.core.IUIBase);
      margin = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin");
      marginLeft = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin-left");
      marginTop = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin-top");
      marginRight = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin-right");
      marginBottom = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin-bottom");
      mt = org.apache.flex.utils.CSSUtils.getTopValue(marginTop, margin, hh);
      mb = org.apache.flex.utils.CSSUtils.getTopValue(marginBottom, margin, hh);
      mr = org.apache.flex.utils.CSSUtils.getRightValue(marginRight, margin, ww);
      ml = org.apache.flex.utils.CSSUtils.getLeftValue(marginLeft, margin, ww);
      child.y = mt + padding.top;
      if (org.apache.flex.utils.Language.is(child, org.apache.flex.core.ILayoutChild)) {
        ilc = org.apache.flex.utils.Language.as(child, org.apache.flex.core.ILayoutChild);
        if (!isNaN(ilc.percentHeight))
          ilc.setHeight(contentView.height * ilc.percentHeight / 100, true);
      }
      this.maxHeight = Math.max(this.maxHeight, mt + child.height + mb);
      child.x = ww - child.width - mr;
      ww -= child.width + ml + mr;
      lastml = ml;
      valign = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "vertical-align");
      verticalMargins[i] = {marginTop:mt, marginBottom:mb, valign:valign};
    }
    child = org.apache.flex.utils.Language.as(contentView.getElementAt(flexChildIndex), org.apache.flex.core.IUIBase);
    margin = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin");
    marginLeft = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin-left");
    marginTop = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin-top");
    marginRight = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin-right");
    marginBottom = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "margin-bottom");
    mt = org.apache.flex.utils.CSSUtils.getTopValue(marginTop, margin, hh);
    mb = org.apache.flex.utils.CSSUtils.getTopValue(marginBottom, margin, hh);
    mr = org.apache.flex.utils.CSSUtils.getRightValue(marginRight, margin, ww);
    ml = org.apache.flex.utils.CSSUtils.getLeftValue(marginLeft, margin, ww);
    if (org.apache.flex.utils.Language.is(child, org.apache.flex.core.ILayoutChild)) {
      ilc = org.apache.flex.utils.Language.as(child, org.apache.flex.core.ILayoutChild);
      if (!isNaN(ilc.percentHeight))
        ilc.setHeight(contentView.height * ilc.percentHeight / 100, true);
    }
    child.x = xx + ml;
    child.width = ww - child.x;
    this.maxHeight = Math.max(this.maxHeight, mt + child.height + mb);
    valign = org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, "vertical-align");
    verticalMargins[flexChildIndex] = {marginTop:mt, marginBottom:mb, valign:valign};
  }
  if (hostSizedToContent)
    org.apache.flex.utils.Language.as(contentView, org.apache.flex.core.ILayoutChild, true).setHeight(this.maxHeight + padding.top + padding.bottom, true);
  for (i = 0; i < n; i++) {
    var /** @type {Object} */ obj = verticalMargins[i];
    child = org.apache.flex.utils.Language.as(contentView.getElementAt(i), org.apache.flex.core.IUIBase);
    this.setPositionAndHeight(child, obj.top, obj.marginTop, padding.top, obj.bottom, obj.marginBottom, padding.bottom, this.maxHeight, obj.valign);
  }
  return true;
};


/**
 * @private
 * @param {org.apache.flex.core.IUIBase} child
 * @param {number} top
 * @param {number} mt
 * @param {number} pt
 * @param {number} bottom
 * @param {number} mb
 * @param {number} pb
 * @param {number} h
 * @param {string} valign
 */
org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout.prototype.setPositionAndHeight = function(child, top, mt, pt, bottom, mb, pb, h, valign) {
  var /** @type {boolean} */ heightSet = false;
  var /** @type {boolean} */ ySet = false;
  var /** @type {number} */ hh = h;
  var /** @type {org.apache.flex.core.ILayoutChild} */ ilc = org.apache.flex.utils.Language.as(child, org.apache.flex.core.ILayoutChild);
  if (!isNaN(top)) {
    child.y = top + mt;
    ySet = true;
    hh -= top + mt;
  } else {
    hh -= mt;
  }
  if (!isNaN(bottom)) {
    if (!isNaN(top)) {
      if (ilc)
        ilc.setHeight(hh - bottom - mb, true); else {
        child.height = hh - bottom - mb;
        heightSet = true;
      }
    } else {
      child.y = h - bottom - mb - child.height - 1;
      ySet = true;
    }
  }
  if (ilc) {
    if (!isNaN(ilc.percentHeight))
      ilc.setHeight(h * ilc.percentHeight / 100, true);
  }
  if (valign == "center")
    child.y = (h - child.height) / 2;
  else if (valign == "bottom")
    child.y = h - child.height - mb;
  else
    child.y = mt + pt;
  if (!heightSet)
    child.dispatchEvent(new org.apache.flex.events.Event("sizeChanged"));
};


/**
 * @export
 * @param {Object} document
 * @param {string=} id
 */
org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout.prototype.setDocument = function(document, id) {
  id = typeof id !== 'undefined' ? id : null;
  this.document = document;
};


Object.defineProperties(org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout.prototype, /** @lends {org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout} */ function(value) {
  this.host = org.apache.flex.utils.Language.as(value, org.apache.flex.core.ILayoutChild);
}},
/** @export */
maxWidth: {
get: /** @this {org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout} */ function() {
  return this._maxWidth;
},
set: /** @this {org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout} */ function(value) {
  this._maxWidth = value;
}},
/** @export */
maxHeight: {
get: /** @this {org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout} */ function() {
  return this._maxHeight;
},
set: /** @this {org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout} */ function(value) {
  this._maxHeight = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'OneFlexibleChildHorizontalLayout', qName: 'org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout'}], interfaces: [org.apache.flex.core.IBeadLayout, org.apache.flex.core.IDocument] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout', org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'flexibleChild': { type: 'String'}
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout'},
        'maxWidth': { type: 'Number', declaredBy: 'org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout'},
        'maxHeight': { type: 'Number', declaredBy: 'org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout'}
      };
    },
    methods: function () {
      return {
        'OneFlexibleChildHorizontalLayout': { type: '', declaredBy: 'org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout'},
        'layout': { type: 'Boolean', declaredBy: 'org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout'},
        'setDocument': { type: 'void', declaredBy: 'org.apache.flex.html.beads.layouts.OneFlexibleChildHorizontalLayout'}
      };
    }
  };
};