/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/controllers/DateChooserMouseController.as
 * org.apache.flex.html.beads.controllers.DateChooserMouseController
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.controllers.DateChooserMouseController');

goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.html.beads.DateChooserView');
goog.require('org.apache.flex.html.beads.models.DateChooserModel');
goog.require('org.apache.flex.html.supportClasses.DateChooserButton');
goog.require('org.apache.flex.core.IBeadController');
goog.require('org.apache.flex.core.IBeadModel');
goog.require('org.apache.flex.core.IBeadView');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBeadController}
 */
org.apache.flex.html.beads.controllers.DateChooserMouseController = function() {
};


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.html.beads.controllers.DateChooserMouseController.prototype._strand;


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.controllers.DateChooserMouseController.prototype.prevMonthClickHandler = function(event) {
  var /** @type {org.apache.flex.html.beads.models.DateChooserModel} */ model = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.html.beads.models.DateChooserModel);
  var /** @type {number} */ month = model.displayedMonth - 1;
  var /** @type {number} */ year = model.displayedYear;
  if (month < 0) {
    month = 11;
    year--;
  }
  model.displayedMonth = month;
  model.displayedYear = year;
};


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.controllers.DateChooserMouseController.prototype.nextMonthClickHandler = function(event) {
  var /** @type {org.apache.flex.html.beads.models.DateChooserModel} */ model = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.html.beads.models.DateChooserModel);
  var /** @type {number} */ month = model.displayedMonth + 1;
  var /** @type {number} */ year = model.displayedYear;
  if (month >= 12) {
    month = 0;
    year++;
  }
  model.displayedMonth = month;
  model.displayedYear = year;
};


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.MouseEvent} event
 */
org.apache.flex.html.beads.controllers.DateChooserMouseController.prototype.dayButtonClickHandler = function(event) {
  var /** @type {org.apache.flex.html.supportClasses.DateChooserButton} */ dateButton = org.apache.flex.utils.Language.as(event.target, org.apache.flex.html.supportClasses.DateChooserButton);
  if (dateButton.dayOfMonth > 0) {
    var /** @type {org.apache.flex.html.beads.models.DateChooserModel} */ model = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.html.beads.models.DateChooserModel);
    var /** @type {Date} */ newDate = new Date(model.displayedYear, model.displayedMonth, dateButton.dayOfMonth);
    model.selectedDate = newDate;
    org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher, true).dispatchEvent(new org.apache.flex.events.Event("change"));
  }
};


Object.defineProperties(org.apache.flex.html.beads.controllers.DateChooserMouseController.prototype, /** @lends {org.apache.flex.html.beads.controllers.DateChooserMouseController.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.controllers.DateChooserMouseController} */ function(value) {
  this._strand = value;
  var /** @type {org.apache.flex.html.beads.DateChooserView} */ view = org.apache.flex.utils.Language.as(value.getBeadByType(org.apache.flex.core.IBeadView), org.apache.flex.html.beads.DateChooserView);
  view.prevMonthButton.addEventListener("click", org.apache.flex.utils.Language.closure(this.prevMonthClickHandler, this, 'prevMonthClickHandler'));
  view.nextMonthButton.addEventListener("click", org.apache.flex.utils.Language.closure(this.nextMonthClickHandler, this, 'nextMonthClickHandler'));
  var /** @type {Array} */ dayButtons = view.dayButtons;
  for (var /** @type {number} */ i = 0; i < dayButtons.length; i++) {
    org.apache.flex.utils.Language.as(dayButtons[i], org.apache.flex.events.IEventDispatcher, true).addEventListener("click", org.apache.flex.utils.Language.closure(this.dayButtonClickHandler, this, 'dayButtonClickHandler'));
  }
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.controllers.DateChooserMouseController.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'DateChooserMouseController', qName: 'org.apache.flex.html.beads.controllers.DateChooserMouseController'}], interfaces: [org.apache.flex.core.IBeadController] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.controllers.DateChooserMouseController', org.apache.flex.html.beads.controllers.DateChooserMouseController);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.controllers.DateChooserMouseController.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.controllers.DateChooserMouseController'}
      };
    },
    methods: function () {
      return {
        'DateChooserMouseController': { type: '', declaredBy: 'org.apache.flex.html.beads.controllers.DateChooserMouseController'}
      };
    }
  };
};