/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/MXMLBeadView.as
 * org.apache.flex.html.MXMLBeadView
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.MXMLBeadView');

goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.events.ValueChangeEvent');
goog.require('org.apache.flex.html.beads.ContainerView');
goog.require('org.apache.flex.utils.MXMLDataInterpreter');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.ILayoutHost');
goog.require('org.apache.flex.core.IParent');
goog.require('org.apache.flex.core.IStatesImpl');
goog.require('org.apache.flex.core.IStrand');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.html.beads.ContainerView}
 * @implements {org.apache.flex.core.IStrand}
 * @implements {org.apache.flex.core.ILayoutHost}
 */
org.apache.flex.html.MXMLBeadView = function() {
  org.apache.flex.html.MXMLBeadView.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.MXMLBeadView, org.apache.flex.html.beads.ContainerView);


/**
 *  @copy org.apache.flex.core.Application#generateMXMLAttributes()
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Array} data
 */
org.apache.flex.html.MXMLBeadView.prototype.generateMXMLAttributes = function(data) {
  org.apache.flex.utils.MXMLDataInterpreter.generateMXMLProperties(this, data);
};


/**
 * @export
 * @type {Array}
 */
org.apache.flex.html.MXMLBeadView.prototype.mxmlContent;


/**
 * @private
 * @type {Array}
 */
org.apache.flex.html.MXMLBeadView.prototype._states;


/**
 *  <code>true</code> if the array of states
 *  contains a state with this name.
 * 
 *  @asparam state The state namem.
 *  @asreturn True if state in state array
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} state
 * @return {boolean}
 */
org.apache.flex.html.MXMLBeadView.prototype.hasState = function(state) {
  var foreachiter0_target = this._states;
  for (var foreachiter0 in foreachiter0_target) 
  {
  var s = foreachiter0_target[foreachiter0];
  {
    if (s.name == state)
      return true;
  }}
  
  return false;
};


/**
 * @private
 * @type {string}
 */
org.apache.flex.html.MXMLBeadView.prototype._currentState;


/**
 * @private
 * @type {Array}
 */
org.apache.flex.html.MXMLBeadView.prototype._transitions;


/**
 * @export
 * @type {Array}
 */
org.apache.flex.html.MXMLBeadView.prototype.beads;


/**
 * @private
 * @type {Array}
 */
org.apache.flex.html.MXMLBeadView.prototype._beads;


/**
 *  @copy org.apache.flex.core.IStrand#addBead()
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {org.apache.flex.core.IBead} bead
 */
org.apache.flex.html.MXMLBeadView.prototype.addBead = function(bead) {
  if (!this._beads)
    this._beads = [];
  this._beads.push(bead);
  bead.strand = this;
};


/**
 *  @copy org.apache.flex.core.IStrand#getBeadByType()
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} classOrInterface
 * @return {org.apache.flex.core.IBead}
 */
org.apache.flex.html.MXMLBeadView.prototype.getBeadByType = function(classOrInterface) {
  var foreachiter1_target = this._beads;
  for (var foreachiter1 in foreachiter1_target) 
  {
  var bead = foreachiter1_target[foreachiter1];
  {
    if (org.apache.flex.utils.Language.is(bead, classOrInterface))
      return bead;
  }}
  
  return null;
};


/**
 *  @copy org.apache.flex.core.IStrand#removeBead()
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {org.apache.flex.core.IBead} value
 * @return {org.apache.flex.core.IBead}
 */
org.apache.flex.html.MXMLBeadView.prototype.removeBead = function(value) {
  var /** @type {number} */ n = this._beads.length;
  for (var /** @type {number} */ i = 0; i < n; i++) {
    var /** @type {org.apache.flex.core.IBead} */ bead = this._beads[i];
    if (bead == value) {
      this._beads.splice(i, 1);
      return bead;
    }
  }
  return null;
};


Object.defineProperties(org.apache.flex.html.MXMLBeadView.prototype, /** @lends {org.apache.flex.html.MXMLBeadView.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.MXMLBeadView} */ function(value) {
  org.apache.flex.utils.Language.superSetter(org.apache.flex.html.MXMLBeadView, this, 'strand', value);
  org.apache.flex.core.ValuesManager.valuesImpl.init(this);
  this.dispatchEvent(new org.apache.flex.events.Event("strandChanged"));
  var foreachiter2_target = this.beads;
  for (var foreachiter2 in foreachiter2_target) 
  {
  var bead = foreachiter2_target[foreachiter2];
  
    this.addBead(bead);}
  
  this.dispatchEvent(new org.apache.flex.events.Event("beadsAdded"));
  org.apache.flex.utils.MXMLDataInterpreter.generateMXMLInstances(this, org.apache.flex.utils.Language.as(value, org.apache.flex.core.IParent, true), this.MXMLDescriptor);
  this.dispatchEvent(new org.apache.flex.events.Event("initBindings"));
  this.dispatchEvent(new org.apache.flex.events.Event("initComplete"));
  this.dispatchEvent(new org.apache.flex.events.Event("childrenAdded"));
}},
/** @export */
model: {
get: /** @this {org.apache.flex.html.MXMLBeadView} */ function() {
  return this._strand["model"];
}},
/** @export */
MXMLDescriptor: {
get: /** @this {org.apache.flex.html.MXMLBeadView} */ function() {
  return null;
}},
/** @export */
states: {
get: /** @this {org.apache.flex.html.MXMLBeadView} */ function() {
  return this._states;
},
set: /** @this {org.apache.flex.html.MXMLBeadView} */ function(value) {
  this._states = value;
  this._currentState = org.apache.flex.utils.Language.string(this._states[0].name);
  try {
    if (this.getBeadByType(org.apache.flex.core.IStatesImpl) == null)
      this.addBead(org.apache.flex.utils.Language.as(new (org.apache.flex.core.ValuesManager.valuesImpl.getValue(this, "iStatesImpl"))(), org.apache.flex.core.IBead));
  } catch (e) {
    
  }
}},
/** @export */
currentState: {
get: /** @this {org.apache.flex.html.MXMLBeadView} */ function() {
  return this._currentState;
},
set: /** @this {org.apache.flex.html.MXMLBeadView} */ function(value) {
  var /** @type {org.apache.flex.events.ValueChangeEvent} */ event = new org.apache.flex.events.ValueChangeEvent("currentStateChange", false, false, this._currentState, value);
  this._currentState = value;
  this.dispatchEvent(event);
}},
/** @export */
transitions: {
get: /** @this {org.apache.flex.html.MXMLBeadView} */ function() {
  return this._transitions;
},
set: /** @this {org.apache.flex.html.MXMLBeadView} */ function(value) {
  this._transitions = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.MXMLBeadView.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'MXMLBeadView', qName: 'org.apache.flex.html.MXMLBeadView'}], interfaces: [org.apache.flex.core.IStrand, org.apache.flex.core.ILayoutHost] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.MXMLBeadView', org.apache.flex.html.MXMLBeadView);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.MXMLBeadView.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'mxmlContent': { type: 'Array'},
        'beads': { type: 'Array'}
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.MXMLBeadView', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'strandChanged'}]}]; }},
        'model': { type: 'Object', declaredBy: 'org.apache.flex.html.MXMLBeadView', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: '__NoChangeEvent__'}]}]; }},
        'MXMLDescriptor': { type: 'Array', declaredBy: 'org.apache.flex.html.MXMLBeadView'},
        'states': { type: 'Array', declaredBy: 'org.apache.flex.html.MXMLBeadView'},
        'currentState': { type: 'String', declaredBy: 'org.apache.flex.html.MXMLBeadView', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'currentStateChange'}]}]; }},
        'transitions': { type: 'Array', declaredBy: 'org.apache.flex.html.MXMLBeadView'}
      };
    },
    methods: function () {
      return {
        'MXMLBeadView': { type: '', declaredBy: 'org.apache.flex.html.MXMLBeadView'},
        'generateMXMLAttributes': { type: 'void', declaredBy: 'org.apache.flex.html.MXMLBeadView'},
        'hasState': { type: 'Boolean', declaredBy: 'org.apache.flex.html.MXMLBeadView'},
        'addBead': { type: 'void', declaredBy: 'org.apache.flex.html.MXMLBeadView'},
        'getBeadByType': { type: 'IBead', declaredBy: 'org.apache.flex.html.MXMLBeadView'},
        'removeBead': { type: 'IBead', declaredBy: 'org.apache.flex.html.MXMLBeadView'}
      };
    },
    metadata: function () { return [ ]; }
  };
};