/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/List.as
 * org.apache.flex.html.List
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.List');

goog.require('org.apache.flex.core.ListBase');
goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.html.beads.ListView');
goog.require('org.apache.flex.html.beads.models.ListPresentationModel');
goog.require('org.apache.flex.core.IDataProviderItemRendererMapper');
goog.require('org.apache.flex.core.IItemRendererClassFactory');
goog.require('org.apache.flex.core.IItemRendererProvider');
goog.require('org.apache.flex.core.IListPresentationModel');
goog.require('org.apache.flex.core.IRollOverModel');
goog.require('org.apache.flex.core.ISelectionModel');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.ListBase}
 * @implements {org.apache.flex.core.IItemRendererProvider}
 */
org.apache.flex.html.List = function() {
  org.apache.flex.html.List.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.List, org.apache.flex.core.ListBase);


/**
 * @private
 * @type {org.apache.flex.core.IFactory}
 */
org.apache.flex.html.List.prototype._itemRenderer;


/**
 * @asprivate
 * @export
 * @override
 */
org.apache.flex.html.List.prototype.addedToParent = function() {
  org.apache.flex.html.List.base(this, 'addedToParent');
  if (this.getBeadByType(org.apache.flex.core.IDataProviderItemRendererMapper) == null) {
    var /** @type {org.apache.flex.core.IDataProviderItemRendererMapper} */ mapper = org.apache.flex.utils.Language.as(new (org.apache.flex.core.ValuesManager.valuesImpl.getValue(this, "iDataProviderItemRendererMapper"))(), org.apache.flex.core.IDataProviderItemRendererMapper);
    this.addBead(mapper);
  }
  var /** @type {org.apache.flex.core.IItemRendererClassFactory} */ itemRendererFactory = org.apache.flex.utils.Language.as(this.getBeadByType(org.apache.flex.core.IItemRendererClassFactory), org.apache.flex.core.IItemRendererClassFactory);
  if (!itemRendererFactory) {
    itemRendererFactory = org.apache.flex.utils.Language.as(new (org.apache.flex.core.ValuesManager.valuesImpl.getValue(this, "iItemRendererClassFactory"))(), org.apache.flex.core.IItemRendererClassFactory);
    this.addBead(itemRendererFactory);
  }
  this.dispatchEvent(new org.apache.flex.events.Event("initComplete"));
};


/**
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @protected
 * @override
 */
org.apache.flex.html.List.prototype.createElement = function() {
  org.apache.flex.html.List.base(this, 'createElement');
  this.className = 'List';
  return this.element;
};


/**
 * @flexjsignorecoercion org.apache.flex.html.beads.ListView 
 * @flexjsignorecoercion org.apache.flex.html.supportClasses.DataGroup 
 * @export
 * @override
 */
org.apache.flex.html.List.prototype.internalChildren = function() {
  var /** @type {Object} */ listView = this.getBeadByType(org.apache.flex.html.beads.ListView);
  var /** @type {Object} */ dg = listView.dataGroup;
  var /** @type {Array} */ renderers = dg.internalChildren();
  return renderers;
};


Object.defineProperties(org.apache.flex.html.List.prototype, /** @lends {org.apache.flex.html.List.prototype} */ {
/** @export */
labelField: {
get: /** @this {org.apache.flex.html.List} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ISelectionModel, true).labelField;
},
set: /** @this {org.apache.flex.html.List} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ISelectionModel, true).labelField = value;
}},
/** @export */
dataProvider: {
get: /** @this {org.apache.flex.html.List} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ISelectionModel, true).dataProvider;
},
set: /** @this {org.apache.flex.html.List} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ISelectionModel, true).dataProvider = value;
}},
/** @export */
selectedIndex: {
get: /** @this {org.apache.flex.html.List} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ISelectionModel, true).selectedIndex;
},
set: /** @this {org.apache.flex.html.List} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ISelectionModel, true).selectedIndex = value;
}},
/** @export */
rollOverIndex: {
get: /** @this {org.apache.flex.html.List} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IRollOverModel, true).rollOverIndex;
},
set: /** @this {org.apache.flex.html.List} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IRollOverModel, true).rollOverIndex = value;
}},
/** @export */
presentationModel: {
get: /** @this {org.apache.flex.html.List} */ function() {
  var /** @type {org.apache.flex.core.IListPresentationModel} */ presModel = org.apache.flex.utils.Language.as(this.getBeadByType(org.apache.flex.core.IListPresentationModel), org.apache.flex.core.IListPresentationModel);
  if (presModel == null) {
    presModel = new org.apache.flex.html.beads.models.ListPresentationModel();
    this.addBead(presModel);
  }
  return presModel;
}},
/** @export */
rowHeight: {
get: /** @this {org.apache.flex.html.List} */ function() {
  return this.presentationModel.rowHeight;
},
set: /** @this {org.apache.flex.html.List} */ function(value) {
  this.presentationModel.rowHeight = value;
}},
/** @export */
selectedItem: {
get: /** @this {org.apache.flex.html.List} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ISelectionModel, true).selectedItem;
},
set: /** @this {org.apache.flex.html.List} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ISelectionModel, true).selectedItem = value;
}},
/** @export */
itemRenderer: {
get: /** @this {org.apache.flex.html.List} */ function() {
  return this._itemRenderer;
},
set: /** @this {org.apache.flex.html.List} */ function(value) {
  this._itemRenderer = value;
}},
/** @export */
hasItemRenderer: {
get: /** @this {org.apache.flex.html.List} */ function() {
  var /** @type {boolean} */ result = false;
  
  var /** @type {*} */ test = this._itemRenderer;
  result = this._itemRenderer !== null && test !== undefined;
  return result;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.List.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'List', qName: 'org.apache.flex.html.List'}], interfaces: [org.apache.flex.core.IItemRendererProvider] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.List', org.apache.flex.html.List);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.List.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'labelField': { type: 'String', declaredBy: 'org.apache.flex.html.List'},
        'dataProvider': { type: 'Object', declaredBy: 'org.apache.flex.html.List'},
        'selectedIndex': { type: 'int', declaredBy: 'org.apache.flex.html.List'},
        'rollOverIndex': { type: 'int', declaredBy: 'org.apache.flex.html.List'},
        'presentationModel': { type: 'IListPresentationModel', declaredBy: 'org.apache.flex.html.List'},
        'rowHeight': { type: 'Number', declaredBy: 'org.apache.flex.html.List'},
        'selectedItem': { type: 'Object', declaredBy: 'org.apache.flex.html.List'},
        'itemRenderer': { type: 'IFactory', declaredBy: 'org.apache.flex.html.List'},
        'hasItemRenderer': { type: 'Boolean', declaredBy: 'org.apache.flex.html.List'}
      };
    },
    methods: function () {
      return {
        'List': { type: '', declaredBy: 'org.apache.flex.html.List'},
        'addedToParent': { type: 'void', declaredBy: 'org.apache.flex.html.List'},
        'internalChildren': { type: 'Array', declaredBy: 'org.apache.flex.html.List'}
      };
    },
    metadata: function () { return [ ]; }
  };
};