/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/DataGrid.as
 * org.apache.flex.html.DataGrid
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.DataGrid');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.html.beads.models.DataGridPresentationModel');
goog.require('org.apache.flex.core.IDataGridModel');
goog.require('org.apache.flex.core.IDataGridPresentationModel');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.UIBase}
 */
org.apache.flex.html.DataGrid = function() {
  org.apache.flex.html.DataGrid.base(this, 'constructor');
  this.className = "DataGrid";
};
goog.inherits(org.apache.flex.html.DataGrid, org.apache.flex.core.UIBase);


/**
 * @asprivate
 * The DataGrid needs to know whenever its size is being changed so the columns can be
 * be aligned properly, so the noEvent value must always be false.
 * @export
 * @override
 */
org.apache.flex.html.DataGrid.prototype.setWidth = function(value, noEvent) {
  noEvent = typeof noEvent !== 'undefined' ? noEvent : false;
  org.apache.flex.html.DataGrid.base(this, 'setWidth', value, false);
};


/**
 * @asprivate
 * The DataGrid needs to know whenever its size is being changed so the columns can be
 * be aligned properly, so the noEvent value must always be false.
 * @export
 * @override
 */
org.apache.flex.html.DataGrid.prototype.setHeight = function(value, noEvent) {
  noEvent = typeof noEvent !== 'undefined' ? noEvent : false;
  org.apache.flex.html.DataGrid.base(this, 'setHeight', value, false);
};


Object.defineProperties(org.apache.flex.html.DataGrid.prototype, /** @lends {org.apache.flex.html.DataGrid.prototype} */ {
/** @export */
columns: {
get: /** @this {org.apache.flex.html.DataGrid} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IDataGridModel, true).columns;
},
set: /** @this {org.apache.flex.html.DataGrid} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IDataGridModel, true).columns = value;
}},
/** @export */
dataProvider: {
get: /** @this {org.apache.flex.html.DataGrid} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IDataGridModel, true).dataProvider;
},
set: /** @this {org.apache.flex.html.DataGrid} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IDataGridModel, true).dataProvider = value;
}},
/** @export */
selectedIndex: {
get: /** @this {org.apache.flex.html.DataGrid} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IDataGridModel, true).selectedIndex;
}},
/** @export */
presentationModel: {
get: /** @this {org.apache.flex.html.DataGrid} */ function() {
  var /** @type {org.apache.flex.core.IBead} */ beadMod = this.getBeadByType(org.apache.flex.core.IDataGridPresentationModel);
  var /** @type {org.apache.flex.core.IDataGridPresentationModel} */ presModel;
  if (beadMod == null) {
    presModel = new org.apache.flex.html.beads.models.DataGridPresentationModel();
    this.addBead(presModel);
  } else {
    presModel = org.apache.flex.utils.Language.as(beadMod, org.apache.flex.core.IDataGridPresentationModel);
  }
  return presModel;
}},
/** @export */
rowHeight: {
get: /** @this {org.apache.flex.html.DataGrid} */ function() {
  return this.presentationModel.rowHeight;
},
set: /** @this {org.apache.flex.html.DataGrid} */ function(value) {
  this.presentationModel.rowHeight = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.DataGrid.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'DataGrid', qName: 'org.apache.flex.html.DataGrid'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.DataGrid', org.apache.flex.html.DataGrid);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.DataGrid.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'columns': { type: 'Array', declaredBy: 'org.apache.flex.html.DataGrid'},
        'dataProvider': { type: 'Object', declaredBy: 'org.apache.flex.html.DataGrid'},
        'selectedIndex': { type: 'int', declaredBy: 'org.apache.flex.html.DataGrid'},
        'presentationModel': { type: 'IDataGridPresentationModel', declaredBy: 'org.apache.flex.html.DataGrid'},
        'rowHeight': { type: 'Number', declaredBy: 'org.apache.flex.html.DataGrid'}
      };
    },
    methods: function () {
      return {
        'DataGrid': { type: '', declaredBy: 'org.apache.flex.html.DataGrid'},
        'setWidth': { type: 'void', declaredBy: 'org.apache.flex.html.DataGrid'},
        'setHeight': { type: 'void', declaredBy: 'org.apache.flex.html.DataGrid'}
      };
    },
    metadata: function () { return [ ]; }
  };
};