/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/events/MouseEvent.as
 * org.apache.flex.events.MouseEvent
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.events.MouseEvent');

goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.geom.Point');
goog.require('org.apache.flex.utils.PointUtils');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *
 *  @asparam type The name of the event.
 *  @asparam bubbles Whether the event bubbles.
 *  @asparam cancelable Whether the event can be canceled.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.events.Event}
 * @param {string} type
 * @param {boolean=} bubbles
 * @param {boolean=} cancelable
 * @param {number=} localX
 * @param {number=} localY
 * @param {Object=} relatedObject
 * @param {boolean=} ctrlKey
 * @param {boolean=} altKey
 * @param {boolean=} shiftKey
 * @param {boolean=} buttonDown
 * @param {number=} delta
 * @param {boolean=} commandKey
 * @param {boolean=} controlKey
 * @param {number=} clickCount
 */
org.apache.flex.events.MouseEvent = function(type, bubbles, cancelable, localX, localY, relatedObject, ctrlKey, altKey, shiftKey, buttonDown, delta, commandKey, controlKey, clickCount) {
  bubbles = typeof bubbles !== 'undefined' ? bubbles : false;
  cancelable = typeof cancelable !== 'undefined' ? cancelable : false;
  localX = typeof localX !== 'undefined' ? localX : NaN;
  localY = typeof localY !== 'undefined' ? localY : NaN;
  relatedObject = typeof relatedObject !== 'undefined' ? relatedObject : null;
  ctrlKey = typeof ctrlKey !== 'undefined' ? ctrlKey : false;
  altKey = typeof altKey !== 'undefined' ? altKey : false;
  shiftKey = typeof shiftKey !== 'undefined' ? shiftKey : false;
  buttonDown = typeof buttonDown !== 'undefined' ? buttonDown : false;
  delta = typeof delta !== 'undefined' ? delta : 0;
  commandKey = typeof commandKey !== 'undefined' ? commandKey : false;
  controlKey = typeof controlKey !== 'undefined' ? controlKey : false;
  clickCount = typeof clickCount !== 'undefined' ? clickCount : 0;
  org.apache.flex.events.MouseEvent.base(this, 'constructor', type, bubbles, cancelable);
  this.localX = localX;
  this.localY = localY;
  this.relatedObject = relatedObject;
  this.ctrlKey = ctrlKey;
  this.altKey = altKey;
  this.shiftKey = shiftKey;
  this.buttonDown = buttonDown;
  this.delta = delta;
  this.commandKey = commandKey;
  this.controlKey = controlKey;
  this.clickCount = clickCount;
};
goog.inherits(org.apache.flex.events.MouseEvent, org.apache.flex.events.Event);


/**
 * @private
 * @param {string} s
 * @return {string}
 */
org.apache.flex.events.MouseEvent.platformConstant = function(s) {
  return s.toLowerCase();
};


/**
 * @export
 * @const
 * @type {string}
 */
org.apache.flex.events.MouseEvent.MOUSE_DOWN = org.apache.flex.events.MouseEvent.platformConstant("mouseDown");


/**
 * @export
 * @const
 * @type {string}
 */
org.apache.flex.events.MouseEvent.MOUSE_MOVE = org.apache.flex.events.MouseEvent.platformConstant("mouseMove");


/**
 * @export
 * @const
 * @type {string}
 */
org.apache.flex.events.MouseEvent.MOUSE_UP = org.apache.flex.events.MouseEvent.platformConstant("mouseUp");


/**
 * @export
 * @const
 * @type {string}
 */
org.apache.flex.events.MouseEvent.MOUSE_OUT = org.apache.flex.events.MouseEvent.platformConstant("mouseOut");


/**
 * @export
 * @const
 * @type {string}
 */
org.apache.flex.events.MouseEvent.MOUSE_OVER = org.apache.flex.events.MouseEvent.platformConstant("mouseOver");


/**
 * @export
 * @const
 * @type {string}
 */
org.apache.flex.events.MouseEvent.ROLL_OVER = org.apache.flex.events.MouseEvent.platformConstant("rollOver");


/**
 * @export
 * @const
 * @type {string}
 */
org.apache.flex.events.MouseEvent.ROLL_OUT = org.apache.flex.events.MouseEvent.platformConstant("rollOut");


/**
 * @export
 * @const
 * @type {string}
 */
org.apache.flex.events.MouseEvent.CLICK = "click";


/**
 * @export
 * @const
 * @type {string}
 */
org.apache.flex.events.MouseEvent.DOUBLE_CLICK = "dblclick";


/**
 * @private
 * @type {number}
 */
org.apache.flex.events.MouseEvent.prototype._localX;


/**
 * @private
 * @type {number}
 */
org.apache.flex.events.MouseEvent.prototype._localY;


/**
 * @export
 * @type {Object}
 */
org.apache.flex.events.MouseEvent.prototype.relatedObject;


/**
 * @export
 * @type {boolean}
 */
org.apache.flex.events.MouseEvent.prototype.ctrlKey;


/**
 * @export
 * @type {boolean}
 */
org.apache.flex.events.MouseEvent.prototype.altKey;


/**
 * @export
 * @type {boolean}
 */
org.apache.flex.events.MouseEvent.prototype.shiftKey;


/**
 * @export
 * @type {boolean}
 */
org.apache.flex.events.MouseEvent.prototype.buttonDown;


/**
 * @export
 * @type {number}
 */
org.apache.flex.events.MouseEvent.prototype.delta;


/**
 * @export
 * @type {boolean}
 */
org.apache.flex.events.MouseEvent.prototype.commandKey;


/**
 * @export
 * @type {boolean}
 */
org.apache.flex.events.MouseEvent.prototype.controlKey;


/**
 * @export
 * @type {number}
 */
org.apache.flex.events.MouseEvent.prototype.clickCount;


/**
 * @private
 * @type {org.apache.flex.geom.Point}
 */
org.apache.flex.events.MouseEvent.prototype._stagePoint;


/**
 * @asprivate
 * @private
 * @return {boolean}
 */
org.apache.flex.events.MouseEvent.installRollOverMixin = function() {
  window.addEventListener(org.apache.flex.events.MouseEvent.MOUSE_OVER, org.apache.flex.events.MouseEvent.mouseOverHandler, false);
  return true;
};


/**
 * @asparam e The event.
 * RollOver/RollOut is entirely implemented in mouseOver because
 * when a parent and child share an edge, you only get a mouseout
 * for the child and not the parent and you need to send rollout
 * to both.  A similar issue exists for rollover.
 * @private
 * @param {org.apache.flex.events.MouseEvent} e
 */
org.apache.flex.events.MouseEvent.mouseOverHandler = function(e) {
  var /** @type {number} */ j;
  var /** @type {number} */ m;
  var /** @type {Array} */ outs;
  var /** @type {MouseEvent} */ me;
  var /** @type {Object} */ parent;
  var /** @type {Object} */ target = e.target.flexjs_wrapper;
  if (target == null)
    return;
  var /** @type {Array} */ targets = org.apache.flex.events.MouseEvent.targets;
  var /** @type {number} */ index = targets.indexOf(target);
  if (index != -1) {
    outs = targets.slice(index + 1);
    m = outs.length;
    for (j = 0; j < m; j++) {
      me = org.apache.flex.events.MouseEvent.makeMouseEvent(org.apache.flex.events.MouseEvent.ROLL_OUT, e);
      outs[j].element.dispatchEvent(me);
    }
    org.apache.flex.events.MouseEvent.targets = targets.slice(0, index + 1);
  } else {
    var /** @type {Array} */ newTargets = [target];
    if (!('parent' in target))
      parent = null;
    else
      parent = target.parent;
    while (parent) {
      index = targets.indexOf(parent);
      if (index == -1) {
        newTargets.unshift(parent);
        if (!('parent' in parent))
          break;
        parent = parent.parent;
      } else {
        outs = targets.slice(index + 1);
        m = outs.length;
        for (j = 0; j < m; j++) {
          me = org.apache.flex.events.MouseEvent.makeMouseEvent(org.apache.flex.events.MouseEvent.ROLL_OUT, e);
          outs[j].element.dispatchEvent(me);
        }
        targets = targets.slice(0, index + 1);
        break;
      }
    }
    var /** @type {number} */ n = newTargets.length;
    for (var /** @type {number} */ i = 0; i < n; i++) {
      me = org.apache.flex.events.MouseEvent.makeMouseEvent(org.apache.flex.events.MouseEvent.ROLL_OVER, e);
      newTargets[i].element.dispatchEvent(me);
    }
    org.apache.flex.events.MouseEvent.targets = targets.concat(newTargets);
  }
};


/**
 * @private
 * @type {boolean}
 */
org.apache.flex.events.MouseEvent.rollOverMixin = org.apache.flex.events.MouseEvent.installRollOverMixin();


/**
 * @private
 * @type {Array}
 */
org.apache.flex.events.MouseEvent.targets = [];


/**
 * @asparam {string} type The event type.
 * @asparam {Event} e The mouse event.
 * @asreturn {MouseEvent} The new event.
 * @private
 * @param {string} type
 * @return {MouseEvent}
 */
org.apache.flex.events.MouseEvent.makeMouseEvent = function(type, e) {
  var /** @type {MouseEvent} */ out = new MouseEvent(type);
  out.initMouseEvent(type, false, false, e.view, e.detail, e.screenX, e.screenY, e.clientX, e.clientY, e.ctrlKey, e.altKey, e.shiftKey, e.metaKey, e.button, e.relatedTarget);
  return out;
};


Object.defineProperties(org.apache.flex.events.MouseEvent.prototype, /** @lends {org.apache.flex.events.MouseEvent.prototype} */ {
/** @export */
localX: {
get: /** @this {org.apache.flex.events.MouseEvent} */ function() {
  return this._localX;
},
set: /** @this {org.apache.flex.events.MouseEvent} */ function(value) {
  this._localX = value;
  this._stagePoint = null;
}},
/** @export */
localY: {
get: /** @this {org.apache.flex.events.MouseEvent} */ function() {
  return this._localY;
},
set: /** @this {org.apache.flex.events.MouseEvent} */ function(value) {
  this._localY = value;
  this._stagePoint = null;
}},
/** @export */
clientX: {
get: /** @this {org.apache.flex.events.MouseEvent} */ function() {
  return this.screenX;
},
set: /** @this {org.apache.flex.events.MouseEvent} */ function(value) {
  this.localX = value;
}},
/** @export */
clientY: {
get: /** @this {org.apache.flex.events.MouseEvent} */ function() {
  return this.screenY;
},
set: /** @this {org.apache.flex.events.MouseEvent} */ function(value) {
  this.localY = value;
}},
/** @export */
screenX: {
get: /** @this {org.apache.flex.events.MouseEvent} */ function() {
  if (!this.target)
    return this.localX;
  if (!this._stagePoint) {
    var /** @type {org.apache.flex.geom.Point} */ localPoint = new org.apache.flex.geom.Point(this.localX, this.localY);
    this._stagePoint = org.apache.flex.utils.PointUtils.localToGlobal(localPoint, this.target);
  }
  return this._stagePoint.x;
}},
/** @export */
screenY: {
get: /** @this {org.apache.flex.events.MouseEvent} */ function() {
  if (!this.target)
    return this.localY;
  if (!this._stagePoint) {
    var /** @type {org.apache.flex.geom.Point} */ localPoint = new org.apache.flex.geom.Point(this.localX, this.localY);
    this._stagePoint = org.apache.flex.utils.PointUtils.localToGlobal(localPoint, this.target);
  }
  return this._stagePoint.y;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.events.MouseEvent.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'MouseEvent', qName: 'org.apache.flex.events.MouseEvent'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.events.MouseEvent', org.apache.flex.events.MouseEvent);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.events.MouseEvent.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'relatedObject': { type: 'Object'},
        'ctrlKey': { type: 'Boolean'},
        'altKey': { type: 'Boolean'},
        'shiftKey': { type: 'Boolean'},
        'buttonDown': { type: 'Boolean'},
        'delta': { type: 'int'},
        'commandKey': { type: 'Boolean'},
        'controlKey': { type: 'Boolean'},
        'clickCount': { type: 'int'}
      };
    },
    accessors: function () {
      return {
        'localX': { type: 'Number', declaredBy: 'org.apache.flex.events.MouseEvent'},
        'localY': { type: 'Number', declaredBy: 'org.apache.flex.events.MouseEvent'},
        'clientX': { type: 'Number', declaredBy: 'org.apache.flex.events.MouseEvent'},
        'clientY': { type: 'Number', declaredBy: 'org.apache.flex.events.MouseEvent'},
        'screenX': { type: 'Number', declaredBy: 'org.apache.flex.events.MouseEvent'},
        'screenY': { type: 'Number', declaredBy: 'org.apache.flex.events.MouseEvent'}
      };
    },
    methods: function () {
      return {
        'MouseEvent': { type: '', declaredBy: 'org.apache.flex.events.MouseEvent'}
      };
    }
  };
};