/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/events/EventDispatcher.as
 * org.apache.flex.events.EventDispatcher
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.events.EventDispatcher');

goog.require('goog.events');
goog.require('goog.events.EventTarget');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @extends {goog.events.EventTarget}
 * @implements {org.apache.flex.events.IEventDispatcher}
 * @param {org.apache.flex.events.IEventDispatcher=} target
 */
org.apache.flex.events.EventDispatcher = function(target) {
  org.apache.flex.events.EventDispatcher.base(this, 'constructor');
  target = typeof target !== 'undefined' ? target : null;
  if (target != null)
    this.setTargetForTesting(target);
};
goog.inherits(org.apache.flex.events.EventDispatcher, goog.events.EventTarget);


/**
 * @export
 * @param {string} type
 * @return {boolean}
 */
org.apache.flex.events.EventDispatcher.prototype.hasEventListener = function(type) {
  return goog.events.hasListener(this, type);
};


/**
 * @export
 * @override
 */
org.apache.flex.events.EventDispatcher.prototype.dispatchEvent = function(event) {
  try {
    return org.apache.flex.events.EventDispatcher.base(this, 'dispatchEvent', event);
  } catch (e) {
    if (e.name != "stopImmediatePropagation")
      throw e;
  }
  return false;
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.events.EventDispatcher.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'EventDispatcher', qName: 'org.apache.flex.events.EventDispatcher'}], interfaces: [org.apache.flex.events.IEventDispatcher] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.events.EventDispatcher', org.apache.flex.events.EventDispatcher);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.events.EventDispatcher.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'EventDispatcher': { type: '', declaredBy: 'org.apache.flex.events.EventDispatcher'},
        'hasEventListener': { type: 'Boolean', declaredBy: 'org.apache.flex.events.EventDispatcher'},
        'dispatchEvent': { type: 'Boolean', declaredBy: 'org.apache.flex.events.EventDispatcher'}
      };
    }
  };
};