/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/events/DragEvent.as
 * org.apache.flex.events.DragEvent
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.events.DragEvent');

goog.require('org.apache.flex.events.DragEventBase');
goog.require('org.apache.flex.events.ElementEvents');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.  Do not call 'new DragEvent', use the
 *  createDragEvent method instead.
 *  
 *  @asparam type The name of the event.
 *  @asparam bubbles Whether the event bubbles.
 *  @asparam cancelable Whether the event can be canceled.
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.events.DragEventBase}
 * @param {string} type
 * @param {boolean=} bubbles
 * @param {boolean=} cancelable
 */
org.apache.flex.events.DragEvent = function(type, bubbles, cancelable) {
  org.apache.flex.events.DragEvent.base(this, 'constructor');
  bubbles = typeof bubbles !== 'undefined' ? bubbles : false;
  cancelable = typeof cancelable !== 'undefined' ? cancelable : false;
  
  this.type = type;
};
goog.inherits(org.apache.flex.events.DragEvent, org.apache.flex.events.DragEventBase);


/**
 * @export
 * @const
 * @type {string}
 */
org.apache.flex.events.DragEvent.DRAG_START = "dragStart";


/**
 * @export
 * @const
 * @type {string}
 */
org.apache.flex.events.DragEvent.DRAG_MOVE = "dragMove";


/**
 * @export
 * @const
 * @type {string}
 */
org.apache.flex.events.DragEvent.DRAG_END = "dragEnd";


/**
 * @export
 * @const
 * @type {string}
 */
org.apache.flex.events.DragEvent.DRAG_ENTER = "dragEnter";


/**
 * @export
 * @const
 * @type {string}
 */
org.apache.flex.events.DragEvent.DRAG_OVER = "dragOver";


/**
 * @export
 * @const
 * @type {string}
 */
org.apache.flex.events.DragEvent.DRAG_EXIT = "dragExit";


/**
 * @export
 * @const
 * @type {string}
 */
org.apache.flex.events.DragEvent.DRAG_DROP = "dragDrop";


/**
 * @export
 * @type {org.apache.flex.core.IDragInitiator}
 */
org.apache.flex.events.DragEvent.dragInitiator;


/**
 * @export
 * @type {Object}
 */
org.apache.flex.events.DragEvent.dragSource;


/**
 *  Factory for DragEvents.
 *  
 *  @asparam type The name of the event.
 *  @asparam event The MouseEvent properties to copy into the DragEvent.
 *  @asreturn The new DragEvent.
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion org.apache.flex.events.DragEvent
 *  @flexjsignorecoercion window.Event
 *  @flexjsignorecoercion Event
 * @export
 * @param {string} type
 * @param {org.apache.flex.events.MouseEvent} event
 * @return {Object}
 */
org.apache.flex.events.DragEvent.createDragEvent = function(type, event) {
  
  var /** @type {MouseEvent} */ out = new MouseEvent(type);
  var /** @type {Event} */ e = event;
  out.initMouseEvent(type, true, true, e.view, e.detail, e.screenX, e.screenY, e.clientX, e.clientY, e.ctrlKey, e.altKey, e.shiftKey, e.metaKey, e.button, e.relatedTarget);
  return out;
};


/**
 *  Dispatch a DragEvent
 *  
 *  @asparam event The DragEvent to dispatch.
 *  @asparam target The target to dispatch the event from.
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion org.apache.flex.core.IUIBase
 *  @flexjsignorecoercion window.Event
 * @export
 * @param {org.apache.flex.events.DragEvent} event
 * @param {org.apache.flex.events.IEventDispatcher} target
 */
org.apache.flex.events.DragEvent.dispatchDragEvent = function(event, target) {
  
  target.element.dispatchEvent(org.apache.flex.utils.Language.as(event, Event));
};


/**
 * @private
 * @return {boolean}
 */
org.apache.flex.events.DragEvent.installDragEventMixin = function() {
  var /** @type {Object} */ o = org.apache.flex.events.ElementEvents.elementEvents;
  o['dragEnd'] = 1;
  o['dragMove'] = 1;
  return true;
};


/**
 * @private
 * @type {boolean}
 */
org.apache.flex.events.DragEvent.dragEventMixin = org.apache.flex.events.DragEvent.installDragEventMixin();


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.events.DragEvent.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'DragEvent', qName: 'org.apache.flex.events.DragEvent'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.events.DragEvent', org.apache.flex.events.DragEvent);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.events.DragEvent.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'DragEvent': { type: '', declaredBy: 'org.apache.flex.events.DragEvent'}
      };
    }
  };
};