/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/createjs/core/UIBase.as
 * org.apache.flex.createjs.core.UIBase
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.createjs.core.UIBase');

goog.require('org.apache.flex.core.HTMLElementWrapper');
goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.utils.CSSUtils');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.IBeadController');
goog.require('org.apache.flex.core.IBeadModel');
goog.require('org.apache.flex.core.IBeadView');
goog.require('org.apache.flex.core.IFlexJSElement');
goog.require('org.apache.flex.core.IStrandWithModel');
goog.require('org.apache.flex.core.IUIBase');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion Class
 * @constructor
 * @extends {org.apache.flex.core.HTMLElementWrapper}
 * @implements {org.apache.flex.core.IStrandWithModel}
 * @implements {org.apache.flex.events.IEventDispatcher}
 * @implements {org.apache.flex.core.IUIBase}
 * @implements {org.apache.flex.core.IFlexJSElement}
 */
org.apache.flex.createjs.core.UIBase = function() {
  org.apache.flex.createjs.core.UIBase.base(this, 'constructor');
  this.createElement();
};
goog.inherits(org.apache.flex.createjs.core.UIBase, org.apache.flex.core.HTMLElementWrapper);


/**
 * @private
 * @type {org.apache.flex.core.IBeadView}
 */
org.apache.flex.createjs.core.UIBase.prototype._view;


/**
 * @private
 * @type {string}
 */
org.apache.flex.createjs.core.UIBase.prototype._id;


/**
 * @private
 * @type {Object}
 */
org.apache.flex.createjs.core.UIBase.prototype._style;


/**
 * @private
 * @type {string}
 */
org.apache.flex.createjs.core.UIBase.prototype._className;


/**
 * @export
 * @type {Array}
 */
org.apache.flex.createjs.core.UIBase.prototype.beads;


/**
 *  The method called when added to a parent.  This is a good
 *  time to set up beads.
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion Class
 *  @flexjsignorecoercion Number
 * @export
 */
org.apache.flex.createjs.core.UIBase.prototype.addedToParent = function() {
  var /** @type {Object} */ c;
  if (this.style)
    org.apache.flex.core.ValuesManager.valuesImpl.applyStyles(this, this.style);
  if (isNaN(this._explicitWidth) && isNaN(this._percentWidth)) {
    var /** @type {*} */ value = org.apache.flex.core.ValuesManager.valuesImpl.getValue(this, "width");
    if (value !== undefined) {
      if (org.apache.flex.utils.Language.is(value, String)) {
        var /** @type {string} */ s = String(value);
        if (s.indexOf("%") != -1)
          this._percentWidth = Number(s.substring(0, s.length - 1)); else {
          if (s.indexOf("px") != -1)
            s = s.substring(0, s.length - 2);
          this._width = this._explicitWidth = Number(s);
        }
      }
      else
        this._width = this._explicitWidth = value;
    }
  }
  if (isNaN(this._explicitHeight) && isNaN(this._percentHeight)) {
    value = org.apache.flex.core.ValuesManager.valuesImpl.getValue(this, "height");
    if (value !== undefined) {
      if (org.apache.flex.utils.Language.is(value, String)) {
        s = String(value);
        if (s.indexOf("%") != -1)
          this._percentHeight = Number(s.substring(0, s.length - 1)); else {
          if (s.indexOf("px") != -1)
            s = s.substring(0, s.length - 2);
          this._height = this._explicitHeight = Number(s);
        }
      }
      else
        this._height = this._explicitHeight = value;
    }
  }
  var foreachiter0_target = this.beads;
  for (var foreachiter0 in foreachiter0_target) 
  {
  var bead = foreachiter0_target[foreachiter0];
  
    this.addBead(bead);}
  
  if (this.getBeadByType(org.apache.flex.core.IBeadModel) == null) {
    c = org.apache.flex.core.ValuesManager.valuesImpl.getValue(this, "iBeadModel");
    if (c) {
      var /** @type {org.apache.flex.core.IBeadModel} */ model = org.apache.flex.utils.Language.as(new c(), org.apache.flex.core.IBeadModel);
      if (model)
        this.addBead(model);
    }
  }
  if (this._view == null && this.getBeadByType(org.apache.flex.core.IBeadView) == null) {
    c = org.apache.flex.core.ValuesManager.valuesImpl.getValue(this, "iBeadView");
    if (c) {
      var /** @type {org.apache.flex.core.IBeadView} */ view = org.apache.flex.utils.Language.as(new c(), org.apache.flex.core.IBeadView);
      if (view)
        this.addBead(view);
    }
  }
  if (this.getBeadByType(org.apache.flex.core.IBeadController) == null) {
    c = org.apache.flex.core.ValuesManager.valuesImpl.getValue(this, "iBeadController");
    if (c) {
      var /** @type {org.apache.flex.core.IBeadController} */ controller = org.apache.flex.utils.Language.as(new c(), org.apache.flex.core.IBeadController);
      if (controller)
        this.addBead(controller);
    }
  }
  this.dispatchEvent(new org.apache.flex.events.Event("beadsAdded"));
};


/**
 * @flexjsignorecoercion createjs.Container
 * @flexjsignorecoercion createjs.DisplayObject
 * @export
 * @param {Object} c
 * @param {boolean=} dispatchEvent
 */
org.apache.flex.createjs.core.UIBase.prototype.addElement = function(c, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  this.element.addChild(c.element);
};


/**
 * @flexjsignorecoercion createjs.Container
 * @flexjsignorecoercion createjs.DisplayObject
 * @export
 * @param {Object} c
 * @param {number} index
 * @param {boolean=} dispatchEvent
 */
org.apache.flex.createjs.core.UIBase.prototype.addElementAt = function(c, index, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  this.element.addChildAt(c.element, index);
};


/**
 * @flexjsignorecoercion createjs.Container
 * @flexjsignorecoercion createjs.DisplayObject
 * @export
 * @param {Object} c
 * @return {number}
 */
org.apache.flex.createjs.core.UIBase.prototype.getElementIndex = function(c) {
  return this.element.getChildIndex(c.element);
};


/**
 * @flexjsignorecoercion createjs.Container
 * @flexjsignorecoercion createjs.DisplayObject
 * @export
 * @param {Object} c
 * @param {boolean=} dispatchEvent
 */
org.apache.flex.createjs.core.UIBase.prototype.removeElement = function(c, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  this.element.removeChild(c.element);
};


/**
 * @flexjsignorecoercion createjs.Container
 * @flexjsignorecoercion createjs.DisplayObject
 * @export
 * @param {number} index
 * @return {Object}
 */
org.apache.flex.createjs.core.UIBase.prototype.getElementAt = function(index) {
  return this.element.getChildAt(index);
};


/**
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @flexjsignorecoercion createjs.Container
 * @protected
 * @return {Object}
 */
org.apache.flex.createjs.core.UIBase.prototype.createElement = function() {
  this.element = new createjs.Container();
  this.element.flexjs_wrapper = this;
  this.positioner = this.element;
  return this.element;
};


/**
 * @private
 * @type {number}
 */
org.apache.flex.createjs.core.UIBase.prototype._explicitWidth;


/**
 * @private
 * @type {number}
 */
org.apache.flex.createjs.core.UIBase.prototype._explicitHeight;


/**
 * @private
 * @type {number}
 */
org.apache.flex.createjs.core.UIBase.prototype._percentWidth;


/**
 * @private
 * @type {number}
 */
org.apache.flex.createjs.core.UIBase.prototype._percentHeight;


/**
 * @private
 * @type {number}
 */
org.apache.flex.createjs.core.UIBase.prototype._x;


/**
 * @private
 * @type {number}
 */
org.apache.flex.createjs.core.UIBase.prototype._y;


/**
 * @private
 * @type {number}
 */
org.apache.flex.createjs.core.UIBase.prototype._width;


/**
 * @private
 * @type {number}
 */
org.apache.flex.createjs.core.UIBase.prototype._height;


/**
 * @private
 * @type {Object}
 */
org.apache.flex.createjs.core.UIBase.prototype._positioner;


/**
 * @protected
 * @param {number} value
 * @param {number=} alpha
 * @return {string}
 */
org.apache.flex.createjs.core.UIBase.prototype.convertColorToString = function(value, alpha) {
  alpha = typeof alpha !== 'undefined' ? alpha : 1.0;
  if (alpha < 1) {
    return org.apache.flex.utils.CSSUtils.attributeFromColor(value);
  }
  return org.apache.flex.utils.CSSUtils.attributeFromColor(value);
};


Object.defineProperties(org.apache.flex.createjs.core.UIBase.prototype, /** @lends {org.apache.flex.createjs.core.UIBase.prototype} */ {
/** @export */
view: {
get: /** @this {org.apache.flex.createjs.core.UIBase} */ function() {
  if (this._view == null) {
    var /** @type {Object} */ c = org.apache.flex.core.ValuesManager.valuesImpl.getValue(this, "iBeadView");
    if (c) {
      if (c) {
        this._view = org.apache.flex.utils.Language.as(new c(), org.apache.flex.core.IBeadView);
        this.addBead(this._view);
      }
    }
  }
  return this._view;
},
set: /** @this {org.apache.flex.createjs.core.UIBase} */ function(value) {
  if (this._view != value) {
    this.addBead(org.apache.flex.utils.Language.as(value, org.apache.flex.core.IBead));
    this.dispatchEvent(new org.apache.flex.events.Event("viewChanged"));
  }
}},
/** @export */
id: {
get: /** @this {org.apache.flex.createjs.core.UIBase} */ function() {
  return this._id;
},
set: /** @this {org.apache.flex.createjs.core.UIBase} */ function(value) {
  if (this._id != value) {
    this._id = value;
    this.dispatchEvent(new org.apache.flex.events.Event("idChanged"));
  }
}},
/** @export */
style: {
get: /** @this {org.apache.flex.createjs.core.UIBase} */ function() {
  return this._style;
},
set: /** @this {org.apache.flex.createjs.core.UIBase} */ function(value) {
  if (this._style != value) {
    if (org.apache.flex.utils.Language.is(value, String)) {
      this._style = org.apache.flex.core.ValuesManager.valuesImpl.parseStyles(value);
    }
    else
      this._style = value;
    this.dispatchEvent(new org.apache.flex.events.Event("stylesChanged"));
  }
}},
/** @export */
className: {
get: /** @this {org.apache.flex.createjs.core.UIBase} */ function() {
  return this._className;
},
set: /** @this {org.apache.flex.createjs.core.UIBase} */ function(value) {
  if (this._className != value) {
    this._className = value;
    this.dispatchEvent(new org.apache.flex.events.Event("classNameChanged"));
  }
}},
/** @export */
topMostEventDispatcher: {
get: /** @this {org.apache.flex.createjs.core.UIBase} */ function() {
  var /** @type {org.apache.flex.core.WrappedHTMLElement} */ e = document.body;
  return e.flexjs_wrapper;
}},
/** @export */
numElements: {
get: /** @this {org.apache.flex.createjs.core.UIBase} */ function() {
  return this.element.numChildren;
}},
/** @export */
explicitWidth: {
get: /** @this {org.apache.flex.createjs.core.UIBase} */ function() {
  return this._explicitWidth;
},
set: /** @this {org.apache.flex.createjs.core.UIBase} */ function(value) {
  if (this._explicitWidth == value)
    return;
  if (!isNaN(value))
    this._percentWidth = NaN;
  this._explicitWidth = value;
  this.dispatchEvent(new org.apache.flex.events.Event("explicitWidthChanged"));
}},
/** @export */
explicitHeight: {
get: /** @this {org.apache.flex.createjs.core.UIBase} */ function() {
  return this._explicitHeight;
},
set: /** @this {org.apache.flex.createjs.core.UIBase} */ function(value) {
  if (this._explicitHeight == value)
    return;
  if (!isNaN(value))
    this._percentHeight = NaN;
  this._explicitHeight = value;
  this.dispatchEvent(new org.apache.flex.events.Event("explicitHeightChanged"));
}},
/** @export */
percentWidth: {
get: /** @this {org.apache.flex.createjs.core.UIBase} */ function() {
  return this._percentWidth;
},
set: /** @this {org.apache.flex.createjs.core.UIBase} */ function(value) {
  this._percentWidth = value;
  if (!isNaN(value))
    this._explicitWidth = NaN;
  this.dispatchEvent(new org.apache.flex.events.Event("percentWidthChanged"));
}},
/** @export */
percentHeight: {
get: /** @this {org.apache.flex.createjs.core.UIBase} */ function() {
  return this._percentHeight;
},
set: /** @this {org.apache.flex.createjs.core.UIBase} */ function(value) {
  this._percentHeight = value;
  if (!isNaN(value))
    this._explicitHeight = NaN;
  this.dispatchEvent(new org.apache.flex.events.Event("percentHeightChanged"));
}},
/** @export */
x: {
get: /** @this {org.apache.flex.createjs.core.UIBase} */ function() {
  return this._x;
},
set: /** @this {org.apache.flex.createjs.core.UIBase} */ function(value) {
  var /** @type {createjs.DisplayObject} */ container = org.apache.flex.utils.Language.as(this.positioner, createjs.DisplayObject);
  container.x = value;
  this._x = value;
  var /** @type {createjs.Stage} */ stage = container.getStage();
  if (stage)
    stage.update();
}},
/** @export */
y: {
get: /** @this {org.apache.flex.createjs.core.UIBase} */ function() {
  return this._y;
},
set: /** @this {org.apache.flex.createjs.core.UIBase} */ function(value) {
  var /** @type {createjs.DisplayObject} */ container = org.apache.flex.utils.Language.as(this.positioner, createjs.DisplayObject);
  container.y = value;
  this._y = value;
  var /** @type {createjs.Stage} */ stage = container.getStage();
  if (stage)
    stage.update();
}},
/** @export */
width: {
get: /** @this {org.apache.flex.createjs.core.UIBase} */ function() {
  return this._width;
},
set: /** @this {org.apache.flex.createjs.core.UIBase} */ function(value) {
  var /** @type {createjs.DisplayObject} */ container = this.positioner;
  container.width = value;
  this._width = value;
  var /** @type {createjs.Stage} */ stage = container.getStage();
  if (stage)
    stage.update();
}},
/** @export */
height: {
get: /** @this {org.apache.flex.createjs.core.UIBase} */ function() {
  return this._height;
},
set: /** @this {org.apache.flex.createjs.core.UIBase} */ function(value) {
  var /** @type {createjs.DisplayObject} */ container = org.apache.flex.utils.Language.as(this.positioner, createjs.DisplayObject);
  container.height = value;
  this._height = value;
  var /** @type {createjs.Stage} */ stage = container.getStage();
  if (stage)
    stage.update();
}},
/** @export */
visible: {
get: /** @this {org.apache.flex.createjs.core.UIBase} */ function() {
  return this.positioner.visible;
},
set: /** @this {org.apache.flex.createjs.core.UIBase} */ function(value) {
  var /** @type {boolean} */ oldValue = this.positioner.visible;
  if (value !== oldValue) {
    if (!value) {
      this.positioner.visible = value;
      this.dispatchEvent(new org.apache.flex.events.Event('hide'));
    } else {
      this.positioner.visible = value;
      this.dispatchEvent(new org.apache.flex.events.Event('show'));
    }
    this.dispatchEvent(new org.apache.flex.events.Event('visibleChanged'));
  }
}},
/** @export */
alpha: {
get: /** @this {org.apache.flex.createjs.core.UIBase} */ function() {
  return this.positioner.alpha;
},
set: /** @this {org.apache.flex.createjs.core.UIBase} */ function(value) {
  this.positioner.alpha = value;
}},
/** @export */
positioner: {
get: /** @this {org.apache.flex.createjs.core.UIBase} */ function() {
  return this._positioner;
},
set: /** @this {org.apache.flex.createjs.core.UIBase} */ function(value) {
  this._positioner = value;
}},
/** @export */
parent: {
get: /** @this {org.apache.flex.createjs.core.UIBase} */ function() {
  var /** @type {createjs.DisplayObject} */ pos = this.positioner;
  var /** @type {org.apache.flex.core.WrappedHTMLElement} */ p = pos['parent'];
  var /** @type {org.apache.flex.core.IUIBase} */ wrapper = p ? org.apache.flex.utils.Language.as(p.flexjs_wrapper, org.apache.flex.core.IUIBase) : null;
  return wrapper;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.createjs.core.UIBase.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'UIBase', qName: 'org.apache.flex.createjs.core.UIBase'}], interfaces: [org.apache.flex.core.IStrandWithModel, org.apache.flex.events.IEventDispatcher, org.apache.flex.core.IUIBase, org.apache.flex.core.IFlexJSElement] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.createjs.core.UIBase', org.apache.flex.createjs.core.UIBase);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.createjs.core.UIBase.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'beads': { type: 'Array'}
      };
    },
    accessors: function () {
      return {
        'view': { type: 'IBeadView', declaredBy: 'org.apache.flex.createjs.core.UIBase'},
        'id': { type: 'String', declaredBy: 'org.apache.flex.createjs.core.UIBase'},
        'style': { type: 'Object', declaredBy: 'org.apache.flex.createjs.core.UIBase'},
        'className': { type: 'String', declaredBy: 'org.apache.flex.createjs.core.UIBase'},
        'topMostEventDispatcher': { type: 'IEventDispatcher', declaredBy: 'org.apache.flex.createjs.core.UIBase'},
        'numElements': { type: 'int', declaredBy: 'org.apache.flex.createjs.core.UIBase'},
        'explicitWidth': { type: 'Number', declaredBy: 'org.apache.flex.createjs.core.UIBase'},
        'explicitHeight': { type: 'Number', declaredBy: 'org.apache.flex.createjs.core.UIBase'},
        'percentWidth': { type: 'Number', declaredBy: 'org.apache.flex.createjs.core.UIBase'},
        'percentHeight': { type: 'Number', declaredBy: 'org.apache.flex.createjs.core.UIBase'},
        'x': { type: 'Number', declaredBy: 'org.apache.flex.createjs.core.UIBase'},
        'y': { type: 'Number', declaredBy: 'org.apache.flex.createjs.core.UIBase'},
        'width': { type: 'Number', declaredBy: 'org.apache.flex.createjs.core.UIBase'},
        'height': { type: 'Number', declaredBy: 'org.apache.flex.createjs.core.UIBase'},
        'visible': { type: 'Boolean', declaredBy: 'org.apache.flex.createjs.core.UIBase'},
        'alpha': { type: 'Number', declaredBy: 'org.apache.flex.createjs.core.UIBase'},
        'positioner': { type: 'WrappedHTMLElement', declaredBy: 'org.apache.flex.createjs.core.UIBase'},
        'parent': { type: 'IUIBase', declaredBy: 'org.apache.flex.createjs.core.UIBase'}
      };
    },
    methods: function () {
      return {
        'UIBase': { type: '', declaredBy: 'org.apache.flex.createjs.core.UIBase'},
        'addedToParent': { type: 'void', declaredBy: 'org.apache.flex.createjs.core.UIBase'},
        'addElement': { type: 'void', declaredBy: 'org.apache.flex.createjs.core.UIBase'},
        'addElementAt': { type: 'void', declaredBy: 'org.apache.flex.createjs.core.UIBase'},
        'getElementIndex': { type: 'int', declaredBy: 'org.apache.flex.createjs.core.UIBase'},
        'removeElement': { type: 'void', declaredBy: 'org.apache.flex.createjs.core.UIBase'},
        'getElementAt': { type: 'Object', declaredBy: 'org.apache.flex.createjs.core.UIBase'}
      };
    }
  };
};