/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/charts/supportClasses/ChartDataGroup.as
 * org.apache.flex.charts.supportClasses.ChartDataGroup
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.charts.supportClasses.ChartDataGroup');

goog.require('org.apache.flex.html.supportClasses.DataGroup');
goog.require('org.apache.flex.charts.core.IChartDataGroup');
goog.require('org.apache.flex.charts.core.IChartItemRenderer');
goog.require('org.apache.flex.core.IUIBase');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.html.supportClasses.DataGroup}
 * @implements {org.apache.flex.charts.core.IChartDataGroup}
 */
org.apache.flex.charts.supportClasses.ChartDataGroup = function() {
  org.apache.flex.charts.supportClasses.ChartDataGroup.base(this, 'constructor');
};
goog.inherits(org.apache.flex.charts.supportClasses.ChartDataGroup, org.apache.flex.html.supportClasses.DataGroup);


/**
 *  Returns the itemRenderer that matches both the series and child index. A null return is
 *  valid since some charts have optional itemRenderers for their series.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {org.apache.flex.charts.core.IChartSeries} series
 * @param {number} index
 * @return {org.apache.flex.charts.core.IChartItemRenderer}
 */
org.apache.flex.charts.supportClasses.ChartDataGroup.prototype.getItemRendererForSeriesAtIndex = function(series, index) {
  var /** @type {number} */ n = this.numElements;
  for (var /** @type {number} */ i = 0; i < n; i++) {
    var /** @type {org.apache.flex.charts.core.IChartItemRenderer} */ child = org.apache.flex.utils.Language.as(this.getElementAt(i), org.apache.flex.charts.core.IChartItemRenderer);
    if (child && child.series == series) {
      if (index == 0)
        return child;
      --index;
    }
  }
  return null;
};


/**
 *  Returns the first itemRenderer that encompasses the point.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {org.apache.flex.geom.Point} point
 * @return {org.apache.flex.charts.core.IChartItemRenderer}
 */
org.apache.flex.charts.supportClasses.ChartDataGroup.prototype.getItemRendererUnderPoint = function(point) {
  var /** @type {number} */ n = this.numElements;
  for (var /** @type {number} */ i = 0; i < n; i++) {
    var /** @type {org.apache.flex.core.IUIBase} */ child = org.apache.flex.utils.Language.as(this.getElementAt(i), org.apache.flex.core.IUIBase);
    if (child) {
      if (child.x <= point.x && point.x <= (child.x + child.width) && child.y <= point.y && point.y <= (child.y + child.height))
        return org.apache.flex.utils.Language.as(child, org.apache.flex.charts.core.IChartItemRenderer);
    }
  }
  return null;
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.charts.supportClasses.ChartDataGroup.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ChartDataGroup', qName: 'org.apache.flex.charts.supportClasses.ChartDataGroup'}], interfaces: [org.apache.flex.charts.core.IChartDataGroup] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.charts.supportClasses.ChartDataGroup', org.apache.flex.charts.supportClasses.ChartDataGroup);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.charts.supportClasses.ChartDataGroup.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'ChartDataGroup': { type: '', declaredBy: 'org.apache.flex.charts.supportClasses.ChartDataGroup'},
        'getItemRendererForSeriesAtIndex': { type: 'IChartItemRenderer', declaredBy: 'org.apache.flex.charts.supportClasses.ChartDataGroup'},
        'getItemRendererUnderPoint': { type: 'IChartItemRenderer', declaredBy: 'org.apache.flex.charts.supportClasses.ChartDataGroup'}
      };
    }
  };
};