/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/charts/optimized/SVGLineSegmentItemRenderer.as
 * org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer');

goog.require('org.apache.flex.graphics.SolidColorStroke');
goog.require('org.apache.flex.html.supportClasses.DataItemRenderer');
goog.require('org.apache.flex.svg.CompoundGraphic');
goog.require('org.apache.flex.charts.supportClasses.ILineSegmentItemRenderer');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.html.supportClasses.DataItemRenderer}
 * @implements {org.apache.flex.charts.supportClasses.ILineSegmentItemRenderer}
 */
org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer = function() {
  org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer.base(this, 'constructor');
};
goog.inherits(org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer, org.apache.flex.html.supportClasses.DataItemRenderer);


/**
 * @private
 * @type {org.apache.flex.charts.core.IChartSeries}
 */
org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer.prototype._series;


/**
 * @private
 * @type {Array}
 */
org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer.prototype._points;


/**
 * @private
 * @type {org.apache.flex.graphics.IStroke}
 */
org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer.prototype._stroke;


/**
 * @private
 * @type {number}
 */
org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer.prototype._fillColor;


/**
 *  @asprivate
 * @protected
 */
org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer.prototype.drawLine = function() {
  if (this.points != null) {
    var /** @type {org.apache.flex.svg.CompoundGraphic} */ graphicsContainer = org.apache.flex.utils.Language.as(this.itemRendererParent, org.apache.flex.svg.CompoundGraphic);
    if (this.stroke == null) {
      var /** @type {org.apache.flex.graphics.SolidColorStroke} */ solidColorStroke = new org.apache.flex.graphics.SolidColorStroke();
      solidColorStroke.color = 0x000088;
      solidColorStroke.weight = 1;
      solidColorStroke.alpha = 1;
      this._stroke = solidColorStroke;
    }
    graphicsContainer.stroke = this.stroke;
    graphicsContainer.fill = null;
    var /** @type {string} */ pathString = "";
    for (var /** @type {number} */ i = 0; i < this.points.length; i++) {
      var /** @type {Object} */ point = this.points[i];
      if (i == 0)
        pathString += "M " + point.x + " " + point.y + " ";
      else
        pathString += "L " + point.x + " " + point.y + " ";
    }
    graphicsContainer.drawStringPath(pathString);
  }
};


Object.defineProperties(org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer.prototype, /** @lends {org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer.prototype} */ {
/** @export */
series: {
get: /** @this {org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer} */ function() {
  return this._series;
},
set: /** @this {org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer} */ function(value) {
  this._series = value;
}},
/** @export */
points: {
get: /** @this {org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer} */ function() {
  return this._points;
},
set: /** @this {org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer} */ function(value) {
  this._points = value;
  this.drawLine();
}},
/** @export */
stroke: {
get: /** @this {org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer} */ function() {
  return this._stroke;
},
set: /** @this {org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer} */ function(value) {
  this._stroke = value;
  this.drawLine();
}},
/** @export */
data: {
get: /** @this {org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer} */ function() {
  return org.apache.flex.utils.Language.superGetter(org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer, this, 'data');
},
set: /** @this {org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer} */ function(value) {
  org.apache.flex.utils.Language.superSetter(org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer, this, 'data', value);
}},
/** @export */
yField: {
get: /** @this {org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer} */ function() {
  return null;
},
set: /** @this {org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer} */ function(value) {
}},
/** @export */
xField: {
get: /** @this {org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer} */ function() {
  return null;
},
set: /** @this {org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer} */ function(value) {
}},
/** @export */
fillColor: {
get: /** @this {org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer} */ function() {
  return this._fillColor;
},
set: /** @this {org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer} */ function(value) {
  this._fillColor = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'SVGLineSegmentItemRenderer', qName: 'org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer'}], interfaces: [org.apache.flex.charts.supportClasses.ILineSegmentItemRenderer] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer', org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'series': { type: 'IChartSeries', declaredBy: 'org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer'},
        'points': { type: 'Array', declaredBy: 'org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer'},
        'stroke': { type: 'IStroke', declaredBy: 'org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer'},
        'data': { type: 'Object', declaredBy: 'org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer'},
        'yField': { type: 'String', declaredBy: 'org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer'},
        'xField': { type: 'String', declaredBy: 'org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer'},
        'fillColor': { type: 'uint', declaredBy: 'org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer'}
      };
    },
    methods: function () {
      return {
        'SVGLineSegmentItemRenderer': { type: '', declaredBy: 'org.apache.flex.charts.optimized.SVGLineSegmentItemRenderer'}
      };
    }
  };
};