/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/charts/beads/layouts/ChartBaseLayout.as
 * org.apache.flex.charts.beads.layouts.ChartBaseLayout
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.charts.beads.layouts.ChartBaseLayout');

goog.require('org.apache.flex.charts.core.ChartBase');
goog.require('org.apache.flex.charts.core.IChartDataGroup');
goog.require('org.apache.flex.charts.core.IHorizontalAxisBead');
goog.require('org.apache.flex.charts.core.IVerticalAxisBead');
goog.require('org.apache.flex.core.IBeadLayout');
goog.require('org.apache.flex.core.ILayoutHost');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @implements {org.apache.flex.core.IBeadLayout}
 */
org.apache.flex.charts.beads.layouts.ChartBaseLayout = function() {
};


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.charts.beads.layouts.ChartBaseLayout.prototype._strand;


/**
 * @private
 * @type {org.apache.flex.charts.core.IHorizontalAxisBead}
 */
org.apache.flex.charts.beads.layouts.ChartBaseLayout.prototype._xAxis = null;


/**
 * @private
 * @type {org.apache.flex.charts.core.IVerticalAxisBead}
 */
org.apache.flex.charts.beads.layouts.ChartBaseLayout.prototype._yAxis = null;


/**
 * @private
 * @type {org.apache.flex.charts.core.IChartDataGroup}
 */
org.apache.flex.charts.beads.layouts.ChartBaseLayout.prototype._chartDataGroup;


/**
 * @copy org.apache.flex.core.IBeadLayout#layout
 * @export
 * @return {boolean}
 */
org.apache.flex.charts.beads.layouts.ChartBaseLayout.prototype.layout = function() {
  this.performLayout();
  return true;
};


/**
 *  Subclasses should implement this to draw the chart, adding elements to the chartDataGroup.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @protected
 */
org.apache.flex.charts.beads.layouts.ChartBaseLayout.prototype.performLayout = function() {
};


Object.defineProperties(org.apache.flex.charts.beads.layouts.ChartBaseLayout.prototype, /** @lends {org.apache.flex.charts.beads.layouts.ChartBaseLayout.prototype} */ {
/** @export */
strand: {
get: /** @this {org.apache.flex.charts.beads.layouts.ChartBaseLayout} */ function() {
  return this._strand;
},
set: /** @this {org.apache.flex.charts.beads.layouts.ChartBaseLayout} */ function(value) {
  this._strand = value;
}},
/** @export */
chart: {
get: /** @this {org.apache.flex.charts.beads.layouts.ChartBaseLayout} */ function() {
  return org.apache.flex.utils.Language.as(this._strand, org.apache.flex.charts.core.ChartBase);
}},
/** @export */
horizontalAxisBead: {
get: /** @this {org.apache.flex.charts.beads.layouts.ChartBaseLayout} */ function() {
  if (this._xAxis == null) {
    if (this.chart.getBeadByType(org.apache.flex.charts.core.IHorizontalAxisBead))
      this._xAxis = org.apache.flex.utils.Language.as(this.chart.getBeadByType(org.apache.flex.charts.core.IHorizontalAxisBead), org.apache.flex.charts.core.IHorizontalAxisBead);
  }
  return this._xAxis;
}},
/** @export */
verticalAxisBead: {
get: /** @this {org.apache.flex.charts.beads.layouts.ChartBaseLayout} */ function() {
  if (this._yAxis == null) {
    if (this.chart.getBeadByType(org.apache.flex.charts.core.IVerticalAxisBead))
      this._yAxis = org.apache.flex.utils.Language.as(this.chart.getBeadByType(org.apache.flex.charts.core.IVerticalAxisBead), org.apache.flex.charts.core.IVerticalAxisBead);
  }
  return this._yAxis;
}},
/** @export */
chartDataGroup: {
get: /** @this {org.apache.flex.charts.beads.layouts.ChartBaseLayout} */ function() {
  if (this._chartDataGroup == null) {
    var /** @type {org.apache.flex.core.ILayoutHost} */ layoutParent = org.apache.flex.utils.Language.as(this.chart.getBeadByType(org.apache.flex.core.ILayoutHost), org.apache.flex.core.ILayoutHost);
    this._chartDataGroup = org.apache.flex.utils.Language.as(layoutParent.contentView, org.apache.flex.charts.core.IChartDataGroup);
  }
  return this._chartDataGroup;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.charts.beads.layouts.ChartBaseLayout.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ChartBaseLayout', qName: 'org.apache.flex.charts.beads.layouts.ChartBaseLayout'}], interfaces: [org.apache.flex.core.IBeadLayout] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.charts.beads.layouts.ChartBaseLayout', org.apache.flex.charts.beads.layouts.ChartBaseLayout);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.charts.beads.layouts.ChartBaseLayout.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.charts.beads.layouts.ChartBaseLayout'},
        'chart': { type: 'ChartBase', declaredBy: 'org.apache.flex.charts.beads.layouts.ChartBaseLayout'},
        'horizontalAxisBead': { type: 'IHorizontalAxisBead', declaredBy: 'org.apache.flex.charts.beads.layouts.ChartBaseLayout'},
        'verticalAxisBead': { type: 'IVerticalAxisBead', declaredBy: 'org.apache.flex.charts.beads.layouts.ChartBaseLayout'},
        'chartDataGroup': { type: 'IChartDataGroup', declaredBy: 'org.apache.flex.charts.beads.layouts.ChartBaseLayout'}
      };
    },
    methods: function () {
      return {
        'ChartBaseLayout': { type: '', declaredBy: 'org.apache.flex.charts.beads.layouts.ChartBaseLayout'},
        'layout': { type: 'Boolean', declaredBy: 'org.apache.flex.charts.beads.layouts.ChartBaseLayout'}
      };
    }
  };
};