/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from google/maps/MVCArray.as
 * google.maps.MVCArray
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('google.maps.MVCArray');



/**
 * @asparam opt_array [(Array|null|undefined)] 
 * @see [google_maps_api_v3_11]
 * @constructor
 * @extends {google.maps.MVCObject}
 * @param {Array=} opt_array
 */
google.maps.MVCArray = function(opt_array) {
  opt_array = typeof opt_array !== 'undefined' ? opt_array : null;
  google.maps.MVCArray.base(this, 'constructor');
};
goog.inherits(google.maps.MVCArray, google.maps.MVCObject);


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @return {Object}
 */
google.maps.MVCArray.prototype.clear = function() {
  return null;
};


/**
 * @asparam i [number] 
 * @see [google_maps_api_v3_11]
 * @asreturns {*} 
 * @export
 * @param {number} i
 * @return {*}
 */
google.maps.MVCArray.prototype.removeAt = function(i) {
  return null;
};


/**
 * @asparam i [number] 
 * @asparam elem [*] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {number} i
 * @param {*} elem
 * @return {Object}
 */
google.maps.MVCArray.prototype.insertAt = function(i, elem) {
  return null;
};


/**
 * @asparam callback [function (?, number): ?] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {Function} callback
 * @return {Object}
 */
google.maps.MVCArray.prototype.forEach = function(callback) {
  return null;
};


/**
 * @asparam i [number] 
 * @see [google_maps_api_v3_11]
 * @asreturns {*} 
 * @export
 * @param {number} i
 * @return {*}
 */
google.maps.MVCArray.prototype.getAt = function(i) {
  return null;
};


/**
 * @asparam i [number] 
 * @asparam elem [*] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {number} i
 * @param {*} elem
 * @return {Object}
 */
google.maps.MVCArray.prototype.setAt = function(i, elem) {
  return null;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {*} 
 * @export
 * @return {*}
 */
google.maps.MVCArray.prototype.pop = function() {
  return null;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {number} 
 * @export
 * @return {number}
 */
google.maps.MVCArray.prototype.getLength = function() {
  return 0;
};


/**
 * @asparam elem [*] 
 * @see [google_maps_api_v3_11]
 * @asreturns {number} 
 * @export
 * @param {*} elem
 * @return {number}
 */
google.maps.MVCArray.prototype.push = function(elem) {
  return 0;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {(Array|null)} 
 * @export
 * @return {Array}
 */
google.maps.MVCArray.prototype.getArray = function() {
  return null;
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
google.maps.MVCArray.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'MVCArray', qName: 'google.maps.MVCArray'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('google.maps.MVCArray', google.maps.MVCArray);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
google.maps.MVCArray.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'MVCArray': { type: '', declaredBy: 'google.maps.MVCArray'},
        'clear': { type: 'Object', declaredBy: 'google.maps.MVCArray'},
        'removeAt': { type: '*', declaredBy: 'google.maps.MVCArray'},
        'insertAt': { type: 'Object', declaredBy: 'google.maps.MVCArray'},
        'forEach': { type: 'Object', declaredBy: 'google.maps.MVCArray'},
        'getAt': { type: '*', declaredBy: 'google.maps.MVCArray'},
        'setAt': { type: 'Object', declaredBy: 'google.maps.MVCArray'},
        'pop': { type: '*', declaredBy: 'google.maps.MVCArray'},
        'getLength': { type: 'Number', declaredBy: 'google.maps.MVCArray'},
        'push': { type: 'Number', declaredBy: 'google.maps.MVCArray'},
        'getArray': { type: 'Array', declaredBy: 'google.maps.MVCArray'}
      };
    }
  };
};