/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/cordova/camera/Camera.as
 * org.apache.cordova.camera.Camera
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.cordova.camera.Camera');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 */
org.apache.cordova.camera.Camera = function() {
  this.pictureSourceType = Number(org.apache.cordova.camera.Camera.PictureSourceType.PHOTOLIBRARY);
  this.destinationType = Number(org.apache.cordova.camera.Camera.DestinationType.DATA_URL);
  this.mediaType = Number(org.apache.cordova.camera.Camera.MediaType.PICTURE);
  this.encodingType = Number(org.apache.cordova.camera.Camera.EncodingType.JPEG);
  this.direction = Number(org.apache.cordova.camera.Camera.Direction.BACK);
};


/**
 * @export
 * @type {Object}
 */
org.apache.cordova.camera.Camera.DestinationType = {DATA_URL:0, FILE_URI:1, NATIVE_URI:2};


/**
 * @export
 * @type {Object}
 */
org.apache.cordova.camera.Camera.PictureSourceType = {PHOTOLIBRARY:0, CAMERA:1, SAVEDPHOTOALBUM:2};


/**
 * @export
 * @type {Object}
 */
org.apache.cordova.camera.Camera.EncodingType = {JPEG:0, PNG:1};


/**
 * @export
 * @type {Object}
 */
org.apache.cordova.camera.Camera.MediaType = {PICTURE:0, VIDEO:1, ALLMEDIA:2};


/**
 * @export
 * @type {Object}
 */
org.apache.cordova.camera.Camera.Direction = {BACK:0, FRONT:1};


/**
 * @export
 * @type {number}
 */
org.apache.cordova.camera.Camera.prototype.pictureSourceType;


/**
 * @export
 * @type {number}
 */
org.apache.cordova.camera.Camera.prototype.destinationType;


/**
 * @export
 * @type {number}
 */
org.apache.cordova.camera.Camera.prototype.mediaType;


/**
 * @export
 * @type {number}
 */
org.apache.cordova.camera.Camera.prototype.encodingType;


/**
 * @export
 * @type {number}
 */
org.apache.cordova.camera.Camera.prototype.direction;


/**
 * @private
 * @type {Function}
 */
org.apache.cordova.camera.Camera.prototype.cameraSuccess;


/**
 * @private
 * @type {Function}
 */
org.apache.cordova.camera.Camera.prototype.cameraError;


/**
 * @export
 * @param {Function} cameraSuccess
 * @param {Function} cameraError
 * @param {Object} cameraOptions
 */
org.apache.cordova.camera.Camera.prototype.getPicture = function(cameraSuccess, cameraError, cameraOptions) {
  
  navigator["camera"].getPicture(cameraSuccess, cameraError, cameraOptions);
};


/**
 * @export
 * @param {Function} cameraSuccess
 * @param {Function} cameraError
 */
org.apache.cordova.camera.Camera.prototype.cleanup = function(cameraSuccess, cameraError) {
  navigator["camera"].cleanup();
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.cordova.camera.Camera.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Camera', qName: 'org.apache.cordova.camera.Camera'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.cordova.camera.Camera', org.apache.cordova.camera.Camera);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.cordova.camera.Camera.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'pictureSourceType': { type: 'int'},
        'destinationType': { type: 'int'},
        'mediaType': { type: 'int'},
        'encodingType': { type: 'int'},
        'direction': { type: 'int'}
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'Camera': { type: '', declaredBy: 'org.apache.cordova.camera.Camera'},
        'getPicture': { type: 'void', declaredBy: 'org.apache.cordova.camera.Camera'},
        'cleanup': { type: 'void', declaredBy: 'org.apache.cordova.camera.Camera'}
      };
    },
    metadata: function () { return [ { name: 'Mixin'}]; }
  };
};