/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/controllers/ListSingleSelectionMouseController.as
 * org.apache.flex.html.beads.controllers.ListSingleSelectionMouseController
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.controllers.ListSingleSelectionMouseController');

goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.core.IBeadController');
goog.require('org.apache.flex.core.IRollOverModel');
goog.require('org.apache.flex.core.ISelectableItemRenderer');
goog.require('org.apache.flex.core.ISelectionModel');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.html.beads.IListView');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBeadController}
 */
org.apache.flex.html.beads.controllers.ListSingleSelectionMouseController = function() {
};


/**
 * @protected
 * @type {org.apache.flex.core.ISelectionModel}
 */
org.apache.flex.html.beads.controllers.ListSingleSelectionMouseController.prototype.listModel;


/**
 * @protected
 * @type {org.apache.flex.html.beads.IListView}
 */
org.apache.flex.html.beads.controllers.ListSingleSelectionMouseController.prototype.listView;


/**
 * @protected
 * @type {org.apache.flex.core.IItemRendererParent}
 */
org.apache.flex.html.beads.controllers.ListSingleSelectionMouseController.prototype.dataGroup;


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.html.beads.controllers.ListSingleSelectionMouseController.prototype._strand;


/**
 * @protected
 * @param {org.apache.flex.events.ItemAddedEvent} event
 */
org.apache.flex.html.beads.controllers.ListSingleSelectionMouseController.prototype.handleItemAdded = function(event) {
  org.apache.flex.utils.Language.as(event.item, org.apache.flex.events.IEventDispatcher, true).addEventListener("itemClicked", org.apache.flex.utils.Language.closure(this.selectedHandler, this, 'selectedHandler'));
  org.apache.flex.utils.Language.as(event.item, org.apache.flex.events.IEventDispatcher, true).addEventListener("itemRollOver", org.apache.flex.utils.Language.closure(this.rolloverHandler, this, 'rolloverHandler'));
  org.apache.flex.utils.Language.as(event.item, org.apache.flex.events.IEventDispatcher, true).addEventListener("itemRollOut", org.apache.flex.utils.Language.closure(this.rolloutHandler, this, 'rolloutHandler'));
};


/**
 * @protected
 * @param {org.apache.flex.events.ItemAddedEvent} event
 */
org.apache.flex.html.beads.controllers.ListSingleSelectionMouseController.prototype.handleItemRemoved = function(event) {
  org.apache.flex.utils.Language.as(event.item, org.apache.flex.events.IEventDispatcher, true).removeEventListener("itemClicked", org.apache.flex.utils.Language.closure(this.selectedHandler, this, 'selectedHandler'));
  org.apache.flex.utils.Language.as(event.item, org.apache.flex.events.IEventDispatcher, true).removeEventListener("itemRollOver", org.apache.flex.utils.Language.closure(this.rolloverHandler, this, 'rolloverHandler'));
  org.apache.flex.utils.Language.as(event.item, org.apache.flex.events.IEventDispatcher, true).removeEventListener("itemRollOut", org.apache.flex.utils.Language.closure(this.rolloutHandler, this, 'rolloutHandler'));
};


/**
 * @protected
 * @param {org.apache.flex.events.ItemClickedEvent} event
 */
org.apache.flex.html.beads.controllers.ListSingleSelectionMouseController.prototype.selectedHandler = function(event) {
  this.listModel.selectedIndex = event.index;
  this.listView.host.dispatchEvent(new org.apache.flex.events.Event("change"));
};


/**
 * @protected
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.controllers.ListSingleSelectionMouseController.prototype.rolloverHandler = function(event) {
  var /** @type {org.apache.flex.core.ISelectableItemRenderer} */ renderer = org.apache.flex.utils.Language.as(event.currentTarget, org.apache.flex.core.ISelectableItemRenderer);
  if (renderer) {
    org.apache.flex.utils.Language.as(this.listModel, org.apache.flex.core.IRollOverModel, true).rollOverIndex = renderer.index;
  }
};


/**
 * @protected
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.controllers.ListSingleSelectionMouseController.prototype.rolloutHandler = function(event) {
  var /** @type {org.apache.flex.core.ISelectableItemRenderer} */ renderer = org.apache.flex.utils.Language.as(event.currentTarget, org.apache.flex.core.ISelectableItemRenderer);
  if (renderer) {
    renderer.hovered = false;
    renderer.down = false;
    org.apache.flex.utils.Language.as(this.listModel, org.apache.flex.core.IRollOverModel, true).rollOverIndex = -1;
  }
};


Object.defineProperties(org.apache.flex.html.beads.controllers.ListSingleSelectionMouseController.prototype, /** @lends {org.apache.flex.html.beads.controllers.ListSingleSelectionMouseController.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.controllers.ListSingleSelectionMouseController} */ function(value) {
  this._strand = value;
  this.listModel = org.apache.flex.utils.Language.as(value.getBeadByType(org.apache.flex.core.ISelectionModel), org.apache.flex.core.ISelectionModel);
  this.listView = org.apache.flex.utils.Language.as(value.getBeadByType(org.apache.flex.html.beads.IListView), org.apache.flex.html.beads.IListView);
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher, true).addEventListener("itemAdded", org.apache.flex.utils.Language.closure(this.handleItemAdded, this, 'handleItemAdded'));
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher, true).addEventListener("itemRemoved", org.apache.flex.utils.Language.closure(this.handleItemRemoved, this, 'handleItemRemoved'));
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.controllers.ListSingleSelectionMouseController.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ListSingleSelectionMouseController', qName: 'org.apache.flex.html.beads.controllers.ListSingleSelectionMouseController'}], interfaces: [org.apache.flex.core.IBeadController] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.controllers.ListSingleSelectionMouseController', org.apache.flex.html.beads.controllers.ListSingleSelectionMouseController);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.controllers.ListSingleSelectionMouseController.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.controllers.ListSingleSelectionMouseController'}
      };
    },
    methods: function () {
      return {
        'ListSingleSelectionMouseController': { type: '', declaredBy: 'org.apache.flex.html.beads.controllers.ListSingleSelectionMouseController'}
      };
    }
  };
};