/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/ImageView.as
 * org.apache.flex.html.beads.ImageView
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.ImageView');

goog.require('org.apache.flex.core.BeadViewBase');
goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.core.IBeadView');
goog.require('org.apache.flex.core.IImageModel');
goog.require('org.apache.flex.core.IUIBase');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.BeadViewBase}
 * @implements {org.apache.flex.core.IBeadView}
 */
org.apache.flex.html.beads.ImageView = function() {
  org.apache.flex.html.beads.ImageView.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.beads.ImageView, org.apache.flex.core.BeadViewBase);


/**
 * @private
 * @type {org.apache.flex.core.IImageModel}
 */
org.apache.flex.html.beads.ImageView.prototype._model;


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.ImageView.prototype.handleUrlChange = function(event) {
  
  if (this._model.source) {
    var /** @type {org.apache.flex.core.IUIBase} */ host = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.IUIBase);
    host.element.addEventListener('load', org.apache.flex.utils.Language.closure(this.loadHandler, this, 'loadHandler'), false);
    host.addEventListener('sizeChanged', org.apache.flex.utils.Language.closure(this.sizeChangedHandler, this, 'sizeChangedHandler'));
    org.apache.flex.utils.Language.as(host.element, HTMLImageElement).src = this._model.source;
  }
};


/**
 * @private
 * @param {Object} event
 */
org.apache.flex.html.beads.ImageView.prototype.loadHandler = function(event) {
  var /** @type {org.apache.flex.core.UIBase} */ host = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true);
  host.parent.dispatchEvent(new org.apache.flex.events.Event("layoutNeeded"));
};


/**
 * @flexjsignorecoercion HTMLElement
 * @private
 * @param {Object} event
 */
org.apache.flex.html.beads.ImageView.prototype.sizeChangedHandler = function(event) {
  var /** @type {org.apache.flex.core.UIBase} */ host = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase);
  var /** @type {Object} */ s = host.positioner.style;
  var /** @type {number} */ l = NaN;
  var /** @type {string} */ ls = org.apache.flex.utils.Language.string(s.left);
  if (typeof(ls) === 'string' && ls.length > 0)
    l = parseFloat(ls.substring(0, ls.length - 2));
  var /** @type {number} */ r = NaN;
  var /** @type {string} */ rs = org.apache.flex.utils.Language.string(s.right);
  if (typeof(rs) === 'string' && rs.length > 0)
    r = parseFloat(rs.substring(0, rs.length - 2));
  if (!isNaN(l) && !isNaN(r)) {
    var /** @type {number} */ computedWidth = host.positioner.offsetParent.offsetWidth - l - r;
    s.width = computedWidth.toString() + 'px';
  }
  var /** @type {number} */ t = NaN;
  var /** @type {string} */ ts = org.apache.flex.utils.Language.string(s.top);
  if (typeof(ts) === 'string' && ts.length > 0)
    t = parseFloat(ts.substring(0, ts.length - 2));
  var /** @type {number} */ b = NaN;
  var /** @type {string} */ bs = org.apache.flex.utils.Language.string(s.right);
  if (typeof(bs) === 'string' && bs.length > 0)
    b = parseFloat(bs.substring(0, bs.length - 2));
  if (!isNaN(t) && !isNaN(b)) {
    var /** @type {number} */ computedHeight = host.positioner.offsetParent.offsetHeight - t - b;
    s.height = computedHeight.toString() + 'px';
  }
};


Object.defineProperties(org.apache.flex.html.beads.ImageView.prototype, /** @lends {org.apache.flex.html.beads.ImageView.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.ImageView} */ function(value) {
  org.apache.flex.utils.Language.superSetter(org.apache.flex.html.beads.ImageView, this, 'strand', value);
  
  this._model = org.apache.flex.utils.Language.as(value.getBeadByType(org.apache.flex.core.IImageModel), org.apache.flex.core.IImageModel);
  this._model.addEventListener("urlChanged", org.apache.flex.utils.Language.closure(this.handleUrlChange, this, 'handleUrlChange'));
  this.handleUrlChange(null);
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.ImageView.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ImageView', qName: 'org.apache.flex.html.beads.ImageView'}], interfaces: [org.apache.flex.core.IBeadView] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.ImageView', org.apache.flex.html.beads.ImageView);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.ImageView.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.ImageView'}
      };
    },
    methods: function () {
      return {
        'ImageView': { type: '', declaredBy: 'org.apache.flex.html.beads.ImageView'}
      };
    }
  };
};