/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/DataProviderChangeNotifier.as
 * org.apache.flex.html.beads.DataProviderChangeNotifier
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.DataProviderChangeNotifier');

goog.require('org.apache.flex.collections.ArrayList');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.IDocument');
goog.require('org.apache.flex.core.ISelectionModel');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBead}
 * @implements {org.apache.flex.core.IDocument}
 */
org.apache.flex.html.beads.DataProviderChangeNotifier = function() {
};


/**
 * @protected
 * @type {org.apache.flex.collections.ArrayList}
 */
org.apache.flex.html.beads.DataProviderChangeNotifier.prototype._dataProvider;


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.html.beads.DataProviderChangeNotifier.prototype._strand;


/**
 * @protected
 * @type {Object}
 */
org.apache.flex.html.beads.DataProviderChangeNotifier.prototype.document;


/**
 * @asprivate
 * @export
 * @param {Object} document
 * @param {string=} id
 */
org.apache.flex.html.beads.DataProviderChangeNotifier.prototype.setDocument = function(document, id) {
  id = typeof id !== 'undefined' ? id : null;
  this.document = document;
};


/**
 * @private
 * @type {string}
 */
org.apache.flex.html.beads.DataProviderChangeNotifier.prototype._sourceID;


/**
 * @private
 * @type {string}
 */
org.apache.flex.html.beads.DataProviderChangeNotifier.prototype._propertyName;


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.DataProviderChangeNotifier.prototype.handleItemAdded = function(event) {
  var /** @type {org.apache.flex.core.ISelectionModel} */ selectionModel = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.ISelectionModel), org.apache.flex.core.ISelectionModel);
  selectionModel.dispatchEvent(new org.apache.flex.events.Event("dataProviderChanged"));
};


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.DataProviderChangeNotifier.prototype.handleItemRemoved = function(event) {
  var /** @type {org.apache.flex.core.ISelectionModel} */ selectionModel = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.ISelectionModel), org.apache.flex.core.ISelectionModel);
  selectionModel.dispatchEvent(new org.apache.flex.events.Event("dataProviderChanged"));
};


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.DataProviderChangeNotifier.prototype.handleItemUpdated = function(event) {
  var /** @type {org.apache.flex.core.ISelectionModel} */ selectionModel = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.ISelectionModel), org.apache.flex.core.ISelectionModel);
  selectionModel.dispatchEvent(new org.apache.flex.events.Event("dataProviderChanged"));
};


Object.defineProperties(org.apache.flex.html.beads.DataProviderChangeNotifier.prototype, /** @lends {org.apache.flex.html.beads.DataProviderChangeNotifier.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.DataProviderChangeNotifier} */ function(value) {
  this._strand = value;
  if (this._dataProvider == null) {
    var /** @type {Object} */ object = this.document[this.sourceID];
    this._dataProvider = org.apache.flex.utils.Language.as(object[this.propertyName], org.apache.flex.collections.ArrayList);
  }
  this._dataProvider.addEventListener("itemAdded", org.apache.flex.utils.Language.closure(this.handleItemAdded, this, 'handleItemAdded'));
  this._dataProvider.addEventListener("itemRemoved", org.apache.flex.utils.Language.closure(this.handleItemRemoved, this, 'handleItemRemoved'));
  this._dataProvider.addEventListener("itemUpdated", org.apache.flex.utils.Language.closure(this.handleItemUpdated, this, 'handleItemUpdated'));
}},
/** @export */
sourceID: {
get: /** @this {org.apache.flex.html.beads.DataProviderChangeNotifier} */ function() {
  return this._sourceID;
},
set: /** @this {org.apache.flex.html.beads.DataProviderChangeNotifier} */ function(value) {
  this._sourceID = value;
}},
/** @export */
propertyName: {
get: /** @this {org.apache.flex.html.beads.DataProviderChangeNotifier} */ function() {
  return this._propertyName;
},
set: /** @this {org.apache.flex.html.beads.DataProviderChangeNotifier} */ function(value) {
  this._propertyName = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.DataProviderChangeNotifier.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'DataProviderChangeNotifier', qName: 'org.apache.flex.html.beads.DataProviderChangeNotifier'}], interfaces: [org.apache.flex.core.IBead, org.apache.flex.core.IDocument] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.DataProviderChangeNotifier', org.apache.flex.html.beads.DataProviderChangeNotifier);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.DataProviderChangeNotifier.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.DataProviderChangeNotifier'},
        'sourceID': { type: 'String', declaredBy: 'org.apache.flex.html.beads.DataProviderChangeNotifier'},
        'propertyName': { type: 'String', declaredBy: 'org.apache.flex.html.beads.DataProviderChangeNotifier'}
      };
    },
    methods: function () {
      return {
        'DataProviderChangeNotifier': { type: '', declaredBy: 'org.apache.flex.html.beads.DataProviderChangeNotifier'},
        'setDocument': { type: 'void', declaredBy: 'org.apache.flex.html.beads.DataProviderChangeNotifier'}
      };
    }
  };
};