/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/DataItemRendererFactoryForHierarchicalData.as
 * org.apache.flex.html.beads.DataItemRendererFactoryForHierarchicalData
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.DataItemRendererFactoryForHierarchicalData');

goog.require('org.apache.flex.collections.FlattenedList');
goog.require('org.apache.flex.html.beads.DataItemRendererFactoryForArrayList');
goog.require('org.apache.flex.html.supportClasses.TreeListData');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.html.beads.DataItemRendererFactoryForArrayList}
 */
org.apache.flex.html.beads.DataItemRendererFactoryForHierarchicalData = function() {
  org.apache.flex.html.beads.DataItemRendererFactoryForHierarchicalData.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.beads.DataItemRendererFactoryForHierarchicalData, org.apache.flex.html.beads.DataItemRendererFactoryForArrayList);


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.html.beads.DataItemRendererFactoryForHierarchicalData.prototype._strand;


/**
 * Sets the itemRenderer's data with additional tree-related data.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @protected
 * @override
 */
org.apache.flex.html.beads.DataItemRendererFactoryForHierarchicalData.prototype.setData = function(ir, data, index) {
  var /** @type {org.apache.flex.collections.FlattenedList} */ flatList = org.apache.flex.utils.Language.as(this.selectionModel.dataProvider, org.apache.flex.collections.FlattenedList);
  var /** @type {number} */ depth = flatList.getDepth(data);
  var /** @type {boolean} */ isOpen = flatList.isOpen(data);
  var /** @type {boolean} */ hasChildren = flatList.hasChildren(data);
  var /** @type {org.apache.flex.html.supportClasses.TreeListData} */ treeData = new org.apache.flex.html.supportClasses.TreeListData();
  treeData.depth = depth;
  treeData.isOpen = isOpen;
  treeData.hasChildren = hasChildren;
  ir.listData = treeData;
  org.apache.flex.html.beads.DataItemRendererFactoryForHierarchicalData.base(this, 'setData', ir, data, index);
};


Object.defineProperties(org.apache.flex.html.beads.DataItemRendererFactoryForHierarchicalData.prototype, /** @lends {org.apache.flex.html.beads.DataItemRendererFactoryForHierarchicalData.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.DataItemRendererFactoryForHierarchicalData} */ function(value) {
  this._strand = value;
  org.apache.flex.utils.Language.superSetter(org.apache.flex.html.beads.DataItemRendererFactoryForHierarchicalData, this, 'strand', value);
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.DataItemRendererFactoryForHierarchicalData.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'DataItemRendererFactoryForHierarchicalData', qName: 'org.apache.flex.html.beads.DataItemRendererFactoryForHierarchicalData'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.DataItemRendererFactoryForHierarchicalData', org.apache.flex.html.beads.DataItemRendererFactoryForHierarchicalData);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.DataItemRendererFactoryForHierarchicalData.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.DataItemRendererFactoryForHierarchicalData'}
      };
    },
    methods: function () {
      return {
        'DataItemRendererFactoryForHierarchicalData': { type: '', declaredBy: 'org.apache.flex.html.beads.DataItemRendererFactoryForHierarchicalData'}
      };
    }
  };
};