/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/accessories/ToolTipBead.as
 * org.apache.flex.html.accessories.ToolTipBead
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.accessories.ToolTipBead');

goog.require('org.apache.flex.events.MouseEvent');
goog.require('org.apache.flex.geom.Point');
goog.require('org.apache.flex.html.ToolTip');
goog.require('org.apache.flex.utils.PointUtils');
goog.require('org.apache.flex.utils.UIUtils');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.IUIBase');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBead}
 */
org.apache.flex.html.accessories.ToolTipBead = function() {
};


/**
 * @private
 * @type {string}
 */
org.apache.flex.html.accessories.ToolTipBead.prototype._toolTip;


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.html.accessories.ToolTipBead.prototype._strand;


/**
 * @private
 * @type {org.apache.flex.html.ToolTip}
 */
org.apache.flex.html.accessories.ToolTipBead.prototype.tt;


/**
 * @private
 * @type {org.apache.flex.core.IPopUpHost}
 */
org.apache.flex.html.accessories.ToolTipBead.prototype.host;


/**
 * @asprivate
 * @protected
 * @param {org.apache.flex.events.MouseEvent} event
 */
org.apache.flex.html.accessories.ToolTipBead.prototype.rollOverHandler = function(event) {
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher, true).addEventListener(org.apache.flex.events.MouseEvent.MOUSE_OUT, org.apache.flex.utils.Language.closure(this.rollOutHandler, this, 'rollOutHandler'), false);
  var /** @type {org.apache.flex.core.IUIBase} */ comp = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.IUIBase);
  this.host = org.apache.flex.utils.UIUtils.findPopUpHost(comp);
  if (this.tt)
    this.host.removeElement(this.tt);
  this.tt = new org.apache.flex.html.ToolTip();
  this.tt.text = this.toolTip;
  var /** @type {org.apache.flex.geom.Point} */ pt = this.determinePosition(event, event.target);
  this.tt.x = pt.x;
  this.tt.y = pt.y;
  this.host.addElement(this.tt, false);
};


/**
 * @asprivate
 * Determines the position of the toolTip.
 * @protected
 * @param {org.apache.flex.events.MouseEvent} event
 * @param {Object} base
 * @return {org.apache.flex.geom.Point}
 */
org.apache.flex.html.accessories.ToolTipBead.prototype.determinePosition = function(event, base) {
  var /** @type {org.apache.flex.core.IUIBase} */ comp = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.IUIBase);
  var /** @type {org.apache.flex.geom.Point} */ pt = new org.apache.flex.geom.Point(comp.width, comp.height);
  pt = org.apache.flex.utils.PointUtils.localToGlobal(pt, comp);
  return pt;
};


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.MouseEvent} event
 */
org.apache.flex.html.accessories.ToolTipBead.prototype.rollOutHandler = function(event) {
  if (this.tt) {
    this.host.removeElement(this.tt);
  }
  this.tt = null;
};


Object.defineProperties(org.apache.flex.html.accessories.ToolTipBead.prototype, /** @lends {org.apache.flex.html.accessories.ToolTipBead.prototype} */ {
/** @export */
toolTip: {
get: /** @this {org.apache.flex.html.accessories.ToolTipBead} */ function() {
  return this._toolTip;
},
set: /** @this {org.apache.flex.html.accessories.ToolTipBead} */ function(value) {
  this._toolTip = value;
}},
/** @export */
strand: {
set: /** @this {org.apache.flex.html.accessories.ToolTipBead} */ function(value) {
  this._strand = value;
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher, true).addEventListener(org.apache.flex.events.MouseEvent.MOUSE_OVER, org.apache.flex.utils.Language.closure(this.rollOverHandler, this, 'rollOverHandler'), false);
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.accessories.ToolTipBead.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ToolTipBead', qName: 'org.apache.flex.html.accessories.ToolTipBead'}], interfaces: [org.apache.flex.core.IBead] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.accessories.ToolTipBead', org.apache.flex.html.accessories.ToolTipBead);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.accessories.ToolTipBead.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'toolTip': { type: 'String', declaredBy: 'org.apache.flex.html.accessories.ToolTipBead'},
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.accessories.ToolTipBead'}
      };
    },
    methods: function () {
      return {
        'ToolTipBead': { type: '', declaredBy: 'org.apache.flex.html.accessories.ToolTipBead'}
      };
    }
  };
};