/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/ImageButton.as
 * org.apache.flex.html.ImageButton
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.ImageButton');

goog.require('org.apache.flex.core.SimpleCSSStyles');
goog.require('org.apache.flex.html.Button');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.html.Button}
 */
org.apache.flex.html.ImageButton = function() {
  org.apache.flex.html.ImageButton.base(this, 'constructor');
  this.typeNames = "ImageButton";
};
goog.inherits(org.apache.flex.html.ImageButton, org.apache.flex.html.Button);


/**
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @protected
 * @override
 */
org.apache.flex.html.ImageButton.prototype.createElement = function() {
  this.element = document.createElement("input");
  this.positioner = this.element;
  this.element.flexjs_wrapper = this;
  var /** @type {HTMLInputElement} */ inputElement = org.apache.flex.utils.Language.as(this.element, HTMLInputElement);
  inputElement.type = "image";
  return this.element;
};


Object.defineProperties(org.apache.flex.html.ImageButton.prototype, /** @lends {org.apache.flex.html.ImageButton.prototype} */ {
/** @export */
source: {
get: /** @this {org.apache.flex.html.ImageButton} */ function() {
  return this.style.backgroundImage;
},
set: /** @this {org.apache.flex.html.ImageButton} */ function(url) {
  if (!this.style)
    this.style = new org.apache.flex.core.SimpleCSSStyles();
  this.style.backgroundImage = url;
  var /** @type {HTMLInputElement} */ inputElement = org.apache.flex.utils.Language.as(this.element, HTMLInputElement);
  inputElement.src = url;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.ImageButton.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ImageButton', qName: 'org.apache.flex.html.ImageButton'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.ImageButton', org.apache.flex.html.ImageButton);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.ImageButton.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'source': { type: 'String', declaredBy: 'org.apache.flex.html.ImageButton'}
      };
    },
    methods: function () {
      return {
        'ImageButton': { type: '', declaredBy: 'org.apache.flex.html.ImageButton'}
      };
    }
  };
};