/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/Image.as
 * org.apache.flex.html.Image
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.Image');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.html.beads.ImageView');
goog.require('org.apache.flex.html.beads.models.ImageModel');
goog.require('org.apache.flex.core.IImageModel');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.UIBase}
 */
org.apache.flex.html.Image = function() {
  org.apache.flex.html.Image.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.Image, org.apache.flex.core.UIBase);


/**
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @protected
 * @override
 */
org.apache.flex.html.Image.prototype.createElement = function() {
  this.element = document.createElement('img');
  this.element.className = 'Image';
  this.typeNames = 'Image';
  this.positioner = this.element;
  this.positioner.style.position = 'relative';
  this.element.flexjs_wrapper = this;
  this.model = new org.apache.flex.html.beads.models.ImageModel();
  this.addBead(new org.apache.flex.html.beads.ImageView());
  return this.element;
};


Object.defineProperties(org.apache.flex.html.Image.prototype, /** @lends {org.apache.flex.html.Image.prototype} */ {
/** @export */
source: {
get: /** @this {org.apache.flex.html.Image} */ function() {
  return this.model.source;
},
set: /** @this {org.apache.flex.html.Image} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IImageModel).source = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.Image.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Image', qName: 'org.apache.flex.html.Image'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.Image', org.apache.flex.html.Image);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.Image.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'source': { type: 'String', declaredBy: 'org.apache.flex.html.Image'}
      };
    },
    methods: function () {
      return {
        'Image': { type: '', declaredBy: 'org.apache.flex.html.Image'}
      };
    }
  };
};