/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/events/ItemClickedEvent.as
 * org.apache.flex.events.ItemClickedEvent
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.events.ItemClickedEvent');

goog.require('org.apache.flex.events.CustomEvent');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.utils.Language');



/**
 * Constructor.
 *
 * @asparam type The name of the event.
 * @asparam bubbles Whether the event bubbles.
 * @asparam cancelable Whether the event can be canceled.
 *
 * @langversion 3.0
 * @playerversion Flash 10.2
 * @playerversion AIR 2.6
 * @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.events.CustomEvent}
 * @param {string} type
 * @param {boolean=} bubbles
 * @param {boolean=} cancelable
 */
org.apache.flex.events.ItemClickedEvent = function(type, bubbles, cancelable) {
  org.apache.flex.events.ItemClickedEvent.base(this, 'constructor');
  bubbles = typeof bubbles !== 'undefined' ? bubbles : false;
  cancelable = typeof cancelable !== 'undefined' ? cancelable : false;
  
  org.apache.flex.events.ItemClickedEvent.base(this, 'constructor', type);
  this.index = -1;
  this.data = null;
  this.multipleSelection = false;
};
goog.inherits(org.apache.flex.events.ItemClickedEvent, org.apache.flex.events.CustomEvent);


/**
 * @export
 * @type {number}
 */
org.apache.flex.events.ItemClickedEvent.prototype.index;


/**
 * @export
 * @type {Object}
 */
org.apache.flex.events.ItemClickedEvent.prototype.data;


/**
 * @export
 * @type {boolean}
 */
org.apache.flex.events.ItemClickedEvent.prototype.multipleSelection;


/**
 * @asprivate
 * @export
 * @override
 */
org.apache.flex.events.ItemClickedEvent.prototype.cloneEvent = function() {
  var /** @type {org.apache.flex.events.ItemClickedEvent} */ newEvent = new org.apache.flex.events.ItemClickedEvent(this.type);
  newEvent.index = this.index;
  newEvent.data = this.data;
  newEvent.multipleSelection = this.multipleSelection;
  return newEvent;
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.events.ItemClickedEvent.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ItemClickedEvent', qName: 'org.apache.flex.events.ItemClickedEvent'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.events.ItemClickedEvent', org.apache.flex.events.ItemClickedEvent);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.events.ItemClickedEvent.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'index': { type: 'Number'},
        'data': { type: 'Object'},
        'multipleSelection': { type: 'Boolean'}
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'ItemClickedEvent': { type: '', declaredBy: 'org.apache.flex.events.ItemClickedEvent'},
        'cloneEvent': { type: 'org.apache.flex.events.Event', declaredBy: 'org.apache.flex.events.ItemClickedEvent'}
      };
    }
  };
};