/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/maps/google/beads/GoogleMapView.as
 * org.apache.flex.maps.google.beads.GoogleMapView
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.maps.google.beads.GoogleMapView');

goog.require('org.apache.flex.core.BeadViewBase');
goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.maps.google.GoogleMap');
goog.require('org.apache.flex.maps.google.models.MapModel');
goog.require('org.apache.flex.core.IBeadModel');
goog.require('org.apache.flex.core.IBeadView');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.BeadViewBase}
 * @implements {org.apache.flex.core.IBeadView}
 */
org.apache.flex.maps.google.beads.GoogleMapView = function() {
  org.apache.flex.maps.google.beads.GoogleMapView.base(this, 'constructor');
};
goog.inherits(org.apache.flex.maps.google.beads.GoogleMapView, org.apache.flex.core.BeadViewBase);


/**
 * @private
 * @type {google.maps.Map}
 */
org.apache.flex.maps.google.beads.GoogleMapView.prototype.realMap;


/**
 * @private
 * @type {google.maps.Geocoder}
 */
org.apache.flex.maps.google.beads.GoogleMapView.prototype.geocoder;


/**
 * @private
 * @type {boolean}
 */
org.apache.flex.maps.google.beads.GoogleMapView.prototype.initialized = false;


/**
 * @private
 * @type {Array}
 */
org.apache.flex.maps.google.beads.GoogleMapView.prototype.markers;


/**
 * @private
 * @type {Array}
 */
org.apache.flex.maps.google.beads.GoogleMapView.prototype.searchResults;


/**
 * @private
 * @type {google.maps.places.PlacesService}
 */
org.apache.flex.maps.google.beads.GoogleMapView.prototype.service;


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.maps.google.beads.GoogleMapView.prototype._strand;


/**
 *  Adjusts the map to the given coordinate and zoom level.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {number} centerLat
 * @param {number} centerLng
 * @param {number} zoom
 */
org.apache.flex.maps.google.beads.GoogleMapView.prototype.mapit = function(centerLat, centerLng, zoom) {
  if (!this.initialized) {
    var /** @type {org.apache.flex.maps.google.models.MapModel} */ model = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.maps.google.models.MapModel);
    model.currentCenter = new google.maps.LatLng(centerLat, centerLng);
    model.zoom = zoom;
    var /** @type {Object} */ mapOptions = new Object();
    mapOptions['center'] = model.currentCenter;
    mapOptions['zoom'] = zoom;
    this.realMap = new google.maps.Map(org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase).element, mapOptions);
    this.geocoder = null;
    model.addEventListener("zoomChanged", org.apache.flex.utils.Language.closure(this.handleModelChange, this, 'handleModelChange'));
    google.maps.event.addListener(this.realMap, 'center_changed', goog.bind(org.apache.flex.utils.Language.closure(this.centerChangeHandler, this, 'centerChangeHandler'), this));
    google.maps.event.addListener(this.realMap, 'bounds_changed', goog.bind(org.apache.flex.utils.Language.closure(this.boundsChangeHandler, this, 'boundsChangeHandler'), this));
    google.maps.event.addListener(this.realMap, 'zoom_changed', goog.bind(org.apache.flex.utils.Language.closure(this.zoomChangeHandler, this, 'zoomChangeHandler'), this));
  }
};


/**
 * @asprivate
 * @private
 */
org.apache.flex.maps.google.beads.GoogleMapView.prototype.finishInitialization = function() {
  this.mapit(37.333, -121.900, 12);
  this.initialized = true;
  this.dispatchEvent(new org.apache.flex.events.Event('ready'));
};


/**
 * Centers the map on the address given.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} value
 */
org.apache.flex.maps.google.beads.GoogleMapView.prototype.centerOnAddress = function(value) {
  if (this.geocoder == null)
    this.geocoder = new google.maps.Geocoder();
  this.geocoder.geocode({address:value}, org.apache.flex.utils.Language.closure(this.positionHandler, this, 'positionHandler'));
};


/**
 * Sets the center of the map.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {google.maps.LatLng} location
 */
org.apache.flex.maps.google.beads.GoogleMapView.prototype.setCenter = function(location) {
  var /** @type {org.apache.flex.maps.google.models.MapModel} */ model = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.maps.google.models.MapModel);
  model.currentCenter = new google.maps.LatLng(location.lat(), location.lng());
  this.realMap.setCenter(model.currentCenter);
};


/**
 * Marks the current center of the map.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 */
org.apache.flex.maps.google.beads.GoogleMapView.prototype.markCurrentLocation = function() {
  var /** @type {org.apache.flex.maps.google.models.MapModel} */ model = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.maps.google.models.MapModel);
  this.createMarker(org.apache.flex.utils.Language.as(model.currentCenter, google.maps.LatLng));
};


/**
 *  Finds the given address and places a marker on it. This function may be dropped
 *  since centerOnAddress + markCurrentLocation does the same thing.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} address
 */
org.apache.flex.maps.google.beads.GoogleMapView.prototype.markAddress = function(address) {
  if (this.initialized) {
    if (this.geocoder == null)
      this.geocoder = new google.maps.Geocoder();
    this.geocoder.geocode({address:address}, org.apache.flex.utils.Language.closure(this.geocodeHandler, this, 'geocodeHandler'));
  }
};


/**
 * Creates a marker for placement on the map.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion google.maps.Marker
 * @export
 * @param {google.maps.LatLng} location
 * @return {Object}
 */
org.apache.flex.maps.google.beads.GoogleMapView.prototype.createMarker = function(location) {
  var /** @type {Object} */ marker = new google.maps.Marker({map:this.realMap, position:location});
  marker.addListener('click', org.apache.flex.utils.Language.closure(this.markerClicked, this, 'markerClicked'));
  return marker;
};


/**
 * Performs a search near the center of map. The result is a set of
 * markers displayed on the map.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} placeName
 */
org.apache.flex.maps.google.beads.GoogleMapView.prototype.nearbySearch = function(placeName) {
  var /** @type {org.apache.flex.maps.google.models.MapModel} */ model = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.maps.google.models.MapModel);
  if (this.markers == null)
    this.markers = [];
  this.service = new google.maps.places.PlacesService(this.realMap);
  this.service.nearbySearch({location:model.currentCenter, radius:5000, name:placeName}, org.apache.flex.utils.Language.closure(this.searchResultsHandler, this, 'searchResultsHandler'));
};


/**
 * Clears the previous search results.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 */
org.apache.flex.maps.google.beads.GoogleMapView.prototype.clearSearchResults = function() {
  if (this.markers) {
    for (var /** @type {number} */ i = 0; i < this.markers.length; i++) {
      var /** @type {google.maps.Marker} */ m = org.apache.flex.utils.Language.as(this.markers[i], google.maps.Marker);
      m.setMap(null);
    }
    this.markers = null;
  }
};


/**
 * @asprivate
 * @export
 */
org.apache.flex.maps.google.beads.GoogleMapView.prototype.centerChangeHandler = function() {
  var /** @type {org.apache.flex.maps.google.models.MapModel} */ model = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.maps.google.models.MapModel);
  model.currentCenter = this.realMap.getCenter();
  var /** @type {org.apache.flex.events.Event} */ newEvent = new org.apache.flex.events.Event('centered');
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher).dispatchEvent(newEvent);
};


/**
 * @asprivate
 * @export
 */
org.apache.flex.maps.google.beads.GoogleMapView.prototype.boundsChangeHandler = function() {
  var /** @type {org.apache.flex.maps.google.models.MapModel} */ model = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.maps.google.models.MapModel);
  model.currentCenter = this.realMap.getCenter();
  var /** @type {org.apache.flex.events.Event} */ newEvent = new org.apache.flex.events.Event('boundsChanged');
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher).dispatchEvent(newEvent);
};


/**
 * @asprivate
 * @export
 */
org.apache.flex.maps.google.beads.GoogleMapView.prototype.zoomChangeHandler = function() {
  var /** @type {org.apache.flex.maps.google.models.MapModel} */ model = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.maps.google.models.MapModel);
  model.currentCenter = this.realMap.getCenter();
  var /** @type {org.apache.flex.events.Event} */ newEvent = new org.apache.flex.events.Event('zoomChanged');
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher).dispatchEvent(newEvent);
};


/**
 * @asprivate
 * @export
 * @param {Array} results
 * @param {string} status
 */
org.apache.flex.maps.google.beads.GoogleMapView.prototype.positionHandler = function(results, status) {
  var /** @type {org.apache.flex.maps.google.models.MapModel} */ model = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.maps.google.models.MapModel);
  if (status == google.maps.GeocoderStatus.OK) {
    model.currentCenter = results[0].geometry.location;
    this.realMap.setCenter(model.currentCenter);
  }
};


/**
 * @flexjsignorecoercion google.maps.Marker
 * @flexjsignorecoercion google.maps.LatLng
 * @export
 * @param {Array} results
 * @param {string} status
 */
org.apache.flex.maps.google.beads.GoogleMapView.prototype.geocodeHandler = function(results, status) {
  var /** @type {org.apache.flex.maps.google.models.MapModel} */ model = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.maps.google.models.MapModel);
  if (status == google.maps.GeocoderStatus.OK) {
    model.currentCenter = results[0].geometry.location;
    this.realMap.setCenter(model.currentCenter);
    var /** @type {Object} */ marker = new google.maps.Marker({map:this.realMap, position:model.currentCenter});
  }
};


/**
 * @asprivate
 * @export
 * @param {Array} results
 * @param {string} status
 */
org.apache.flex.maps.google.beads.GoogleMapView.prototype.searchResultsHandler = function(results, status) {
  this.searchResults = [];
  if (status == google.maps.places.PlacesServiceStatus.OK) {
    for (var /** @type {number} */ i = 0; i < results.length; i++) {
      var /** @type {Object} */ place = results[i];
      this.searchResults.push(place);
      var /** @type {google.maps.Marker} */ marker = this.createMarker(place.geometry.location);
      marker.setTitle(place.name);
      this.markers.push(marker);
    }
    var /** @type {org.apache.flex.maps.google.models.MapModel} */ model = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.maps.google.models.MapModel);
    model.searchResults = this.searchResults;
  }
};


/**
 * Handles changes to properties of the MapModel. When this value is
 * changed, the map itself has its zoom changed. This will trigger an
 * event on the map that will be handled by functions above.
 * @export
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.maps.google.beads.GoogleMapView.prototype.handleModelChange = function(event) {
  if (event.type == "zoomChanged") {
    var /** @type {org.apache.flex.maps.google.models.MapModel} */ model = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.maps.google.models.MapModel);
    this.realMap.setZoom(model.zoom);
  }
};


/**
 * @flexjsignorecoercion google.maps.Marker
 * @flexjsignorecoercion google.maps.LatLng
 * @export
 * @param {Object} marker
 */
org.apache.flex.maps.google.beads.GoogleMapView.prototype.markerClicked = function(marker) {
  var /** @type {Object} */ newMarker = new google.maps.Marker({position:marker["latLng"], title:marker["title"], map:this.realMap});
  var /** @type {org.apache.flex.maps.google.models.MapModel} */ model = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.maps.google.models.MapModel);
  model.selectedMarker = newMarker;
  var /** @type {org.apache.flex.events.Event} */ newEvent = new org.apache.flex.events.Event('markerClicked');
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher, true).dispatchEvent(newEvent);
};


Object.defineProperties(org.apache.flex.maps.google.beads.GoogleMapView.prototype, /** @lends {org.apache.flex.maps.google.beads.GoogleMapView.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.maps.google.beads.GoogleMapView} */ function(value) {
  var self = this;
  var /** @type {Function} */ __localFn0__ = function() {
    org.apache.flex.utils.Language.as(this['mapView'], org.apache.flex.maps.google.beads.GoogleMapView).finishInitialization();
  }
  org.apache.flex.utils.Language.superSetter(org.apache.flex.maps.google.beads.GoogleMapView, this, 'strand', value);
  this._strand = value;
  var /** @type {string} */ token = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.maps.google.GoogleMap).token;
  var /** @type {string} */ src = 'https://maps.googleapis.com/maps/api/js?v=3.exp';
  if (token)
    src += '&key=' + token;
  src += '&libraries=geometry,places&callback=mapInit';
  var /** @type {HTMLScriptElement} */ script = org.apache.flex.utils.Language.as(document.createElement('script'), HTMLScriptElement);
  script.type = 'text/javascript';
  script.src = src;
  window['mapView'] = this;
  window['mapInit'] = __localFn0__;
  document.head.appendChild(script);
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.maps.google.beads.GoogleMapView.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'GoogleMapView', qName: 'org.apache.flex.maps.google.beads.GoogleMapView'}], interfaces: [org.apache.flex.core.IBeadView] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.maps.google.beads.GoogleMapView', org.apache.flex.maps.google.beads.GoogleMapView);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.maps.google.beads.GoogleMapView.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.maps.google.beads.GoogleMapView'}
      };
    },
    methods: function () {
      return {
        'GoogleMapView': { type: '', declaredBy: 'org.apache.flex.maps.google.beads.GoogleMapView'},
        'mapit': { type: 'void', declaredBy: 'org.apache.flex.maps.google.beads.GoogleMapView'},
        'centerOnAddress': { type: 'void', declaredBy: 'org.apache.flex.maps.google.beads.GoogleMapView'},
        'setCenter': { type: 'void', declaredBy: 'org.apache.flex.maps.google.beads.GoogleMapView'},
        'markCurrentLocation': { type: 'void', declaredBy: 'org.apache.flex.maps.google.beads.GoogleMapView'},
        'markAddress': { type: 'void', declaredBy: 'org.apache.flex.maps.google.beads.GoogleMapView'},
        'createMarker': { type: 'Marker', declaredBy: 'org.apache.flex.maps.google.beads.GoogleMapView'},
        'nearbySearch': { type: 'void', declaredBy: 'org.apache.flex.maps.google.beads.GoogleMapView'},
        'clearSearchResults': { type: 'void', declaredBy: 'org.apache.flex.maps.google.beads.GoogleMapView'},
        'centerChangeHandler': { type: 'void', declaredBy: 'org.apache.flex.maps.google.beads.GoogleMapView'},
        'boundsChangeHandler': { type: 'void', declaredBy: 'org.apache.flex.maps.google.beads.GoogleMapView'},
        'zoomChangeHandler': { type: 'void', declaredBy: 'org.apache.flex.maps.google.beads.GoogleMapView'},
        'positionHandler': { type: 'void', declaredBy: 'org.apache.flex.maps.google.beads.GoogleMapView'},
        'geocodeHandler': { type: 'void', declaredBy: 'org.apache.flex.maps.google.beads.GoogleMapView'},
        'searchResultsHandler': { type: 'void', declaredBy: 'org.apache.flex.maps.google.beads.GoogleMapView'},
        'handleModelChange': { type: 'void', declaredBy: 'org.apache.flex.maps.google.beads.GoogleMapView'},
        'markerClicked': { type: 'void', declaredBy: 'org.apache.flex.maps.google.beads.GoogleMapView'}
      };
    }
  };
};