/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from google/maps/LatLngBounds.as
 * google.maps.LatLngBounds
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('google.maps.LatLngBounds');



/**
 * @asparam opt_sw [(google.maps.LatLng|null|undefined)] 
 * @asparam opt_ne [(google.maps.LatLng|null|undefined)] 
 * @see [google_maps_api_v3_11]
 * @constructor
 * @param {google.maps.LatLng=} opt_sw
 * @param {google.maps.LatLng=} opt_ne
 */
google.maps.LatLngBounds = function(opt_sw, opt_ne) {
  opt_sw = typeof opt_sw !== 'undefined' ? opt_sw : null;
  opt_ne = typeof opt_ne !== 'undefined' ? opt_ne : null;
  ;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {(google.maps.LatLng|null)} 
 * @export
 * @return {google.maps.LatLng}
 */
google.maps.LatLngBounds.prototype.getNorthEast = function() {
  return null;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {boolean} 
 * @export
 * @return {boolean}
 */
google.maps.LatLngBounds.prototype.isEmpty = function() {
  return null;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {(google.maps.LatLng|null)} 
 * @export
 * @return {google.maps.LatLng}
 */
google.maps.LatLngBounds.prototype.toSpan = function() {
  return null;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {(google.maps.LatLng|null)} 
 * @export
 * @return {google.maps.LatLng}
 */
google.maps.LatLngBounds.prototype.getCenter = function() {
  return null;
};


/**
 * @asparam other [(google.maps.LatLngBounds|null)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {boolean} 
 * @export
 * @param {google.maps.LatLngBounds} other
 * @return {boolean}
 */
google.maps.LatLngBounds.prototype.equals = function(other) {
  return null;
};


/**
 * @asparam point [(google.maps.LatLng|null)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {(google.maps.LatLngBounds|null)} 
 * @export
 * @param {google.maps.LatLng} point
 * @return {google.maps.LatLngBounds}
 */
google.maps.LatLngBounds.prototype.extend = function(point) {
  return null;
};


/**
 * @asparam other [(google.maps.LatLngBounds|null)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {(google.maps.LatLngBounds|null)} 
 * @export
 * @param {google.maps.LatLngBounds} other
 * @return {google.maps.LatLngBounds}
 */
google.maps.LatLngBounds.prototype.union = function(other) {
  return null;
};


/**
 * @asparam other [(google.maps.LatLngBounds|null)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {boolean} 
 * @export
 * @param {google.maps.LatLngBounds} other
 * @return {boolean}
 */
google.maps.LatLngBounds.prototype.intersects = function(other) {
  return null;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {string} 
 * @export
 * @return {string}
 */
google.maps.LatLngBounds.prototype.toString = function() {
  return null;
};


/**
 * @asparam latLng [(google.maps.LatLng|null)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {boolean} 
 * @export
 * @param {google.maps.LatLng} latLng
 * @return {boolean}
 */
google.maps.LatLngBounds.prototype.contains = function(latLng) {
  return null;
};


/**
 * @asparam opt_precision [(number|undefined)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {string} 
 * @export
 * @param {number=} opt_precision
 * @return {string}
 */
google.maps.LatLngBounds.prototype.toUrlValue = function(opt_precision) {
  opt_precision = typeof opt_precision !== 'undefined' ? opt_precision : 0;
  return null;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {(google.maps.LatLng|null)} 
 * @export
 * @return {google.maps.LatLng}
 */
google.maps.LatLngBounds.prototype.getSouthWest = function() {
  return null;
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
google.maps.LatLngBounds.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'LatLngBounds', qName: 'google.maps.LatLngBounds'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('google.maps.LatLngBounds', google.maps.LatLngBounds);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
google.maps.LatLngBounds.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'LatLngBounds': { type: '', declaredBy: 'google.maps.LatLngBounds'},
        'getNorthEast': { type: 'google.maps.LatLng', declaredBy: 'google.maps.LatLngBounds'},
        'isEmpty': { type: 'Boolean', declaredBy: 'google.maps.LatLngBounds'},
        'toSpan': { type: 'google.maps.LatLng', declaredBy: 'google.maps.LatLngBounds'},
        'getCenter': { type: 'google.maps.LatLng', declaredBy: 'google.maps.LatLngBounds'},
        'equals': { type: 'Boolean', declaredBy: 'google.maps.LatLngBounds'},
        'extend': { type: 'google.maps.LatLngBounds', declaredBy: 'google.maps.LatLngBounds'},
        'union': { type: 'google.maps.LatLngBounds', declaredBy: 'google.maps.LatLngBounds'},
        'intersects': { type: 'Boolean', declaredBy: 'google.maps.LatLngBounds'},
        'toString': { type: 'String', declaredBy: 'google.maps.LatLngBounds'},
        'contains': { type: 'Boolean', declaredBy: 'google.maps.LatLngBounds'},
        'toUrlValue': { type: 'String', declaredBy: 'google.maps.LatLngBounds'},
        'getSouthWest': { type: 'google.maps.LatLng', declaredBy: 'google.maps.LatLngBounds'}
      };
    }
  };
};