/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/effects/Wipe.as
 * org.apache.flex.effects.Wipe
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.effects.Wipe');

goog.require('org.apache.flex.effects.PlatformWiper');
goog.require('org.apache.flex.effects.Tween');
goog.require('org.apache.flex.geom.Rectangle');
goog.require('org.apache.flex.core.IDocument');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *
 *  @asparam target Object ID or reference to an object that will
 *  have its x and/or y property animated.
 *
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @constructor
 * @extends {org.apache.flex.effects.Tween}
 * @implements {org.apache.flex.core.IDocument}
 * @param {org.apache.flex.core.IUIBase=} target
 */
org.apache.flex.effects.Wipe = function(target) {
  target = typeof target !== 'undefined' ? target : null;
  
  this.wiper = new org.apache.flex.effects.PlatformWiper();
  org.apache.flex.effects.Wipe.base(this, 'constructor');
  this.actualTarget = target;
  this.listener = this;
};
goog.inherits(org.apache.flex.effects.Wipe, org.apache.flex.effects.Tween);


/**
 * @private
 * @type {Object}
 */
org.apache.flex.effects.Wipe.prototype.document;


/**
 * @private
 * @type {org.apache.flex.core.IUIBase}
 */
org.apache.flex.effects.Wipe.prototype.actualTarget;


/**
 * @export
 * @type {string}
 */
org.apache.flex.effects.Wipe.prototype.target;


/**
 * @export
 * @type {string}
 */
org.apache.flex.effects.Wipe.prototype.direction;


/**
 * @private
 * @type {org.apache.flex.effects.PlatformWiper}
 */
org.apache.flex.effects.Wipe.prototype.wiper;


/**
 * @export
 * @param {Object} document
 * @param {string=} id
 */
org.apache.flex.effects.Wipe.prototype.setDocument = function(document, id) {
  id = typeof id !== 'undefined' ? id : null;
  this.document = document;
};


/**
 *  @asprivate
 * @export
 * @override
 */
org.apache.flex.effects.Wipe.prototype.play = function() {
  if (this.target != null)
    this.actualTarget = this.document[this.target];
  this.wiper.target = this.actualTarget;
  if (this.direction == "up") {
    this.startValue = this.actualTarget.height;
    this.endValue = 0;
  } else {
    this.startValue = 0;
    this.endValue = this.actualTarget.height;
    this.actualTarget.visible = true;
    this.wiper.visibleRect = new org.apache.flex.geom.Rectangle(0, 0, this.actualTarget.width, 0);
  }
  org.apache.flex.effects.Wipe.base(this, 'play');
};


/**
 * @export
 * @param {number} value
 */
org.apache.flex.effects.Wipe.prototype.onTweenUpdate = function(value) {
  org.apache.flex.utils.Language.trace(this.actualTarget, value);
  this.wiper.visibleRect = new org.apache.flex.geom.Rectangle(0, 0, this.actualTarget.width, value);
};


/**
 * @export
 * @param {number} value
 */
org.apache.flex.effects.Wipe.prototype.onTweenEnd = function(value) {
  if (this.direction == "up")
    this.actualTarget.visible = false;
  this.wiper.target = null;
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.effects.Wipe.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Wipe', qName: 'org.apache.flex.effects.Wipe'}], interfaces: [org.apache.flex.core.IDocument] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.effects.Wipe', org.apache.flex.effects.Wipe);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.effects.Wipe.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'target': { type: 'String'},
        'direction': { type: 'String'}
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'Wipe': { type: '', declaredBy: 'org.apache.flex.effects.Wipe'},
        'setDocument': { type: 'void', declaredBy: 'org.apache.flex.effects.Wipe'},
        'play': { type: 'void', declaredBy: 'org.apache.flex.effects.Wipe'},
        'onTweenUpdate': { type: 'void', declaredBy: 'org.apache.flex.effects.Wipe'},
        'onTweenEnd': { type: 'void', declaredBy: 'org.apache.flex.effects.Wipe'}
      };
    }
  };
};