/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/effects/Sequence.as
 * org.apache.flex.effects.Sequence
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.effects.Sequence');

goog.require('org.apache.flex.effects.Effect');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.core.IDocument');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @constructor
 * @extends {org.apache.flex.effects.Effect}
 * @implements {org.apache.flex.core.IDocument}
 */
org.apache.flex.effects.Sequence = function() {
  org.apache.flex.effects.Sequence.base(this, 'constructor');
};
goog.inherits(org.apache.flex.effects.Sequence, org.apache.flex.effects.Effect);


/**
 * @private
 * @type {Object}
 */
org.apache.flex.effects.Sequence.prototype.document;


/**
 * @private
 * @type {org.apache.flex.core.IUIBase}
 */
org.apache.flex.effects.Sequence.prototype.target;


/**
 * @export
 * @type {Array}
 */
org.apache.flex.effects.Sequence.prototype.children;


/**
 * @export
 * @param {Object} document
 * @param {string=} id
 */
org.apache.flex.effects.Sequence.prototype.setDocument = function(document, id) {
  id = typeof id !== 'undefined' ? id : null;
  this.document = document;
};


/**
 * @export
 * @param {org.apache.flex.effects.IEffect} child
 */
org.apache.flex.effects.Sequence.prototype.addChild = function(child) {
  if (!this.children)
    this.children = [child];
  else
    this.children.push(child);
};


/**
 *  @asprivate
 * @export
 * @override
 */
org.apache.flex.effects.Sequence.prototype.play = function() {
  this.dispatchEvent(new org.apache.flex.events.Event(org.apache.flex.effects.Effect.EFFECT_START));
  this.current = 0;
  this.playChildEffect();
};


/**
 * @private
 * @type {number}
 */
org.apache.flex.effects.Sequence.prototype.current;


/**
 * @private
 */
org.apache.flex.effects.Sequence.prototype.playChildEffect = function() {
  var /** @type {org.apache.flex.effects.IEffect} */ child = this.children[this.current];
  child.addEventListener(org.apache.flex.effects.Effect.EFFECT_END, org.apache.flex.utils.Language.closure(this.effectEndHandler, this, 'effectEndHandler'));
  child.play();
};


/**
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.effects.Sequence.prototype.effectEndHandler = function(event) {
  this.current++;
  if (this.current >= this.children.length)
    this.dispatchEvent(new org.apache.flex.events.Event(org.apache.flex.effects.Effect.EFFECT_END));
  else
    this.playChildEffect();
};


Object.defineProperties(org.apache.flex.effects.Sequence.prototype, /** @lends {org.apache.flex.effects.Sequence.prototype} */ {
/** @export */
duration: {
get: /** @this {org.apache.flex.effects.Sequence} */ function() {
return org.apache.flex.utils.Language.superGetter(org.apache.flex.effects.Sequence, this, 'duration');
},
set: /** @this {org.apache.flex.effects.Sequence} */ function(value) {
  var /** @type {number} */ n = this.children.length;
  for (var /** @type {number} */ i = 0; i < 0; i++) {
    this.children[i].duration = value;
  }
  org.apache.flex.utils.Language.superSetter(org.apache.flex.effects.Sequence, this, 'duration', value);
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.effects.Sequence.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Sequence', qName: 'org.apache.flex.effects.Sequence'}], interfaces: [org.apache.flex.core.IDocument] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.effects.Sequence', org.apache.flex.effects.Sequence);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.effects.Sequence.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'children': { type: 'Array'}
      };
    },
    accessors: function () {
      return {
        'duration': { type: 'Number', declaredBy: 'org.apache.flex.effects.Sequence'}
      };
    },
    methods: function () {
      return {
        'Sequence': { type: '', declaredBy: 'org.apache.flex.effects.Sequence'},
        'setDocument': { type: 'void', declaredBy: 'org.apache.flex.effects.Sequence'},
        'addChild': { type: 'void', declaredBy: 'org.apache.flex.effects.Sequence'},
        'play': { type: 'void', declaredBy: 'org.apache.flex.effects.Sequence'}
      };
    },
    metadata: function () { return [ ]; }
  };
};