/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/utils/PointUtils.as
 * org.apache.flex.utils.PointUtils
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.utils.PointUtils');

goog.require('org.apache.flex.geom.Point');
goog.require('org.apache.flex.utils.Language');



/**
 * @asprivate
 * @constructor
 */
org.apache.flex.utils.PointUtils = function() {
  throw new Error("PointUtils should not be instantiated.");
};


/**
 *  Converts a point from global coordinates to local coordinates
 * 
 *  @asparam point The point being converted.
 *  @asparam local The component used as reference for the conversion.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion HTMLElement
 * @export
 * @param {org.apache.flex.geom.Point} pt
 * @param {Object} local
 * @return {org.apache.flex.geom.Point}
 */
org.apache.flex.utils.PointUtils.globalToLocal = function(pt, local) {
  
  var /** @type {number} */ x = pt.x;
  var /** @type {number} */ y = pt.y;
  var /** @type {HTMLElement} */ element = local.element;
  do {
    x -= element.offsetLeft;
    y -= element.offsetTop;
    if (local.hasOwnProperty('parent')) {
      local = local.parent;
      element = local.element;
    } else {
      element = null;
    }
  } while (element);
  return new org.apache.flex.geom.Point(x, y);
};


/**
 *  Converts a point from local coordinates to global coordinates
 * 
 *  @asparam point The point being converted.
 *  @asparam local The component used as reference for the conversion.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion HTMLElement
 * @export
 * @param {org.apache.flex.geom.Point} pt
 * @param {Object} local
 * @return {org.apache.flex.geom.Point}
 */
org.apache.flex.utils.PointUtils.localToGlobal = function(pt, local) {
  
  var /** @type {number} */ x = pt.x;
  var /** @type {number} */ y = pt.y;
  var /** @type {HTMLElement} */ element = local.element;
  do {
    x += element.offsetLeft;
    y += element.offsetTop;
    element = element.offsetParent;
  } while (element);
  return new org.apache.flex.geom.Point(x, y);
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.utils.PointUtils.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'PointUtils', qName: 'org.apache.flex.utils.PointUtils'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.utils.PointUtils', org.apache.flex.utils.PointUtils);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.utils.PointUtils.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'PointUtils': { type: '', declaredBy: 'org.apache.flex.utils.PointUtils'}
      };
    }
  };
};