/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/utils/CSSUtils.as
 * org.apache.flex.utils.CSSUtils
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.utils.CSSUtils');

goog.require('org.apache.flex.utils.StringPadder');
goog.require('org.apache.flex.utils.Language');



/**
 * @asprivate
 * @constructor
 */
org.apache.flex.utils.CSSUtils = function() {
  throw new Error("CSSUtils should not be instantiated.");
};


/**
 * @export
 * @param {number} value
 * @return {string}
 */
org.apache.flex.utils.CSSUtils.attributeFromColor = function(value) {
  return "#" + org.apache.flex.utils.StringPadder.pad(value.toString(16), "0", 6);
};


/**
 *  Converts a String to number.
 *
 *  @asparam str The String. 
 *  @asparam reference A Number that will be used to convert percentages. 
 *
 *  @asreturn Number. 
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} str
 * @param {number=} reference
 * @return {number}
 */
org.apache.flex.utils.CSSUtils.toNumber = function(str, reference) {
  reference = typeof reference !== 'undefined' ? reference : 0;
  var /** @type {number} */ c = str.indexOf("px");
  if (c != -1)
    return Number(str.substr(0, c));
  c = str.indexOf("%");
  if (c != -1)
    return Number(str.substr(0, c)) * reference / 100;
  return Number(str);
};


/**
 *  Converts a value describing a color to a uint 
 *
 *  @asparam value The value. 
 *
 *  @asreturn uint of the color. 
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} value
 * @return {number}
 */
org.apache.flex.utils.CSSUtils.toColor = function(value) {
  return org.apache.flex.utils.CSSUtils.toColorWithAlpha(value) & 0xFFFFFF;
};


/**
 *  Converts a value describing a color and alpha in a uint 
 *
 *  @asparam value The value. 
 *
 *  @asreturn uint of the color. If value is "transparent" then uint.MAX_VALUE is returned.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion String
 * @export
 * @param {Object} value
 * @return {number}
 */
org.apache.flex.utils.CSSUtils.toColorWithAlpha = function(value) {
  if (!org.apache.flex.utils.Language.is(value, String))
    return org.apache.flex.utils.Language.uint(value) | 0xFF000000;
  var /** @type {number} */ c;
  var /** @type {number} */ c2;
  var /** @type {string} */ stringValue = value;
  if (stringValue == "transparent") {
    return 4294967295;
  }
  if (stringValue.charAt(0) == '#') {
    if (stringValue.length == 4)
      return org.apache.flex.utils.Language.uint("0x" + stringValue.charAt(1) + stringValue.charAt(1) + stringValue.charAt(2) + stringValue.charAt(2) + stringValue.charAt(3) + stringValue.charAt(3));
    if (stringValue.length == 7)
      return org.apache.flex.utils.Language.uint("0xFF" + stringValue.substr(1));
    return org.apache.flex.utils.Language.uint("0x" + stringValue.substr(1));
  } else if ((c = stringValue.indexOf("rgb(")) != -1) {
    c2 = stringValue.indexOf(")");
    stringValue = stringValue.substring(c + 4, c2);
    var /** @type {Array} */ parts3 = stringValue.split(",");
    return (0xFF000000 + org.apache.flex.utils.Language.uint(parts3[0]) << 16 + org.apache.flex.utils.Language.uint(parts3[1]) << 8 + org.apache.flex.utils.Language.uint(parts3[2]));
  } else if ((c = stringValue.indexOf("rgba(")) != -1) {
    c2 = stringValue.indexOf(")");
    stringValue = stringValue.substring(c + 4, c2);
    var /** @type {Array} */ parts4 = stringValue.split(",");
    return (org.apache.flex.utils.Language.uint(parts4[3]) << 24 + org.apache.flex.utils.Language.uint(parts3[0]) << 16 + org.apache.flex.utils.Language.uint(parts3[1]) << 8 + org.apache.flex.utils.Language.uint(parts3[2]));
  }
  if (org.apache.flex.utils.CSSUtils.colorMap.hasOwnProperty(stringValue))
    return org.apache.flex.utils.CSSUtils.colorMap[stringValue];
  return org.apache.flex.utils.Language.uint(stringValue);
};


/**
 *  Computes paddingTop or marginTop.
 *
 *  @asparam value The value of padding-top or margin-top. 
 *  @asparam values The value of padding or margin. 
 *  @asparam reference A Number that will be used to convert percentages. 
 *
 *  @asreturn Number. 
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion String
 * @export
 * @param {Object} value
 * @param {Object} values
 * @param {number=} reference
 * @return {number}
 */
org.apache.flex.utils.CSSUtils.getTopValue = function(value, values, reference) {
  reference = typeof reference !== 'undefined' ? reference : NaN;
  return org.apache.flex.utils.CSSUtils.getSideValue(value, values, 0, reference);
};


/**
 *  Computes paddingRight or marginRight.
 *
 *  @asparam value The value of padding-right or margin-right. 
 *  @asparam values The value of padding or margin. 
 *  @asparam reference A Number that will be used to convert percentages. 
 *
 *  @asreturn Number. 
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion String
 * @export
 * @param {Object} value
 * @param {Object} values
 * @param {number=} reference
 * @return {number}
 */
org.apache.flex.utils.CSSUtils.getRightValue = function(value, values, reference) {
  reference = typeof reference !== 'undefined' ? reference : NaN;
  return org.apache.flex.utils.CSSUtils.getSideValue(value, values, 1, reference);
};


/**
 *  Computes paddingBottom or marginBottom.
 *
 *  @asparam value The value of padding-bottom or margin-bottom. 
 *  @asparam values The value of padding or margin. 
 *  @asparam reference A Number that will be used to convert percentages. 
 *
 *  @asreturn Number. 
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion String
 * @export
 * @param {Object} value
 * @param {Object} values
 * @param {number=} reference
 * @return {number}
 */
org.apache.flex.utils.CSSUtils.getBottomValue = function(value, values, reference) {
  reference = typeof reference !== 'undefined' ? reference : NaN;
  return org.apache.flex.utils.CSSUtils.getSideValue(value, values, 2, reference);
};


/**
 *  Computes paddingLeft or marginLeft.
 *
 *  @asparam value The value of padding-left or margin-left. 
 *  @asparam values The value of padding or margin. 
 *  @asparam reference A Number that will be used to convert percentages. 
 *
 *  @asreturn Number. 
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion String
 * @export
 * @param {Object} value
 * @param {Object} values
 * @param {number=} reference
 * @return {number}
 */
org.apache.flex.utils.CSSUtils.getLeftValue = function(value, values, reference) {
  reference = typeof reference !== 'undefined' ? reference : NaN;
  return org.apache.flex.utils.CSSUtils.getSideValue(value, values, 3, reference);
};


/**
 *  Computes padding or margin.
 *
 *  @asparam value The value of padding or margin.
 *  @asparam values The value of padding or margin. 
 *  @asparam side Which side we want to get. 0 = top, 1 = right, 2 = bottom, 3 = left
 *  @asparam reference A Number that will be used to convert percentages. 
 *
 *  @asreturn Number. 
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion String
 * @export
 * @param {Object} value
 * @param {Object} values
 * @param {number} side
 * @param {number=} reference
 * @return {number}
 */
org.apache.flex.utils.CSSUtils.getSideValue = function(value, values, side, reference) {
  reference = typeof reference !== 'undefined' ? reference : NaN;
  if (org.apache.flex.utils.Language.is(value, Number))
    return org.apache.flex.utils.Language.as(value, Number);
  if (org.apache.flex.utils.Language.is(values, Number))
    return org.apache.flex.utils.Language.as(values, Number);
  if (value != null)
    return org.apache.flex.utils.CSSUtils.toNumber(value, reference);
  if (values == null)
    return 0;
  if (org.apache.flex.utils.Language.is(values, Array)) {
    value = org.apache.flex.utils.CSSUtils.getArrayValue(org.apache.flex.utils.Language.as(values, Array), side);
    if (org.apache.flex.utils.Language.is(value, String))
      return org.apache.flex.utils.CSSUtils.toNumber(value, reference);
    return org.apache.flex.utils.Language.as(value, Number);
  }
  return org.apache.flex.utils.CSSUtils.toNumber(values, reference);
};


/**
 *  @asprivate
 *  
 *  side should be an int 0 = top, 1 = right, 2 = bottom, 3 = left
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @private
 * @param {Array} arr
 * @param {number} side
 * @return {Object}
 */
org.apache.flex.utils.CSSUtils.getArrayValue = function(arr, side) {
  var /** @type {number} */ n = arr.length;
  switch (side) {
    case 2:
      side = n == 2 ? 0 : 2;
      break;
    case 3:
      side = n < 3 ? 1 : 3;
      break;
    default:
      break;
  }
  return arr[side];
};


/**
 * @export
 * @type {Object}
 */
org.apache.flex.utils.CSSUtils.colorMap = {transparent:0, white:0xFFFFFFFF, silver:0xFFC0C0C0, gray:0xFF808080, black:0xFF000000, red:0xFFFF0000, maroon:0xFF800000, yellow:0xFFFFFF00, olive:0xFF808000, lime:0xFF00FF00, green:0xFF008000, aqua:0xFF00FFFF, teal:0xFF008080, blue:0xFF0000FF, navy:0xFF000080, fuchsia:0xFFFF00FF, purple:0xFF800080};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.utils.CSSUtils.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'CSSUtils', qName: 'org.apache.flex.utils.CSSUtils'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.utils.CSSUtils', org.apache.flex.utils.CSSUtils);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.utils.CSSUtils.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'CSSUtils': { type: '', declaredBy: 'org.apache.flex.utils.CSSUtils'}
      };
    }
  };
};